/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.gstreamer.Gst;
import org.gstreamer.swing.VideoPlayer;

public class ButtonDemo {
    static final String name = "ButtonDemo";

    public static void main(String[] args) {
        if ((args = Gst.init(name, args)).length < 1) {
            System.err.println("Usage: ButtonDemo <filename>");
            System.exit(1);
        }
        final File[] files = new File[args.length];
        for (int i = 0; i < args.length; ++i) {
            files[i] = new File(args[i]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame(ButtonDemo.name);
                JPanel panel = new JPanel();
                frame.add(panel);
                panel.setLayout(new FlowLayout(0));
                for (int i = 0; i < files.length; ++i) {
                    final File file = files[i];
                    final VideoPlayer player = new VideoPlayer(file);
                    player.setPreferredSize(new Dimension(160, 100));
                    player.setControlsVisible(false);
                    JButton button = new JButton(file.getName());
                    button.setLayout(new BoxLayout(button, 1));
                    button.add(player);
                    button.addActionListener(new ActionListener(){
                        boolean playing = true;

                        public void actionPerformed(ActionEvent evt) {
                            System.out.println("Button " + file.getName() + " clicked");
                            if (!this.playing) {
                                player.getMediaPlayer().play();
                                this.playing = true;
                            } else {
                                this.playing = false;
                                player.getMediaPlayer().pause();
                            }
                        }
                    });
                    button.setVerticalTextPosition(3);
                    JLabel label = new JLabel(file.getName());
                    label.setHorizontalTextPosition(0);
                    label.setHorizontalAlignment(0);
                    JPanel box = new JPanel();
                    box.setLayout(new BorderLayout());
                    box.add((Component)label, "South");
                    box.setOpaque(false);
                    button.add(box);
                    panel.add(button);
                    Timer timer = new Timer(2000 * i, new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            player.getMediaPlayer().play();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

