/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import java.util.List;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;

public abstract class MonitorDevice {
    protected final Screen screen;
    protected final int nativeId;
    protected final DimensionImmutable sizeMM;
    protected final MonitorMode originalMode;
    protected final ArrayHashSet<MonitorMode> supportedModes;
    protected MonitorMode currentMode;
    protected boolean modeChanged;
    protected Rectangle viewportPU;
    protected Rectangle viewportWU;

    protected MonitorDevice(Screen screen, int n, DimensionImmutable dimensionImmutable, Rectangle rectangle, Rectangle rectangle2, MonitorMode monitorMode, ArrayHashSet<MonitorMode> arrayHashSet) {
        this.screen = screen;
        this.nativeId = n;
        this.sizeMM = dimensionImmutable;
        this.originalMode = monitorMode;
        this.supportedModes = arrayHashSet;
        this.currentMode = monitorMode;
        this.viewportPU = rectangle;
        this.viewportWU = rectangle2;
        this.modeChanged = false;
    }

    public final Screen getScreen() {
        return this.screen;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorDevice) {
            MonitorDevice monitorDevice = (MonitorDevice)object;
            return monitorDevice.nativeId == this.nativeId;
        }
        return false;
    }

    public final int hashCode() {
        return this.nativeId;
    }

    public final int getId() {
        return this.nativeId;
    }

    public final DimensionImmutable getSizeMM() {
        return this.sizeMM;
    }

    public final float[] getPixelsPerMM(float[] fArray) {
        return this.getPixelsPerMM(this.getCurrentMode(), fArray);
    }

    public final float[] getPixelsPerMM(MonitorMode monitorMode, float[] fArray) {
        DimensionImmutable dimensionImmutable = this.getSizeMM();
        DimensionImmutable dimensionImmutable2 = monitorMode.getSurfaceSize().getResolution();
        fArray[0] = (float)dimensionImmutable2.getWidth() / (float)dimensionImmutable.getWidth();
        fArray[1] = (float)dimensionImmutable2.getHeight() / (float)dimensionImmutable.getHeight();
        return fArray;
    }

    public final MonitorMode getOriginalMode() {
        return this.originalMode;
    }

    public final List<MonitorMode> getSupportedModes() {
        return this.supportedModes.getData();
    }

    public final RectangleImmutable getViewport() {
        return this.viewportPU;
    }

    public final RectangleImmutable getViewportInWindowUnits() {
        return this.viewportWU;
    }

    public final boolean contains(int n, int n2) {
        return n >= this.viewportPU.getX() && n < this.viewportPU.getX() + this.viewportPU.getWidth() && n2 >= this.viewportPU.getY() && n2 < this.viewportPU.getY() + this.viewportPU.getHeight();
    }

    public static void unionOfViewports(Rectangle rectangle, Rectangle rectangle2, List<MonitorDevice> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        for (int i = list.size() - 1; i >= 0; --i) {
            RectangleImmutable rectangleImmutable;
            if (null != rectangle) {
                rectangleImmutable = list.get(i).getViewport();
                n = Math.min(n, rectangleImmutable.getX());
                n3 = Math.max(n3, rectangleImmutable.getX() + rectangleImmutable.getWidth());
                n2 = Math.min(n2, rectangleImmutable.getY());
                n4 = Math.max(n4, rectangleImmutable.getY() + rectangleImmutable.getHeight());
            }
            if (null == rectangle2) continue;
            rectangleImmutable = list.get(i).getViewportInWindowUnits();
            n5 = Math.min(n5, rectangleImmutable.getX());
            n7 = Math.max(n7, rectangleImmutable.getX() + rectangleImmutable.getWidth());
            n6 = Math.min(n6, rectangleImmutable.getY());
            n8 = Math.max(n8, rectangleImmutable.getY() + rectangleImmutable.getHeight());
        }
        if (null != rectangle) {
            rectangle.set(n, n2, n3 - n, n4 - n2);
        }
        if (null != rectangle2) {
            rectangle2.set(n5, n6, n7 - n5, n8 - n6);
        }
    }

    public final boolean isOriginalMode() {
        return this.currentMode.hashCode() == this.originalMode.hashCode();
    }

    public final boolean isModeChangedByUs() {
        return this.modeChanged && !this.isOriginalMode();
    }

    public final MonitorMode getCurrentMode() {
        return this.currentMode;
    }

    public abstract MonitorMode queryCurrentMode();

    public abstract boolean setCurrentMode(MonitorMode var1);

    public String toString() {
        return "Monitor[Id " + Display.toHexString(this.nativeId) + ", " + this.sizeMM + " mm, viewport " + this.viewportPU + " [pixels], " + this.viewportWU + " [window], orig " + this.originalMode + ", curr " + this.currentMode + ", modeChanged " + this.modeChanged + ", modeCount " + this.supportedModes.size() + "]";
    }
}

