/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.newt.event.MonitorModeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class ScreenMonitorState {
    private static boolean DEBUG = Screen.DEBUG;
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final ArrayHashSet<MonitorDevice> allMonitors;
    private final ArrayHashSet<MonitorMode> allMonitorModes;
    private final ArrayList<MonitorModeListener> listener = new ArrayList();
    private static HashMap<String, ScreenMonitorState> screenFQN2ScreenMonitorState = new HashMap();
    private static RecursiveLock screen2ScreenMonitorState = LockFactory.createRecursiveLock();

    protected static void mapScreenMonitorState(String string, ScreenMonitorState screenMonitorState) {
        screen2ScreenMonitorState.lock();
        try {
            ScreenMonitorState screenMonitorState2 = screenFQN2ScreenMonitorState.get(string);
            if (null != screenMonitorState2) {
                throw new RuntimeException("ScreenMonitorState " + screenMonitorState2 + " already mapped to " + string);
            }
            screenFQN2ScreenMonitorState.put(string, screenMonitorState);
            if (DEBUG) {
                System.err.println("ScreenMonitorState.map " + string + " -> " + screenMonitorState);
            }
        }
        finally {
            screen2ScreenMonitorState.unlock();
        }
    }

    protected static void unmapScreenMonitorState(String string) {
        screen2ScreenMonitorState.lock();
        try {
            ScreenMonitorState.unmapScreenMonitorStateUnlocked(string);
        }
        finally {
            screen2ScreenMonitorState.unlock();
        }
    }

    protected static void unmapScreenMonitorStateUnlocked(String string) {
        ScreenMonitorState screenMonitorState = screenFQN2ScreenMonitorState.remove(string);
        if (DEBUG) {
            System.err.println("ScreenMonitorState.unmap " + string + " -> " + screenMonitorState);
        }
    }

    protected static ScreenMonitorState getScreenMonitorState(String string) {
        screen2ScreenMonitorState.lock();
        try {
            ScreenMonitorState screenMonitorState = ScreenMonitorState.getScreenMonitorStateUnlocked(string);
            return screenMonitorState;
        }
        finally {
            screen2ScreenMonitorState.unlock();
        }
    }

    protected static ScreenMonitorState getScreenMonitorStateUnlocked(String string) {
        return screenFQN2ScreenMonitorState.get(string);
    }

    protected static void lockScreenMonitorState() {
        screen2ScreenMonitorState.lock();
    }

    protected static void unlockScreenMonitorState() {
        screen2ScreenMonitorState.unlock();
    }

    public ScreenMonitorState(ArrayHashSet<MonitorDevice> arrayHashSet, ArrayHashSet<MonitorMode> arrayHashSet2) {
        this.allMonitors = arrayHashSet;
        this.allMonitorModes = arrayHashSet2;
    }

    protected ArrayHashSet<MonitorDevice> getMonitorDevices() {
        return this.allMonitors;
    }

    protected ArrayHashSet<MonitorMode> getMonitorModes() {
        return this.allMonitorModes;
    }

    protected final int addListener(MonitorModeListener monitorModeListener) {
        this.lock();
        try {
            this.listener.add(monitorModeListener);
            if (DEBUG) {
                System.err.println("ScreenMonitorState.addListener (size: " + this.listener.size() + "): " + monitorModeListener);
            }
            int n = this.listener.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    protected final int removeListener(MonitorModeListener monitorModeListener) {
        this.lock();
        try {
            if (!this.listener.remove(monitorModeListener)) {
                throw new RuntimeException("MonitorModeListener " + monitorModeListener + " not contained");
            }
            if (DEBUG) {
                System.err.println("ScreenMonitorState.removeListener (size: " + this.listener.size() + "): " + monitorModeListener);
            }
            int n = this.listener.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    protected final MonitorDevice getMonitor(MonitorDevice monitorDevice) {
        return (MonitorDevice)this.allMonitors.get((Object)monitorDevice);
    }

    protected final void validateMonitor(MonitorDevice monitorDevice) {
        MonitorDevice monitorDevice2 = (MonitorDevice)this.allMonitors.get((Object)monitorDevice);
        if (null == monitorDevice2) {
            throw new InternalError("Monitor unknown: " + monitorDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireMonitorModeChangeNotify(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        this.lock();
        try {
            this.validateMonitor(monitorDevice);
            MonitorEvent monitorEvent = new MonitorEvent(600, monitorDevice, System.currentTimeMillis(), monitorMode);
            for (int i = 0; i < this.listener.size(); ++i) {
                this.listener.get(i).monitorModeChangeNotify(monitorEvent);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMonitorModeChanged(MonitorDevice monitorDevice, MonitorMode monitorMode, boolean bl) {
        this.lock();
        try {
            this.validateMonitor(monitorDevice);
            MonitorEvent monitorEvent = new MonitorEvent(601, monitorDevice, System.currentTimeMillis(), monitorMode);
            for (int i = 0; i < this.listener.size(); ++i) {
                this.listener.get(i).monitorModeChanged(monitorEvent, bl);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected final void lock() throws RuntimeException {
        this.lock.lock();
    }

    protected final void unlock() throws RuntimeException {
        this.lock.unlock();
    }
}

