/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlacklistedCerts;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class X509TrustManagerDelegate {
    private static final String[] SUPPORTED_ALGS = new String[]{"HTTPS"};
    private CertStore sslRootStore;
    private CertStore permanentStore;
    private CertStore sessionStore;
    private CertStore deniedStore;
    private CertStore browserSSLRootStore;
    private CertStore browserUntrustedStore;
    private Collection acceptedIssuers = new LinkedList();
    private boolean alwaysShow;
    private boolean mismatchShow;
    private boolean browserSSLRootStoreLoaded = false;
    private boolean browserUntrustedStoreLoaded = false;
    private volatile boolean isInitialized = false;
    private static volatile boolean resetRequested = true;

    X509TrustManagerDelegate() {
    }

    static void reset() {
        resetRequested = true;
    }

    private void initCertStores() {
        this.sslRootStore = SSLRootCertStore.getCertStore();
        this.permanentStore = DeploySSLCertStore.getCertStore();
        this.sessionStore = new SessionCertStore("x509");
        this.deniedStore = new DeniedCertStore();
        this.alwaysShow = Config.getBooleanProperty("deployment.security.https.warning.show");
        this.mismatchShow = Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning");
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            this.browserSSLRootStore = service.getBrowserSSLRootCertStore();
            this.browserUntrustedStore = service.getBrowserUntrustedCertStore();
        } else {
            this.browserSSLRootStore = null;
            this.browserUntrustedStore = null;
        }
        this.browserSSLRootStoreLoaded = false;
        this.browserUntrustedStoreLoaded = false;
    }

    private X509TrustManager createTrustManager(List list) throws Exception {
        Object object;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof X509Certificate)) continue;
            hashSet.add(new TrustAnchor((X509Certificate)object, null));
        }
        object2 = new PKIXBuilderParameters(hashSet, null);
        ((PKIXParameters)object2).setRevocationEnabled(false);
        object = new CertPathTrustManagerParameters((CertPathParameters)object2);
        trustManagerFactory.init((ManagerFactoryParameters)object);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        return (X509TrustManager)trustManagerArray[0];
    }

    private void reloadCertStores() throws Exception {
        if (resetRequested || !this.isInitialized) {
            this.initCertStores();
            resetRequested = false;
            this.isInitialized = true;
        }
        this.acceptedIssuers.clear();
        if (this.sslRootStore != null) {
            this.sslRootStore.load();
            this.acceptedIssuers.addAll(this.sslRootStore.getCertificates());
        }
        if (this.permanentStore != null) {
            this.permanentStore.load();
        }
        if (this.sessionStore != null) {
            this.sessionStore.load();
        }
        if (this.deniedStore != null) {
            this.deniedStore.load();
        }
        if (this.browserSSLRootStore != null && !this.browserSSLRootStoreLoaded) {
            this.browserSSLRootStore.load();
            this.browserSSLRootStoreLoaded = true;
            this.acceptedIssuers.addAll(this.browserSSLRootStore.getCertificates());
        }
        if (this.browserUntrustedStore != null && !this.browserUntrustedStoreLoaded) {
            this.browserUntrustedStore.load();
            this.browserUntrustedStoreLoaded = true;
        }
    }

    public final synchronized void checkTrusted(X509Certificate[] x509CertificateArray, String string, String string2, int n, String string3, BasicTrustManagerDelegate basicTrustManagerDelegate, boolean bl) throws CertificateException {
        if (string3 != null && !this.isSupportedAlgorithm(string3)) {
            throw new CertificateException("Not supported algorithm:" + string3);
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = -1;
        try {
            int n4;
            this.reloadCertStores();
            if (this.deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            this.untrustedCertsCheck(this.browserUntrustedStore, x509CertificateArray);
            if (this.sessionStore.contains(x509CertificateArray[0])) {
                return;
            }
            if (this.permanentStore.contains(x509CertificateArray[0])) {
                return;
            }
            LazyRootStore lazyRootStore = new LazyRootStore(this.browserSSLRootStore, this.sslRootStore);
            LinkedList<X509Certificate> linkedList = lazyRootStore.getTrustAnchors(x509CertificateArray[x509CertificateArray.length - 1]);
            if (linkedList == null) {
                bl2 = true;
                linkedList = new LinkedList<X509Certificate>();
                linkedList.add(x509CertificateArray[x509CertificateArray.length - 1]);
            }
            X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray2[i] = new X509CertificateWrapper(x509CertificateArray[i], string2);
            }
            X509TrustManager x509TrustManager = this.createTrustManager(linkedList);
            basicTrustManagerDelegate.checkTrusted(x509TrustManager, x509CertificateArray2);
            for (n4 = 0; n4 < x509CertificateArray.length; ++n4) {
                try {
                    x509CertificateArray[n4].checkValidity();
                    continue;
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    n2 = -1;
                    continue;
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    n2 = 1;
                }
            }
            if (!Trace.isAutomationEnabled()) {
                int n5 = n4 = this.alwaysShow || bl2 || n2 != 0 || this.mismatchShow && string2 != null && !CertUtils.checkWildcardDomainList(string2, CertUtils.getServername(x509CertificateArray[0])) ? 1 : 0;
                if (n4 != 0) {
                    Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                    URL uRL = null;
                    if (string2 != null && n > 0) {
                        try {
                            uRL = new URL("https", string2, n, "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    n3 = TrustDeciderDialog.showDialog(x509CertificateArray, uRL, 0, x509CertificateArray.length, bl2, n2, null, new AppInfo(), true, string2);
                } else {
                    n3 = 0;
                }
            } else {
                Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                n3 = 0;
            }
            if (n3 == 0) {
                this.sessionStore.add(x509CertificateArray[0]);
                this.sessionStore.save();
            } else if (n3 == 2) {
                CertStore certStore = DeploySSLCertStore.getUserCertStore();
                certStore.load(true);
                if (certStore.add(x509CertificateArray[0])) {
                    certStore.save();
                }
            } else {
                this.deniedStore.add(x509CertificateArray[0]);
                this.deniedStore.save();
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n3 != 0 && n3 != 2) {
            throw new CertificateException(bl ? "Java couldn't trust Server " : "Java couldn't trust Client");
        }
    }

    public synchronized X509Certificate[] getAcceptedIssuers() {
        try {
            this.reloadCertStores();
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return this.acceptedIssuers.toArray(new X509Certificate[this.acceptedIssuers.size()]);
    }

    private boolean isSupportedAlgorithm(String string) {
        for (int i = 0; i < SUPPORTED_ALGS.length; ++i) {
            if (!string.equalsIgnoreCase(SUPPORTED_ALGS[i])) continue;
            return true;
        }
        return false;
    }

    private void untrustedCertsCheck(CertStore certStore, X509Certificate[] x509CertificateArray) throws CertificateException {
        boolean bl = false;
        KeyStoreException keyStoreException = null;
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            BlacklistedCerts.check(x509CertificateArray[i]);
            if (certStore == null) continue;
            try {
                if (!certStore.contains(x509CertificateArray[i])) continue;
                bl = true;
            }
            catch (KeyStoreException keyStoreException2) {
                bl = true;
                keyStoreException = keyStoreException2;
            }
            break;
        }
        if (bl) {
            String string = ResourceManager.getMessage("untrusted.certificate");
            Trace.println(string, TraceLevel.SECURITY);
            throw new CertificateException(string, keyStoreException);
        }
    }

    static interface BasicTrustManagerDelegate {
        public void checkTrusted(X509TrustManager var1, X509Certificate[] var2) throws CertificateException;
    }
}

