/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.macosx;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.awt.JAWTWindow;
import java.awt.Component;
import java.awt.Insets;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.macosx.JAWT_MacOSXDrawingSurfaceInfo;
import jogamp.nativewindow.macosx.OSXUtil;

public class MacOSXJAWTWindow
extends JAWTWindow
implements MutableSurface {
    private static final boolean DEBUG_CALAYER_POS_CRITICAL;
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private long jawtSurfaceLayersHandle;
    private JAWT_MacOSXDrawingSurfaceInfo macosxdsi;
    private volatile long rootSurfaceLayer = 0L;
    private long windowHandle = 0L;
    private long offscreenSurfaceDrawable = 0L;
    private boolean offscreenSurfaceDrawableSet = false;
    private boolean firstLock = true;

    public MacOSXJAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
        if (DEBUG) {
            this.dumpInfo();
        }
    }

    @Override
    protected void invalidateNative() {
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.invalidateNative(): osh-enabled " + this.isOffscreenLayerSurfaceEnabled() + ", osd-set " + this.offscreenSurfaceDrawableSet + ", osd " + MacOSXJAWTWindow.toHexString(this.offscreenSurfaceDrawable) + ", osl " + MacOSXJAWTWindow.toHexString(this.getAttachedSurfaceLayer()) + ", rsl " + MacOSXJAWTWindow.toHexString(this.rootSurfaceLayer) + ", wh " + MacOSXJAWTWindow.toHexString(this.windowHandle) + " - " + Thread.currentThread().getName());
        }
        this.offscreenSurfaceDrawable = 0L;
        this.offscreenSurfaceDrawableSet = false;
        if (this.isOffscreenLayerSurfaceEnabled()) {
            if (0L != this.windowHandle) {
                OSXUtil.DestroyNSWindow(this.windowHandle);
            }
            OSXUtil.RunOnMainThread(false, true, new Runnable(){

                @Override
                public void run() {
                    if (0L != MacOSXJAWTWindow.this.rootSurfaceLayer) {
                        if (0L != MacOSXJAWTWindow.this.jawtSurfaceLayersHandle) {
                            MacOSXJAWTWindow.UnsetJAWTRootSurfaceLayer0(MacOSXJAWTWindow.this.jawtSurfaceLayersHandle, MacOSXJAWTWindow.this.rootSurfaceLayer);
                        }
                        OSXUtil.DestroyCALayer(MacOSXJAWTWindow.this.rootSurfaceLayer);
                        MacOSXJAWTWindow.this.rootSurfaceLayer = 0L;
                    }
                    MacOSXJAWTWindow.this.jawtSurfaceLayersHandle = 0L;
                }
            });
        }
        this.windowHandle = 0L;
    }

    @Override
    public void setSurfaceScale(int[] nArray) {
        super.setSurfaceScale(nArray);
        if (0L != this.getWindowHandle()) {
            int n = this.getPixelScaleX();
            this.updatePixelScale();
            if (n != this.getPixelScaleX() && 0L != this.getAttachedSurfaceLayer()) {
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        long l = MacOSXJAWTWindow.this.getAttachedSurfaceLayer();
                        if (0L != l) {
                            OSXUtil.SetCALayerPixelScale(MacOSXJAWTWindow.this.rootSurfaceLayer, l, MacOSXJAWTWindow.this.getPixelScaleX());
                        }
                    }
                });
            }
        }
    }

    @Override
    protected void attachSurfaceLayerImpl(final long l) {
        OSXUtil.RunOnMainThread(false, false, new Runnable(){

            @Override
            public void run() {
                Point point = new Point();
                Component component = MacOSXJAWTWindow.getLocationOnScreenNonBlocking(point, MacOSXJAWTWindow.this.component);
                Insets insets = AWTMisc.getInsets(component, true);
                Point point2 = (Point)point.cloneMutable();
                point2.translate(-component.getX(), -component.getY());
                if (null != insets) {
                    point2.translate(-insets.left, -insets.top);
                }
                if (DEBUG_CALAYER_POS_CRITICAL) {
                    java.awt.Point point3 = MacOSXJAWTWindow.this.component.getLocationOnScreen();
                    Point point4 = new Point(point3.x, point3.y);
                    point4.translate(-component.getX(), -component.getY());
                    if (null != insets) {
                        point4.translate(-insets.left, -insets.top);
                    }
                    System.err.println("JAWTWindow.attachSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l) + ", [ins " + insets + "], pA " + point3 + " -> " + point4 + ", p0 " + point + " -> " + point2 + ", bounds " + MacOSXJAWTWindow.this.bounds);
                } else if (DEBUG) {
                    System.err.println("JAWTWindow.attachSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l) + ", [ins " + insets + "], p0 " + point + " -> " + point2 + ", bounds " + MacOSXJAWTWindow.this.bounds);
                }
                OSXUtil.AddCASublayer(MacOSXJAWTWindow.this.rootSurfaceLayer, l, point2.getX(), point2.getY(), MacOSXJAWTWindow.this.getWidth(), MacOSXJAWTWindow.this.getHeight(), MacOSXJAWTWindow.this.getPixelScaleX(), JAWTUtil.getOSXCALayerQuirks());
            }
        });
    }

    @Override
    protected void layoutSurfaceLayerImpl(long l, boolean bl) {
        int n = JAWTUtil.getOSXCALayerQuirks();
        Point point = new Point();
        Component component = MacOSXJAWTWindow.getLocationOnScreenNonBlocking(point, this.component);
        Insets insets = AWTMisc.getInsets(component, true);
        Point point2 = (Point)point.cloneMutable();
        point2.translate(-component.getX(), -component.getY());
        if (null != insets) {
            point2.translate(-insets.left, -insets.top);
        }
        if (DEBUG_CALAYER_POS_CRITICAL) {
            java.awt.Point point3 = this.component.getLocationOnScreen();
            Point point4 = new Point(point3.x, point3.y);
            point4.translate(-component.getX(), -component.getY());
            if (null != insets) {
                point4.translate(-insets.left, -insets.top);
            }
            System.err.println("JAWTWindow.layoutSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l) + ", quirks " + n + ", visible " + bl + ", [ins " + insets + "], pA " + point3 + " -> " + point4 + ", p0 " + point + " -> " + point2 + ", bounds " + this.bounds);
        } else if (DEBUG) {
            System.err.println("JAWTWindow.layoutSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l) + ", quirks " + n + ", visible " + bl + ", [ins " + insets + "], p0 " + point + " -> " + point2 + ", bounds " + this.bounds);
        }
        OSXUtil.FixCALayerLayout(this.rootSurfaceLayer, l, bl, point2.getX(), point2.getY(), this.getWidth(), this.getHeight(), n);
    }

    @Override
    protected void detachSurfaceLayerImpl(final long l, final Runnable runnable) {
        OSXUtil.RunOnMainThread(false, true, new Runnable(){

            @Override
            public void run() {
                runnable.run();
                OSXUtil.RemoveCASublayer(MacOSXJAWTWindow.this.rootSurfaceLayer, l);
            }
        });
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    public final long getSurfaceHandle() {
        return this.offscreenSurfaceDrawableSet ? this.offscreenSurfaceDrawable : this.drawable;
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new UnsupportedOperationException("Not using CALAYER");
        }
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.setSurfaceHandle(): " + MacOSXJAWTWindow.toHexString(l));
        }
        this.offscreenSurfaceDrawable = l;
        this.offscreenSurfaceDrawableSet = true;
    }

    @Override
    protected JAWT fetchJAWTImpl() throws NativeWindowException {
        return JAWTUtil.getJAWT(this.getShallUseOffscreenLayer() || this.isApplet());
    }

    @Override
    protected int lockSurfaceImpl() throws NativeWindowException {
        int n = 1;
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n2 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n2 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        if (this.firstLock) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    MacOSXJAWTWindow.this.dsi = MacOSXJAWTWindow.this.ds.GetDrawingSurfaceInfo();
                    return null;
                }
            });
        } else {
            this.dsi = this.ds.GetDrawingSurfaceInfo();
        }
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateLockedData(this.dsi.getBounds());
        if (DEBUG && this.firstLock) {
            this.dumpInfo();
        }
        this.firstLock = false;
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            this.macosxdsi = (JAWT_MacOSXDrawingSurfaceInfo)this.dsi.platformInfo(this.getJAWT());
            if (this.macosxdsi == null) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.drawable = this.macosxdsi.getCocoaViewRef();
            if (this.drawable == 0L) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.windowHandle = OSXUtil.GetNSWindow(this.drawable);
            n = 3;
        } else {
            String string = null;
            if (0L == this.drawable) {
                this.windowHandle = OSXUtil.CreateNSWindow(0, 0, 64, 64);
                if (0L == this.windowHandle) {
                    string = "Unable to create dummy NSWindow (layered case)";
                } else {
                    this.drawable = OSXUtil.GetNSView(this.windowHandle);
                    if (0L == this.drawable) {
                        string = "Null NSView of NSWindow " + MacOSXJAWTWindow.toHexString(this.windowHandle);
                    }
                }
                if (null == string) {
                    Capabilities capabilities = (Capabilities)this.getGraphicsConfiguration().getChosenCapabilities().cloneMutable();
                    capabilities.setOnscreen(false);
                    this.setChosenCapabilities(capabilities);
                }
            }
            if (null == string) {
                this.jawtSurfaceLayersHandle = MacOSXJAWTWindow.GetJAWTSurfaceLayersHandle0(this.dsi.getBuffer());
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        String string = null;
                        if (0L == MacOSXJAWTWindow.this.rootSurfaceLayer && 0L != MacOSXJAWTWindow.this.jawtSurfaceLayersHandle) {
                            MacOSXJAWTWindow.this.rootSurfaceLayer = OSXUtil.CreateCALayer(MacOSXJAWTWindow.this.bounds.getWidth(), MacOSXJAWTWindow.this.bounds.getHeight(), MacOSXJAWTWindow.this.getPixelScaleX());
                            if (0L == MacOSXJAWTWindow.this.rootSurfaceLayer) {
                                string = "Could not create root CALayer";
                            } else {
                                try {
                                    MacOSXJAWTWindow.SetJAWTRootSurfaceLayer0(MacOSXJAWTWindow.this.jawtSurfaceLayersHandle, MacOSXJAWTWindow.this.rootSurfaceLayer);
                                }
                                catch (Exception exception) {
                                    string = "Could not set JAWT rootSurfaceLayerHandle " + MacOSXJAWTWindow.toHexString(MacOSXJAWTWindow.this.rootSurfaceLayer) + ", cause: " + exception.getMessage();
                                }
                            }
                            if (null != string) {
                                if (0L != MacOSXJAWTWindow.this.rootSurfaceLayer) {
                                    OSXUtil.DestroyCALayer(MacOSXJAWTWindow.this.rootSurfaceLayer);
                                    MacOSXJAWTWindow.this.rootSurfaceLayer = 0L;
                                }
                                throw new NativeWindowException(string + ": " + MacOSXJAWTWindow.this);
                            }
                        }
                    }
                });
            }
            if (null != string) {
                if (0L != this.windowHandle) {
                    OSXUtil.DestroyNSWindow(this.windowHandle);
                    this.windowHandle = 0L;
                }
                this.drawable = 0L;
                this.unlockSurfaceImpl();
                throw new NativeWindowException(string + ": " + this);
            }
            n = 3;
        }
        return n;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            this.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
    }

    private void dumpInfo() {
        System.err.println("MaxOSXJAWTWindow: 0x" + Integer.toHexString(this.hashCode()) + " - thread: " + Thread.currentThread().getName());
        this.dumpJAWTInfo();
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        if (null == point) {
            point = new Point();
        }
        MacOSXJAWTWindow.getLocationOnScreenNonBlocking(point, this.component);
        return point;
    }

    @Override
    protected Point getLocationOnScreenNativeImpl(int n, int n2) {
        return null;
    }

    private static native long GetJAWTSurfaceLayersHandle0(Buffer var0);

    private static native void SetJAWTRootSurfaceLayer0(long var0, long var2);

    private static native void UnsetJAWTRootSurfaceLayer0(long var0, long var2);

    static {
        Debug.initSingleton();
        DEBUG_CALAYER_POS_CRITICAL = PropertyAccess.isPropertyDefined((String)"nativewindow.debug.JAWT.OSXCALayerPos", (boolean)true);
    }
}

