/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ClientHandshaker
extends Handshaker {
    private PublicKey serverKey;
    private PublicKey ephemeralServerKey;
    private BigInteger serverDH;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;
    private static final boolean enableSNIExtension = Debug.getBooleanProperty("jsse.enableSNIExtension", true);
    private static final boolean allowUnsafeServerCertChange = Debug.getBooleanProperty("jdk.tls.allowUnsafeServerCertChange", false);
    private X509Certificate[] reservedServerCerts = null;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, true, true, protocolVersion, bl, bl2, byArray, byArray2);
    }

    ClientHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, true, true, protocolVersion, bl, bl2, byArray, byArray2);
    }

    @Override
    void processMessage(byte by, int n) throws IOException {
        if (this.state >= by && by != 0) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        block4 : switch (by) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input, n));
                break;
            }
            case 11: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                switch (this.keyExchange) {
                    case K_RSA_EXPORT: {
                        if (this.serverKey == null) {
                            throw new SSLProtocolException("Server did not send certificate message");
                        }
                        if (!(this.serverKey instanceof RSAPublicKey)) {
                            throw new SSLProtocolException("Protocol violation: the certificate type must be appropriate for the selected cipher suite's key exchange algorithm");
                        }
                        if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                            throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange) + " when the public key in the server certificate" + " is less than or equal to 512 bits in length");
                        }
                        try {
                            this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_DH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.protocolVersion));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_DHE_DSS: 
                    case K_DHE_RSA: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, n, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.ECDH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_RSA: 
                    case K_DH_RSA: 
                    case K_DH_DSS: 
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: {
                        throw new SSLProtocolException("Protocol violation: server sent a server key exchangemessage for key exchange " + (Object)((Object)this.keyExchange));
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.keyExchange));
            }
            case 13: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input, this.protocolVersion);
                if (debug != null && Debug.isOn("handshake")) {
                    this.certRequest.print(System.out);
                }
                if (this.protocolVersion.v < ProtocolVersion.TLS12.v) break;
                Collection<SignatureAndHashAlgorithm> collection = this.certRequest.getSignAlgorithms();
                if (collection == null || collection.isEmpty()) {
                    throw new SSLHandshakeException("No peer supported signature algorithms");
                }
                Collection<SignatureAndHashAlgorithm> collection2 = SignatureAndHashAlgorithm.getSupportedAlgorithms(collection);
                if (collection2.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature and hash algorithm in common");
                }
                this.setPeerSupportedSignAlgs(collection2);
                this.session.setPeerSupportedSignatureAlgorithms(collection2);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (this.state < by) {
            this.state = by;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest helloRequest) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            helloRequest.print(System.out);
        }
        if (this.state < 1) {
            if (!this.secureRenegotiation && !allowUnsafeRenegotiation) {
                if (this.activeProtocolVersion.v >= ProtocolVersion.TLS10.v) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                } else {
                    this.fatalSE((byte)40, "Renegotiation is not allowed");
                }
            } else {
                if (!this.secureRenegotiation && debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: continue with insecure renegotiation");
                }
                this.kickstart();
            }
        }
    }

    private void serverHello(HandshakeMessage.ServerHello serverHello) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ProtocolVersion protocolVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn("handshake")) {
            serverHello.print(System.out);
        }
        if (!this.isNegotiable(protocolVersion = serverHello.protocolVersion)) {
            throw new SSLHandshakeException("Server chose " + protocolVersion + ", but that protocol version is not enabled or not supported " + "by the client.");
        }
        this.handshakeHash.protocolDetermined(protocolVersion);
        this.setVersion(protocolVersion);
        RenegotiationInfoExtension renegotiationInfoExtension = (RenegotiationInfoExtension)serverHello.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (renegotiationInfoExtension != null) {
            if (this.isInitialHandshake) {
                if (!renegotiationInfoExtension.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "Unexpected renegotiation indication extension");
                }
                object3 = new byte[this.clientVerifyData.length + this.serverVerifyData.length];
                System.arraycopy(this.clientVerifyData, 0, object3, 0, this.clientVerifyData.length);
                System.arraycopy(this.serverVerifyData, 0, object3, this.clientVerifyData.length, this.serverVerifyData.length);
                if (!Arrays.equals((byte[])object3, renegotiationInfoExtension.getRenegotiatedConnection())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ServerHello renegotiation_info message");
                }
            }
        } else if (this.isInitialHandshake) {
            if (!allowLegacyHelloMessages) {
                this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
            }
            this.secureRenegotiation = false;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Warning: No renegotiation indication extension in ServerHello");
            }
        } else if (this.secureRenegotiation) {
            this.fatalSE((byte)40, "No renegotiation indication extension");
        }
        this.svr_random = serverHello.svr_random;
        if (!this.isNegotiable(serverHello.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected improper ciphersuite " + serverHello.cipherSuite);
        }
        this.setCipherSuite(serverHello.cipherSuite);
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.getPRFHashAlg());
        }
        if (serverHello.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + serverHello.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(serverHello.sessionId)) {
                object3 = this.session.getSuite();
                if (this.cipherSuite != object3) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                object2 = this.session.getProtocolVersion();
                if (this.protocolVersion != object2) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (((CipherSuite)object3).keyExchange == CipherSuite.KeyExchange.K_KRB5 || ((CipherSuite)object3).keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    block37: {
                        object = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Helper.getClientSubject(ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block37;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<Principal> set = subject.getPrincipals(Principal.class);
                        if (!set.contains(object)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
            } else {
                this.session = null;
                if (!this.enableNewSession) {
                    throw new SSLException("New session creation is disabled");
                }
            }
        }
        if (this.resumingSession && this.session != null) {
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.handshakeHash.setCertificateVerifyAlg(null);
            }
            this.setHandshakeSessionSE(this.session);
            if (this.isInitialHandshake) {
                this.session.setAsSessionResumption(true);
            }
            return;
        }
        object3 = serverHello.extensions.list().iterator();
        while (object3.hasNext()) {
            object2 = (HelloExtension)object3.next();
            object = ((HelloExtension)object2).type;
            if (object == ExtensionType.EXT_ELLIPTIC_CURVES || object == ExtensionType.EXT_EC_POINT_FORMATS || object == ExtensionType.EXT_SERVER_NAME || object == ExtensionType.EXT_RENEGOTIATION_INFO) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + object);
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.getLocalSupportedSignAlgs(), serverHello.sessionId, this.getHostSE(), this.getPortSE());
        this.setHandshakeSessionSE(this.session);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("** " + this.cipherSuite);
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange rSA_ServerKeyExchange) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn("handshake")) {
            rSA_ServerKeyExchange.print(System.out);
        }
        if (!rSA_ServerKeyExchange.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.ephemeralServerKey = rSA_ServerKeyExchange.getPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.print(System.out);
        }
        this.dh = new DHCrypt(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase(), this.sslContext.getSecureRandom());
        this.serverDH = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.ECDH_ServerKeyExchange eCDH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            eCDH_ServerKeyExchange.print(System.out);
        }
        ECPublicKey eCPublicKey = eCDH_ServerKeyExchange.getPublicKey();
        this.ecdh = new ECDHCrypt(eCPublicKey.getParams(), this.sslContext.getSecureRandom());
        this.ephemeralServerKey = eCPublicKey;
    }

    private void serverHelloDone(HandshakeMessage.ServerHelloDone serverHelloDone) throws IOException {
        Object object;
        Object object2;
        Serializable serializable;
        String[] stringArray;
        if (debug != null && Debug.isOn("handshake")) {
            serverHelloDone.print(System.out);
        }
        this.input.digestNow();
        Key key = null;
        if (this.certRequest != null) {
            X509Certificate[] x509CertificateArray;
            stringArray = this.sslContext.getX509KeyManager();
            serializable = new ArrayList(4);
            for (int i = 0; i < this.certRequest.types.length; ++i) {
                String string;
                switch (this.certRequest.types[i]) {
                    case 1: {
                        string = "RSA";
                        break;
                    }
                    case 2: {
                        string = "DSA";
                        break;
                    }
                    case 64: {
                        string = JsseJce.isEcAvailable() ? "EC" : null;
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                if (string == null || serializable.contains(string)) continue;
                serializable.add(string);
            }
            object2 = null;
            int n = serializable.size();
            if (n != 0) {
                object = serializable.toArray(new String[n]);
                object2 = this.conn != null ? stringArray.chooseClientAlias((String[])object, this.certRequest.getAuthorities(), this.conn) : stringArray.chooseEngineClientAlias((String[])object, this.certRequest.getAuthorities(), this.engine);
            }
            object = null;
            if (object2 != null && (x509CertificateArray = stringArray.getCertificateChain((String)object2)) != null && x509CertificateArray.length != 0) {
                ECParameterSpec eCParameterSpec;
                int n2;
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                if (publicKey instanceof ECPublicKey && !SupportedEllipticCurvesExtension.isSupported(n2 = SupportedEllipticCurvesExtension.getCurveIndex(eCParameterSpec = ((ECPublicKey)publicKey).getParams()))) {
                    publicKey = null;
                }
                if (publicKey != null) {
                    object = new HandshakeMessage.CertificateMsg(x509CertificateArray);
                    key = stringArray.getPrivateKey((String)object2);
                    this.session.setLocalPrivateKey((PrivateKey)key);
                    this.session.setLocalCertificates(x509CertificateArray);
                }
            }
            if (object == null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                    object = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
                } else {
                    this.warningSE((byte)41);
                }
            }
            if (object != null) {
                if (debug != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)object).print(System.out);
                }
                ((HandshakeMessage)object).write(this.output);
            }
        }
        switch (this.keyExchange) {
            case K_RSA_EXPORT: 
            case K_RSA: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof RSAPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an RSA key");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_RSA) {
                    serializable = this.serverKey;
                } else if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                    serializable = this.serverKey;
                } else {
                    if (this.ephemeralServerKey == null) {
                        throw new SSLProtocolException("Server did not send a RSA_EXPORT Server Key Exchange message");
                    }
                    serializable = this.ephemeralServerKey;
                }
                stringArray = new RSAClientKeyExchange(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), (PublicKey)serializable);
                break;
            }
            case K_DH_RSA: 
            case K_DH_DSS: {
                stringArray = new DHClientKeyExchange();
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                if (this.dh == null) {
                    throw new SSLProtocolException("Server did not send a DH Server Key Exchange message");
                }
                stringArray = new DHClientKeyExchange(this.dh.getPublicKey());
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                if (this.ecdh == null) {
                    throw new SSLProtocolException("Server did not send a ECDH Server Key Exchange message");
                }
                stringArray = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an EC key");
                }
                object2 = ((ECPublicKey)this.serverKey).getParams();
                this.ecdh = new ECDHCrypt((ECParameterSpec)object2, this.sslContext.getSecureRandom());
                stringArray = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                String string = this.getHostSE();
                if (string == null) {
                    throw new IOException("Hostname is required to use Kerberos cipher suites");
                }
                object = new KerberosClientKeyExchange(string, this.isLoopbackSE(), this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                this.session.setPeerPrincipal(((KerberosClientKeyExchange)object).getPeerPrincipal());
                this.session.setLocalPrincipal(((KerberosClientKeyExchange)object).getLocalPrincipal());
                stringArray = object;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)((Object)this.keyExchange));
            }
        }
        if (debug != null && Debug.isOn("handshake")) {
            stringArray.print(System.out);
        }
        stringArray.write(this.output);
        this.output.doHashes();
        this.output.flush();
        switch (this.keyExchange) {
            case K_RSA_EXPORT: 
            case K_RSA: {
                serializable = ((RSAClientKeyExchange)stringArray).preMaster;
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                object2 = ((KerberosClientKeyExchange)stringArray).getUnencryptedPreMasterSecret();
                serializable = new SecretKeySpec((byte[])object2, "TlsPremasterSecret");
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                serializable = this.dh.getAgreedSecret(this.serverDH, true);
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                serializable = this.ecdh.getAgreedSecret(this.ephemeralServerKey);
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                serializable = this.ecdh.getAgreedSecret(this.serverKey);
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)((Object)this.keyExchange));
            }
        }
        this.calculateKeys((SecretKey)serializable, null);
        if (key != null) {
            try {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    signatureAndHashAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm(this.peerSupportedSignAlgs, key.getAlgorithm(), (PrivateKey)key);
                    if (signatureAndHashAlgorithm == null) {
                        throw new SSLHandshakeException("No supported signature algorithm");
                    }
                    object = SignatureAndHashAlgorithm.getHashAlgorithmName(signatureAndHashAlgorithm);
                    if (object == null || ((String)object).length() == 0) {
                        throw new SSLHandshakeException("No supported hash algorithm");
                    }
                    this.handshakeHash.setCertificateVerifyAlg((String)object);
                }
                object2 = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, (PrivateKey)key, this.session.getMasterSecret(), this.sslContext.getSecureRandom(), signatureAndHashAlgorithm);
            }
            catch (GeneralSecurityException generalSecurityException) {
                this.fatalSE((byte)40, "Error signing certificate verify", generalSecurityException);
                object2 = null;
            }
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateVerify)object2).print(System.out);
            }
            ((HandshakeMessage)object2).write(this.output);
            this.output.doHashes();
        } else if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setCertificateVerifyAlg(null);
        }
        this.sendChangeCipherAndFinish(false);
    }

    private void serverFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (!(bl = finished.verify(this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.serverVerifyData = finished.getVerifyData();
        }
        if (!this.isInitialHandshake) {
            this.session.setAsSessionResumption(false);
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish(boolean bl) throws IOException {
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(finished, bl);
        if (this.secureRenegotiation) {
            this.clientVerifyData = finished.getVerifyData();
        }
        this.state = 19;
    }

    @Override
    HandshakeMessage getKickstartMessage() throws SSLException {
        String string;
        Object object;
        Object object2;
        SessionId sessionId = SSLSessionImpl.nullSession.getSessionId();
        CipherSuiteList cipherSuiteList = this.getActiveCipherSuites();
        this.maxProtocolVersion = this.protocolVersion;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null) {
            if (!allowUnsafeServerCertChange && this.session.isSessionResumption()) {
                try {
                    this.reservedServerCerts = (X509Certificate[])this.session.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            if (!this.session.isRejoinable()) {
                this.session = null;
            }
        }
        if (this.session != null) {
            object2 = this.session.getSuite();
            object = this.session.getProtocolVersion();
            if (!this.isNegotiable((CipherSuite)object2)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, unavailable cipher");
                }
                this.session = null;
            }
            if (this.session != null && !this.isNegotiable((ProtocolVersion)object)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                sessionId = this.session.getSessionId();
                this.maxProtocolVersion = object;
                this.setVersion((ProtocolVersion)object);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLHandshakeException("Can't reuse existing SSL client session");
                }
                ArrayList<CipherSuite> collection2 = new ArrayList<CipherSuite>(2);
                collection2.add((CipherSuite)object2);
                if (!this.secureRenegotiation && cipherSuiteList.contains(CipherSuite.C_SCSV)) {
                    collection2.add(CipherSuite.C_SCSV);
                }
                cipherSuiteList = new CipherSuiteList(collection2);
            }
        }
        if (this.session == null && !this.enableNewSession) {
            throw new SSLHandshakeException("No existing session to resume");
        }
        if (this.secureRenegotiation && cipherSuiteList.contains(CipherSuite.C_SCSV)) {
            object2 = new ArrayList(cipherSuiteList.size() - 1);
            for (CipherSuite cipherSuite : cipherSuiteList.collection()) {
                if (cipherSuite == CipherSuite.C_SCSV) continue;
                object2.add(cipherSuite);
            }
            cipherSuiteList = new CipherSuiteList((Collection<CipherSuite>)object2);
        }
        boolean bl = false;
        for (CipherSuite cipherSuite : cipherSuiteList.collection()) {
            if (!this.isNegotiable(cipherSuite)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SSLHandshakeException("No negotiable cipher suite");
        }
        object = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.maxProtocolVersion, sessionId, cipherSuiteList);
        if (this.maxProtocolVersion.v >= ProtocolVersion.TLS12.v) {
            Collection<SignatureAndHashAlgorithm> collection = this.getLocalSupportedSignAlgs();
            if (collection.isEmpty()) {
                throw new SSLHandshakeException("No supported signature algorithm");
            }
            ((HandshakeMessage.ClientHello)object).addSignatureAlgorithmsExtension(collection);
        }
        if (enableSNIExtension && (string = this.getRawHostnameSE()) != null && string.indexOf(46) > 0 && !IPAddressUtil.isIPv4LiteralAddress(string) && !IPAddressUtil.isIPv6LiteralAddress(string)) {
            ((HandshakeMessage.ClientHello)object).addServerNameIndicationExtension(string);
        }
        this.clnt_random = ((HandshakeMessage.ClientHello)object).clnt_random;
        if (this.secureRenegotiation || !cipherSuiteList.contains(CipherSuite.C_SCSV)) {
            ((HandshakeMessage.ClientHello)object).addRenegotiationInfoExtension(this.clientVerifyData);
        }
        return object;
    }

    @Override
    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        block8: {
            Object object;
            if (debug != null && Debug.isOn("handshake")) {
                certificateMsg.print(System.out);
            }
            if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
                this.fatalSE((byte)42, "empty certificate chain");
            }
            if (!(this.reservedServerCerts == null || (object = this.getEndpointIdentificationAlgorithmSE()) != null && ((String)object).length() != 0 || ClientHandshaker.isIdentityEquivalent(x509CertificateArray[0], this.reservedServerCerts[0]))) {
                this.fatalSE((byte)42, "server certificate change is restrictedduring renegotiation");
            }
            object = this.sslContext.getX509TrustManager();
            try {
                String string = this.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT && !this.serverKeyExchangeReceived ? CipherSuite.KeyExchange.K_RSA.name : this.keyExchange.name;
                if (object instanceof X509ExtendedTrustManager) {
                    if (this.conn != null) {
                        ((X509ExtendedTrustManager)object).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this.conn);
                    } else {
                        ((X509ExtendedTrustManager)object).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this.engine);
                    }
                    break block8;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException certificateException) {
                this.fatalSE((byte)46, certificateException);
            }
        }
        this.session.setPeerCertificates(x509CertificateArray);
    }

    private static boolean isIdentityEquivalent(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (x509Certificate.equals(x509Certificate2)) {
            return true;
        }
        Object object = ClientHandshaker.getSubjectAltName(x509Certificate, 7);
        Object object2 = ClientHandshaker.getSubjectAltName(x509Certificate2, 7);
        if (object != null && object2 != null) {
            return Objects.equals(object, object2);
        }
        Object object3 = ClientHandshaker.getSubjectAltName(x509Certificate, 2);
        Object object4 = ClientHandshaker.getSubjectAltName(x509Certificate2, 2);
        if (object3 != null && object4 != null) {
            return Objects.equals(object3, object4);
        }
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Principal x500Principal2 = x509Certificate2.getSubjectX500Principal();
        X500Principal x500Principal3 = x509Certificate.getIssuerX500Principal();
        X500Principal x500Principal4 = x509Certificate2.getIssuerX500Principal();
        return !x500Principal.getName().isEmpty() && !x500Principal2.getName().isEmpty() && x500Principal.equals(x500Principal2) && x500Principal3.equals(x500Principal4);
    }

    private static Object getSubjectAltName(X509Certificate x509Certificate, int n) {
        Collection<List<?>> collection;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Attempt to obtain subjectAltNames extension failed!");
            }
            return null;
        }
        if (collection != null) {
            for (List<?> list : collection) {
                int n2 = (Integer)list.get(0);
                if (n2 != n) continue;
                return list.get(1);
            }
        }
        return null;
    }
}

