#include "inc/uniforms.glsl"
#include "inc/utils.glsl"
#line 3 1

#ifdef VERTEX
#line 1 4
#include "inc/geometry_io.vs"
uniform float UVmult;
// this file is included by geometry.glsl
void main()
{	
	ex_Color = vec4(in_Normal, 1.0);
	ex_Normal = normalize(normalMatrix * in_Normal.xyz);

	ex_UV = in_UV.xy * UVmult;

	ex_Position = (modelView)*in_Position;
	gl_Position = (modelViewProject)*in_Position;

}

#endif


#ifdef FRAGMENT
#line 1 6
#include "inc/geometry_io.fs"
#line 1 7
#line 2
#define pi (3.141592653589)
uniform vec4 diffuseColor;
uniform vec4 specularColor;
uniform float colorBoost;
uniform float roughness;
uniform float metallic;
uniform sampler2D envMap;
uniform vec4 envColor;
uniform float envUVMult;

void main()
{
	vec3 V = normalize(-ex_Position.xyz);
	vec3 N = ex_Normal.xyz; // viewspace normal
	vec3 R = reflect(-V, normalize(N));

		vec3 lightDirs[2];
		vec3 lightIntensities[2];
		lightDirs[0] = normalize(vec3(-0.5, -0.2, -0.1));
		lightIntensities[0] = vec3(1.0,0.7,0.5)*5.0;
		
		lightDirs[1] = -normalize(vec3(-0.5, -0.2, -0.1));
		lightIntensities[1] = vec3(0.6, 0.15, 0.7)*3.0;
		#define LIGHTS_DEFINED
		#include "inc/cooktorrance.inc"

	vec2 envUV = R.xy + vec2(R.z*0.5, R.z);
	final.rgb += pow(texture(envMap, envUV*envUVMult).xyz * 1.2 * envColor.rgb, vec3(2.0));
	final.rgb += vec3(0.02);
	
	out_Color = vec4(final.rgb, 1.0);
}

#endif
