vec4 sampld = texture(tex, ex_UV.xy);
	vec3 albedo = sampld.rgb * diffuseColor.rgb;
	float sampledRoughness = texture(roughnessMap, ex_UV.xy).r;
	vec3 spec = mix(specularColor.rgb, diffuseColor.rgb, metallic);
	vec3 col = vec3(0.0);
	
	vec3 final = vec3(0.0);
	#include "lights.inc"
	
	for (int i = 0;i < 2 ; i++) {
		vec3 lightdir = lightDirs[i];
		lightdir = (viewMatrix*vec4(lightdir, 0.0)).xyz;
		vec3 L = -lightdir; // vector to light
		
		// these two are defined outside
		//vec3 V = normalize(-ex_Position.xyz);
		//vec3 N = ex_Normal.xyz; // viewspace normal
		
		float NdotL = max(0.0, dot(L, N));
		vec3 H = normalize(V + L);
		float HdotN = max(0.0, dot(H, N));
		float NdotV = max(0.0, dot(N, V));
		float HdotV = max(0.0, dot(H, V));
		
		vec3 diffuse = vec3((1.0/pi) * max(0.0, 1.0-length(spec)));
		diffuse *= albedo * NdotL;
		
		// Unreal Engine 4 shading
		float rough = roughness*min(1.0,max(0.0, 1.0 - 0.7*sampledRoughness));
		float alpha = rough*rough;
		vec3 F0 = spec;

		// GGX/Trowbridge-Reitz
		float D = (alpha*alpha) / (pi * pow(HdotN*HdotN * (alpha*alpha - 1.0) + 1.0, 2.0));
		float k = pow(rough + 1.0, 2.0) / 8.0;
		float GL = NdotL / (NdotL*(1.0 - k) + k);
		float GV = NdotV / (NdotV*(1.0 - k) + k);
		float G = GL * GV;
		//spherical approximation and shit THANKS DICE
		vec3 F = F0 + (vec3(1.0) - F0) * pow(2.0, (-5.55473 * HdotV - 6.98316) * HdotV);
		
		float attenuation = 1.0;
		vec3 specular = vec3(D*F*G) * spec * specularColor.a;
		vec3 lightIntensity = lightIntensities[i];
		vec3 Li = lightIntensity * (diffuse + specular) * attenuation;
		
		final += Li * colorBoost;
	}