#include "inc/uniforms.glsl"
#include "inc/utils.glsl"

uniform vec4 stars_color;
uniform float stars_color_offset;

#line 3 1

#ifdef VERTEX
#line 1 4
#include "inc/geometry_io.vs"

#define pi (3.141592653589)

vec3 getPosition(float t){
	float t2=t*20.;
	t2+=0.01*sin(p_time)+(p_time-110.)*3.;//speed
	float dist=20.+sin(t2*1.3)*5.;
	return vec3(sin(t2+(1.-t)*2.+sin(t2*2.)*0.6)*dist,0.,cos(t2+(1.-t)*2.+sin(t2*2.)*0.7)*dist)//around
		+ vec3(0.,t2*2.+cos(t2)*15+cos(t2*3.5)*5,0.)//forward
		+ vec3(sin(t2*2.3),sin(t2*1.32),sin(t2*3.6754))*(1.-t)*5.//tail movement
	;
}

vec3 getDiff(float t){
	return getPosition(t)-getPosition(t+0.05);
}

#line 10 1
void process() 
{

	float t=1.-in_UV.y*0.5; //length controlled here
	float side=(in_UV.x>0.5?1:-1)*0.7; //width
	//vec3 pos=getPosition(t)+normalize(getDiff(t))*side; //hassu
	vec3 nor=vec3(0.);
	for(int i=0;i<15;i++){
		vec3 tmp=normalize(cross(normalize(getDiff(t+0.1  *i)),normalize(getDiff(t+0.1*(i+1.)))));
		if(!(tmp!=tmp))nor+=tmp;
	}
	  vec3 pos=getPosition(t)+normalize(nor)*side;
	
	float alpha = pow(abs(sin(p_beat*pi*0.5-pi*0.5)), 2.0)*0.3;
	mat2x2 rot = mat2(cos(alpha), sin(alpha), -sin(alpha), cos(alpha));
	
	ex_Position = modelView*vec4(pos,1);
	
	//ex_Position = in_Position*scale+offset;
	ex_Position.w=1;
	gl_Position = (projectionMatrix)*ex_Position;
	
	ex_UV = in_UV;
}

#define PROCESSING_FUNCTION process
#line 1 5
#include "inc/geometry.vs"

#endif


#ifdef FRAGMENT
#line 1 6
in vec4 ex_Color;
smooth in vec3 ex_Normal; 
smooth in vec2 ex_UV;
in vec4 ex_Position; //viewspace

layout(location = 0) out vec4 out_Color;

uniform sampler2D tex;
#line 1 7
void main()
{
	out_Color = vec4(1.0, 1.0, 1.0, 1.0);
}
#endif
