#include "ShaderCommon.fx"

Texture2D<float4> RenderOutput;

Texture2D<float4> InputTexture;

float4 CopyPS(FullScreenVertexOut input) : SV_Target
{
	return InputTexture.SampleLevel(PointClampSampler, input.uv, 0);
}

float4 CombinePS(FullScreenVertexOut input) : SV_Target
{
	float4 col = RenderOutput.SampleLevel(PointClampSampler, input.uv, 0);
	col.xyz = pow(col.xyz, 2.2);	// Convert to linear space
	return saturate(col);
}

float4 FinalCompositePS(FullScreenVertexOut input) : SV_Target
{
	float4 col = RenderOutput.SampleLevel(PointClampSampler, input.uv, 0);
	col.xyz = pow(col.xyz, 1.0f / 2.2f); // Gamma correction

	// Vignette
	float2 p = input.uv;
	float vignette = 0.5 + 0.5 * pow( 16.0*p.x*p.y*(1.0-p.x)*(1.0-p.y), 0.5 );
	return saturate(col * vignette);

	return col;
}