// GPU HASH FUNCTIONS WITHOUT SINE (taken from https://www.shadertoy.com/view/4djSRW)
//----------------------------------------------------------------------------------------
float hash11(float p)
{
	float2 p2 = frac(float2(p * 5.3983, p * 5.4427));
    p2 += dot(p2.yx, p2.xy + float2(21.5351, 14.3137));
	return frac(p2.x * p2.y * 95.4337);
}

float noise( in float3 x )
{
	float3 p = floor(x);
	float3 f = frac(x);

	f = f * f * ( 3.0f - 2.0f * f );

	float n = ( p.z * 113.0f + ( p.y * 57.0f + p.x ) );
	float res = lerp(lerp(lerp( hash11(n+  0.0), hash11(n+  1.0),f.x),
                          lerp( hash11(n+ 57.0), hash11(n+ 58.0),f.x),f.y),
                     lerp(lerp( hash11(n+113.0), hash11(n+114.0),f.x),
                          lerp( hash11(n+170.0), hash11(n+171.0),f.x),f.y),f.z);
    return res;
}

float fbm( float3 p )
{
	float3x3 m = float3x3( float3( 0.0f, 1.0f, 0.6f ),
						   float3( -1.0f, 0.36f, -0.48f ),
						   float3( -0.60f, -0.48f, 0.64f ) );

	float f = 0.0f;
	f += 0.5000f*noise(p); p = mul( p, m )*2.02f;
	f += 0.2500f*noise(p); p = mul( p, m )*2.03f;
	f += 0.1250f*noise(p); p = mul( p, m )*2.01f;
	f += 0.0625f*noise(p);

	return f / 0.9375f;
}