Texture2D<float4> NoiseTexture;

// Returns a noise value from the noise texture
float noise(float3 p)
{
	return NoiseTexture.SampleLevel(BilinearWrapSampler, p.xy, 0).x;
}

// Fractional brownian motion
float fbm(float3 p)
{
	float3x3 m = float3x3( float3( 0.0f, 1.0f, 0.6f ),
						   float3( -1.0f, 0.36f, -0.48f ),
						   float3( -0.60f, -0.48f, 0.64f ) );

	float f = 0.0f;
	f += 0.5000f*noise(p).x; p = mul( p, m )*2.02f;
	f += 0.2500f*noise(p).x; p = mul( p, m )*2.03f;
	f += 0.1250f*noise(p).x; p = mul( p, m )*2.01f;
	f += 0.0625f*noise(p).x;

	return f / 0.9375f;
}