Random RANDOM(25);
class Random {
	int seed = 0;
	Random() {
		
	}
	Random(int s) {
		seed = s;
	}	
	float getFloat() {
		seed = (seed * 9301 + 49297) % 233280;
		if (seed < 0 ) {
			seed *= -1;
		}
		return float(seed);
	}	
	int get() {
		seed = (seed * 9301 + 49297) % 233280;
		if (seed < 0 ) {
			seed *= -1;
		}
		return seed;
	}
	uint get(int min, int max) {
		seed = (seed * 9301 + 49297) % 233280;
		if (seed < 0 ) {
			seed *= -1;
		}
		return min + seed % (max - min + 1);		
	}
}

Vector3 getRandVector(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
	float x, y, z; 
	x = minX + RANDOM.getFloat() % (maxX - minX + 1);
	y = minY + RANDOM.getFloat() % (maxY - minY + 1);
	z = minZ + RANDOM.getFloat() % (maxZ - minZ + 1);	
	return Vector3(x,y,z); 
}
Vector3 getRandVectorSd(Random@ rand, float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
	float x, y, z; 
	x = minX + rand.getFloat() % (maxX - minX + 1);
	y = minY + rand.getFloat() % (maxY - minY + 1);
	z = minZ + rand.getFloat() % (maxZ - minZ + 1);	
	return Vector3(x,y,z); 
}

float getVectorLength(Vector3 a) {
	return sqrt((a.x*a.x)+(a.y*a.y)+(a.z*a.z));
}

Vector3 getDirectionVector(Vector3 a, Vector3 b) {
	//whats your vector victor
	// gets normalized vector from 2 vectors
	Vector3 v = b-a;
	return v/getVectorLength(v);
}
Vector3 normalizeVector(Vector3 v) {
	// normalize vector
	//echo("v: "+String(v.x)+", "+String(v.y)+", "+String(v.z)+"\n");
	if (v.x+v.y+v.z > 0.0000001) {
		return v/getVectorLength(v);
	} else {
		return Vector3(1,0,0);
	}
	
}
Vector3 cross(Vector3 a, Vector3 b) {
	Vector3 c;
	c.x = (a.y*b.z) - (a.z*b.y);
	c.y = (a.z*b.x) - (a.x*b.z);
	c.z = (a.x*b.y) - (a.y*b.x);	
	return c;
}

float dot(Vector3 a, Vector3 b) {
	float d = (a.x*b.x)+(a.y*b.y)+(a.z*b.z);
	echo("dot: "+String((a.x*b.x))+", "+String((a.y*b.y))+", "+String(a.z*b.z)+" = "+String(d)+"\n");
	return (a.x*b.x)+(a.y*b.y)+(a.z*b.z);
}

Vector3 getOrthagonalVector(Vector3 v) {
	Vector3 v2(1,1,0);
	v2.z = -((v.x*1)+(v.y*1))/v.z;
	v2.normalize();
	return v2;
}

Box@ getBound(Vector3 val, float size) {
	//echo("val position: "+String(val.x)+", "+String(val.y)+", "+String(val.z)+"\n");
	return Box(Vector3(val.x-(size/2), val.y-(size/2), val.z-(size/2)), Vector3(val.x+(size/2), val.y+(size/2), val.z+(size/2)));
}

Vector3 rotate2D(Vector3 v, float t) {
	// reminder: t = theta (angle);
	Vector3 r = v;
	float st = sin(t);
	float ct = cos(t);
	r.x = v.x*ct - v.z*st;
	r.z = v.x*st + v.z*ct;
	return r;
}
Vector3 rotate3D(Vector3 v, Vector3 a, float t) {
	Vector3 r;
	// rodrigues formula:
	// r = v*cos(t) + (a dot v)*sin(t) + a*(a dot v)*1-cos(t) 

	float adotv = a.dot(v);
	float st = sin(t);
	float ct = cos(t);
	float oneMct = 1-ct;
	
	r.x = v.x*ct + ((a.y*v.z) - (a.z*v.y))*st + a.x*adotv*oneMct;
	r.y = v.y*ct + ((a.z*v.x) - (a.x*v.z))*st + a.y*adotv*oneMct;
	r.z = v.z*ct + ((a.x*v.y) - (a.y*v.x))*st + a.z*adotv*oneMct;
	
	return r;
}
float checkZero(float i) {
	return i != 0 ? i : 1; 
}

class Point {
	float x;
	float y;
	Point() {
		//empty constructor
	}
	Point(float xx, float yy) {
		x = xx;
		y = yy;
	}
}

class Box {
	Vector3 min;
	Vector3 max;
	Box(Vector3 aa, Vector3 bb) {
		min = aa;
		max = bb;
		//echo("box min position: "+String(min.x)+", "+String(min.y)+"\n");
	}
	Box() {
		//empty constructor
	}
	bool intersects(Box box) {
		//if (box.min.x < max.x && box.max.x > min.x && box.min.y < max.y && box.max.y > min.y && box.min.z < max.z && box.max.z > max.z) {
		if (box.min.x < max.x && box.max.x > min.x && box.min.y < max.y && box.max.y > min.y) {
			return true;
		}
		return false;
	}
	bool containsPoint(Vector3 p) {
		if (p.x < max.x && p.x > min.x && p.y < max.y && p.y > min.y && p.z < max.z && p.z > min.z) {
			return true;
		}
		//echo(String(max.y)+"\n");
		return false;		
	}
	bool ortLineIntersects(Vector3 l) {
		return true;
	}
	
	bool intersectsLine(Vector3 lo, Vector3 ld) {
		float txmin;
		float txmax;
		float tymin;
		float tymax;
		if (ld.x == 0) {
			if (lo.x < min.x || lo.x > max.x) { return false; }
			if (lo.y > min.y) {return false; }
		} else if (ld.y == 0) { 
			if (lo.y < min.y || lo.y > max.y) { return false; }
			if (lo.x > min.x) {return false; }
		} else {		
			//echo("min.x:"+String(min.x)+", max.x:"+String(max.x)+", lo.x:"+String(lo.x)+"\n");
			if (ld.x > 0) {
				txmin = (min.x - lo.x) / ld.x;
				txmax = (max.x - lo.x) / ld.x;			
			} else {
				txmin = (max.x - lo.x) / ld.x;
				txmax = (min.x - lo.x) / ld.x;
			}
			if (ld.y > 0) {
				tymin = (min.y - lo.y) / ld.y;
				tymax = (max.y - lo.y) / ld.y;		
			} else {
				tymin = (max.y - lo.y) / ld.y;
				tymax = (min.y - lo.y) / ld.y;
			}
			if (txmin > tymax || tymin > txmax) {
				return false;
			}				
		}
		//float tmin = (tax > tay) ? tax : tay;
		//float tmax = (tbx > tby) ? tbx : tby;
		//echo("test\n");
		return true;		
	}
}
void swap(float &out a, float &out b) {
	echo("swap");
	float c = a;
	a = b;
	b = c;
} 
class Plane {
	Vector3 a, b, c;
	Vector3 n;
	float d;
	Plane() {
		//empty construtor
	}
	Plane(Vector3 aa, Vector3 bb, Vector3 cc) {
		a = aa;
		b = bb;
		c = cc;
		getNormal();
		d = dot(n, a);
	}
	Plane(Vector3 aa, Vector3 nn) {
		a = aa;
		n = nn;
		d = dot(n, a);
	}
	Vector3 getNormal() {		
		Vector3 ab = getDirectionVector(a, b);
		Vector3 ac = getDirectionVector(a, c);
		n = cross(ab, ac);
		return n;
	}
	bool lineIntersect(Vector3 la, Vector3 lb, Vector3 &out intersect) {
		// get plane normal n
		// get d (delta) of plane by (n dot a) where a is point on plane
		// get u which is the direction vector of the line la, lb
		// get t (which is the multiple of u to its intersect point on plane) trough -(la dot n) / u dot n
		// get intersect p trough la+(t*u)
		
		Vector3 u = getDirectionVector(la, lb);
		if (dot(u, n) != 0) {
			//float t = -(dot(la, n)+d)/(dot(u, n)); 
			float t = -(la.dot(n)+d)/u.dot(n);
			intersect = la+Vector3(t*u.x, t*u.y, t*u.z);
			return true;
		} else {
			return false;
		}
	}
	bool lineIntersect(Vector3 lo, Vector3 u, float l, Vector3 &out intersect) {		
		if (dot(u, n) != 0) {
			float t = -(lo.dot(n)+d)/u.dot(n);
			if (t < l) {  
				return false; 
			} else {
				intersect = lo+Vector3(t*u.x, t*u.y, t*u.z);
				return true;
			}	
		} else {
			return false;
		}
	}	
}

