

class Projectile:Base {
	Object@ object;
	PointLight@ glow;
	Timer@ timer;
	Box stage;	
	Quaternion orientation;
	Weapon@ emitter;
	//bool addedToScene = false;
	float sp;
	float speed;
	bool removedFromScene = false; 
	
	Projectile() {
	
	}
	Projectile(Timer@ t, Scene@ sc, Weapon e, Box st, int ig, int iw, float sp, bool enemy) {
		//object.model.setColor(Color(255,255,255,255));
		//@emitter = @e;
		orientation = e.quaternion;
		position = e.position;
		stage = st;
		@timer = @t;
		@scene = @sc;
		speed = sp;
		intersectGroup = ig;
		
		
		@glow = PointLight(10);

		if (enemy)
		{
			@object = objectFactory.createPoster(ASSETS_LOCATION+"Models/Effects/bullet_glow_red.png");
			glow.color = Color(255, 50, 50, 255);
		}
		else
		{
			@object = objectFactory.createPoster(ASSETS_LOCATION+"Models/Effects/bullet_glow.png");
			glow.color = Color(50, 50, 255, 255);
		}
			
			
		object.model.getSurface(0).material.mode = pDM_ADDITIVE; 


		scene.add(glow);
		scene.add(object);
		
		object.scale(0.01);
		
		object.rotate(orientation);
		object.rotate(1,0,0,0.5 * PI);
		intersectWith = iw;
		if (@INTERSECT_LIST.get(intersectGroup) != null) {
			INTERSECT_LIST.get(intersectGroup).add(this);
			intersect = true;
		}
		object.setPosition(position);	
		timer.elapsed += Action(this.check);
		Base::addToScene(scene);
		//@emitter = null;		
	}
	~Projectile() {
		if (addedToScene) {
			scene.remove(object);
			scene.remove(glow);
		}	
	}
	void check() {
		Vector3 newPos = object.position+object.quaternion.rotVector3(Vector3(0,0.1,0));
		if(stage.containsPoint(newPos)) {
			object.translate(orientation.rotVector3(Vector3(0,1*speed,0)));
			position = object.position;
			glow.setPosition(position);
		} else {	
			remove();
		}
		//remove();
		intersectTest(this);
	}
	void intersectAction(Base@ obj) {
		remove();
	}
	void remove() {
		timer.elapsed -= Action(this.check);
		//INTERSECT_LIST.removeFromGroup(intersectGroup, this);	
		scene.remove(object);
		scene.remove(glow);
		Base::removeFromScene();
		if (intersect) {
			intersect = false;
			if (@INTERSECT_LIST.get(intersectGroup) != null) {
				INTERSECT_LIST.removeFromGroup(intersectGroup, this);
			}
		}			
		//INTERSECT_LIST.removeFromGroup(intersectGroup, this);	
		//emitter.removePobj(this);
		//@emitter = null;
	}
}