
renderdest	= $02
shifter		= $04
temp		= $05

	; 2000-3fff	buffer 1, even
	; 6000-7fff	buffer 1, odd
	; a000-bfff	buffer 2, even
	; e000-ffff	buffer 2, odd

	; 0c00-0fff	vm
	; 4c00-4fff	vm
	; 8c00-8fff	vm
	; cc00-cfff	vm

state1		= $9000
state2		= $9200
flippixels	= $9500

	.word	basicstub
	*=$801
basicstub
	.(
	.byt	<(line2+2),>(line2+2),<1,>1,$9e,"2065 LFT",0
line2	.byt	0,0
	.)

entry
	sei
	lda	#$34
	sta	1

	.(
	lda	#0
	tax
clr
	sta	$2000,x
	inx
	bne	clr

	inc	clr+2
	bne	clr
	.)

	inc	1

	.(
	;ldx	#0
loop
	stx	temp
	ldy	#4
loop2
	lsr	temp
	php
	lsr	temp
	rol
	plp
	rol
	dey
	bne	loop2

	sta	flippixels,x
	inx
	bne	loop
	.)

	.(
	lda	#$08
loop1
tblmod	ldy	filltable
	beq	done

	sty	mod+2
	;ldx	#0
	ldy	#4
loop2
mod	sta	!0,x
	inx
	bne	loop2

	inc	mod+2
	dey
	bne	loop2

	inc	tblmod+1
	lda	#$a2
	bne	loop1	; always
done
	.)

	inc	state1+$80

	.(
	;lda	#$18
	;sta	$d016
	lda	#$38
	sta	$d018
	;ldx	#0
	stx	$d020
	stx	$d021
	.)

#ifdef STOPPABLE
	lda	#$7f
	sta	$dc00
#endif

	.(
	ldx	#$18
loop
	lda	sidinit,x
	sta	$d400,x
	dex
	bpl	loop
	.)

mainloop
	lda	#<($2000+24*320+160)
	sta	renderdest
	lda	#>($2000+24*320+160)
	sta	renderdest+1

	ldx	#$17

	lda	#$21
	ldy	#$9f

	jsr	mainsub

	lda	#<($a000+24*320+160)
	sta	renderdest
	lda	#>($a000+24*320+160)
	sta	renderdest+1

	ldx	#$15

	lda	#$a1
	ldy	#$1f

	jsr	mainsub

	jmp	mainloop

mainsub
	.(
	stx	$dd00
	sta	src1a+2
	sty	dest1a+2
	eor	#$40
	sta	src2a+2
	tya
	eor	#$40
	sta	dest2a+2

	lda	#$37
	sta	$d011

	jsr	render

	ldy	#1
	ldx	#$40
	jsr	copysomex

	jsr	copysome2

	lda	#7
	sta	temp
loop
	jsr	copysome1_2
	dec	temp
	bne	loop

	rts
	.)

render
	lda	$d011
	and	#7
	sta	$d408

	.(
	; run state machine

	ldx	#$7f
	clc
runloop
flip1	lda	state1,x
flip2	adc	state1+1,x
flip3	adc	state1+2,x
	tay
	lda	lookup,y
flip4	sta	state2+1,x
	inx
	bne	runloop

flip6	lda	state1+$81
flip7	sta	state2+$7f

	; write to 40 bytes, 8 apart, around renderdest

	lda	renderdest
	sta	mod1+1
	sta	mod2+1
	lda	renderdest+1
	sta	mod1+2
	sta	mod2+2

	ldy	#79
nextbyte
	lda	#$01
	sta	shifter

	lda	mod2+1
	sec
	sbc	#8
	sta	mod2+1
	bcs	noc2

	dec	mod2+2
noc2
copy
	iny
flip5	lda	state2+$80-80,y
	lsr
	rol	shifter
	lsr
	rol	shifter
	bcc	copy

	.byt	$a7,shifter	; lax zp
mod1
	sta	!0
	lda	flippixels,x
mod2
	sta	!0

	cpy	#159
	bcs	done

	lda	mod1+1
	;clc
	adc	#8
	sta	mod1+1
	bcc	nextbyte

	inc	mod1+2
	bne	nextbyte	; always
done
	and	#$3f
	sta	$d400

	;sta	$d018
	ora	#$18
	and	#$19
	sta	$d016

	lda	flip1+2
	sta	flip4+2
	sta	flip5+2
	sta	flip7+2
	eor	#>(state1^state2)
	sta	flip1+2
	sta	flip2+2
	sta	flip3+2
	sta	flip6+2

	; if renderdest bit 14 is clear, set it
	; otherwise, clear it and add 1

	lda	renderdest+1
	eor	#$40
	sta	renderdest+1
	and	#$40
	bne	noinc

	inc	renderdest
noinc
	rts
	.)

copysome1_2
	dec	$d011
	inc	$dd00
	jsr	copysome
copysome2
	dec	$dd00
copysome
	.(
#ifdef STOPPABLE
	lda	$dc01
	eor	#$ef
	beq	space
#endif
	lda	countermsb
	sta	$d40f
	sta	$d416
	eor	#166		; Roughly 20 per minute, 166 for the full structure
	bne	noend
space
	;lda	#0
	sta	lookup+1
	sta	lookup+6
	lda	#$40
	sta	$d404
	lda	#$10
	sta	$d40b
	lda	#$12
	sta	$d412
noend
	ldx	counterlsb
	inx
	inx
	stx	counterlsb
	stx	$d40e
	bne	noc1

	inc	countermsb
noc1
	.)

	jsr	render
	ldy	#2
	ldx	#0
copysomex
src1a	lda	!$00,x
dest1a	sta	!$c0,x
src2a	lda	!$00,x
dest2a	sta	!$c0,x
	inx
	bne	copysomex

	inc	src1a+2
	inc	dest1a+2
	inc	src2a+2
	inc	dest2a+2
	dey
	bne	copysomex

	;dec	$d020
	bit	$d011
	bpl	*-3
	;inc	$d020

	rts

filltable
	.byt	$d8,$0c,$4c,$8c,$cc,$00
lookup = * - 1
	;.byt	0
	.byt	1
	.byt	0
	.byt	2
	.byt	3
	.byt	0
	.byt	2
	.byt	2
	.byt	1
	;.byt	0
sidinit
	.byt	$00,$04,$00,$04,$61,$ff,$fa
	.byt	$ff,$02,$00,$04,$11,$ff,$fa
counterlsb = * + 2
countermsb = * + 3
	.byt	$00,$00,$00,$01,$13,$ff,$ff
	.byt	$07,$00,$f1,$1f

