﻿import threading
import pygame
import math
import string,cgi,time
import sys
import os
from os import curdir, sep, path, system
import socket
import subprocess
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer

# defines
soundnames=["a","b","c","d","e","f","g1","g2","g3","g4","k","l","m","n","o","p","h-b","h-h","h-c","h-d","h-es","h-g"]		# all samples and icons are located in /samples/. Samples must have extension .wav and icons .bmp
iconnames=["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p"]
harmonySample=[[6,6,6,6,7,7,8,9],[18,18,18,18,16,16,17,17],[20,20,20,20,20,20,19,19],[21,21,21,21,21,21,21,21]]
sampleVolume=[0.0,  1.0,1.0,1.0,1.0,1.0,  1.0,1.0,1.0,1.0,  0.5,0.8,0.8,0.5,  1.0,0.6]
songPos=0
numChannels=16																		# number of available samples/channels
maxSounds=12																		# maximum number of sounds triggered simultaneously
fullscreen=True																		# running in fullscreen?
runLocal=False
showJitter=False
showVoteFlag=False
bpm=135.0
# global variables
screenWidth=0
screenHeight=0
sounds=[]
channels=[]
votedLevels=[[[0,i] for i in range(numChannels)] for j in range(16)]				# initialize with 0. first index is pattern position (0..15), second parameter is sample/channel, third parameter is 0=volume or 1=sample index (don't change sample index!)
votedAchLevels=[[[0,i] for i in range(numChannels)] for j in range(16)]				# weighted currently playing samples (copy of votedSortedLevels for every step)
screen=None
font=None
fontCredits=None
displayLevels=[0 for i in range(numChannels)]
icons=[]
pos=0
sample=0
running=True
serverRunning=True
ip=""
surfBPM=None
surfIP=None
surfSteps=None
surfLogo=None
surfConnect=None
surfPost=None
surfDancer=[]
connectCount=0
postCount=0
lastSoundCall=0.0
showLastScreen=False
keyBlocked=False
masterVolume=1.0
fadeOutStart=0
#---- achievement flags (0=not achieved, 1..10=achievement shown, 11..20=achievement fading out, >20 achievement achieved, but not shown anymore
achCacophony=0
achMelodic=0
achSync=0
achPlayboy=0
achHardcore=0
achMellow=0
achInitial=0
achTraffic=0
achPerformer=0
achConnector=0
surfCacophony=None
surfMelodic=None
surfSync=None
surfPlayboy=None
surfHardcore=None
surfMellow=None
surfInitial=None
surfTraffic=None
surfPerformer=None
surfConnector=None
surfStepOn=None
surfStepOff=None
surfLogo=None
#---caching stuff
cache={'a':'a'}				# webserver cache. put in something, so python knows, this will be a dict

# --------------- debugging
def showVotes():
	global votedLevels, numChannels, displayLevels, showVoteFlag
	
	if not showVoteFlag:
		return
	
	system('cls')
	for y in range(numChannels):
		outstr=""
		for x in range(16):
			instPos=0
			for z in range(numChannels):
				if votedAchLevels[x][z][1]==y:
					instPos=z
					break
			if votedAchLevels[x][z][0]>0.0:
				outstr+="{:.1f} ".format(votedAchLevels[x][z][0])
			else:
				outstr+="    "
		print outstr

	outstr=""
	for y in range(numChannels):
		outstr+="{:.1f} ".format(displayLevels[y])
	print outstr
		

# ------------------ init stuff
def initSound():
	global numChannels, soundnames, sounds, channels, icons
	print "init sound system"
	pygame.mixer.pre_init(44100,-16,2,1024)												# init the mixer
	pygame.init()
	pygame.mixer.init()
	mxs=pygame.mixer.get_init()
	if mxs!=None:
		print "mixer settings "+str(mxs)
	else:
		raise SystemExit, "mixer not initialized"
	pygame.mixer.set_num_channels(len(soundnames))
	if pygame.mixer.get_num_channels()!=len(soundnames):
		raise SystemExit, "requested channels not available, got "+str(pygame.mixer.get_num_channels())+" channels"
	# preloading the samples
	for i in range(len(soundnames)):
		try:
			sound=pygame.mixer.Sound("samples/"+soundnames[i]+".wav")
		except:
			raise SystemExit, "error importing sound samples/"+soundnames[i]+".wav"
		sounds.append(sound)
		channels.append(pygame.mixer.Channel(i))
	try:															# try to activate analog output (in case of HDMI output should be default)
		subprocess.call(['amixer','cset','numid=3','1'])
	except:
		print "couldn't set sound output to analog, probably this is no Raspberry Pi ;-)"
	print "sound system initialized"
	
	
def initDisplay():
	global screen, screenWidth, screenHeight, surf, font, fontCredits, fullscreen
	global surfBPM, surfIP, surfSteps, ip, surfConnect, surfPost
	global surfCacophony, surfMelodic, surfSync, surfPlayboy, surfHardcore, surfMellow, surfInitial, surfTraffic, surfPerformer, surfConnector, surfStepOn, surfStepOff, surfLogo, surfDancer

	print "init video system"
	os.putenv("SDL_VIDEODRIVER", "fbcon")
	pygame.display.init()																# init the display
	if pygame.display.get_init()!=True:
		raise SystemExit, "display not initialized"
	if screenWidth==0 or screenHeight==0:
		size=(pygame.display.Info().current_w, pygame.display.Info().current_h)
	else:
		size=(screenWidth, screenHeight)
	if fullscreen:
		screen=pygame.display.set_mode(size, pygame.FULLSCREEN)
	else:
		screen=pygame.display.set_mode(size, 0)
	if screen==None:
		raise SystemExit, "couldn't set display mode"
	print "running at "+str(size)
	screenWidth=screen.get_width()
	screenHeight=screen.get_height()
	surf=pygame.Surface(screen.get_size())
	font=pygame.font.Font("Comfortaa-Bold.ttf",getPixY(0.05))
	fontCredits=pygame.font.Font("Comfortaa-Bold.ttf",getPixY(0.04))
	pygame.mouse.set_visible(False)
	# prerender static text
	surfBPM=font.render("BPM: ", True, (192,188,180))
	surfIP=pygame.font.Font("Comfortaa-Bold.ttf",getPixY(0.07)).render("Connect at "+ip, True, (255,255,255))
	surfSteps=pygame.font.Font("Comfortaa-Bold.ttf",getPixX(0.029)+2).render("Step   1    2    3    4    5    6    7    8    9   10   11   12   13   14   15   16", True, (192,188,180))
	surfConnect=font.render("Users: ", True, (192,188,180))
	surfPost=font.render("Posts: ", True, (192,188,180))
	try:
		surfDancer.append(pygame.image.load("dancer1_1.bmp"))
		surfDancer.append(pygame.image.load("dancer1_2.bmp"))
		surfDancer.append(pygame.image.load("dancer1_2.bmp"))
		surfDancer.append(pygame.image.load("dancer1_1.bmp"))
#		surfDancer.append(pygame.image.load("dancer2_1.bmp"))
#		surfDancer.append(pygame.image.load("dancer2_2.bmp"))
	except:
		print "error({0}): {1}".format(e.errno, e.strerror)
		raise SystemExit, "error loading image"
	for i in range(len(iconnames)):
		try:
			icon=pygame.image.load("samples/"+iconnames[i]+".bmp")
		except:
			raise SystemExit, "error loading image samples/"+iconnames[i]+".bmp"
		icons.append(icon)

	# load the achievement buttons	
	try:
		surfCacophony=pygame.image.load("achCacophony.bmp")
		surfMelodic=pygame.image.load("achMelodic.bmp")
		surfSync=pygame.image.load("achSync.bmp")
		surfPlayboy=pygame.image.load("achPlayboy.bmp")
		surfHardcore=pygame.image.load("achHardcore.bmp")
		surfMellow=pygame.image.load("achMellow.bmp")
		surfInitial=pygame.image.load("achInitial.bmp")
		surfTraffic=pygame.image.load("achTraffic.bmp")
		surfPerformer=pygame.image.load("achPerformer.bmp")
		surfConnector=pygame.image.load("achConnector.bmp")
		surfStepOn=pygame.image.load("stepon.bmp")
		surfStepOff=pygame.image.load("stepoff.bmp")
		surfLogo=pygame.image.load("logo.bmp")
	except Exception as e:
		print e
		raise SystemExit, "error loading image "
	
	print "video system initialized"

#------------ achievement checker
def incAchievements():
	global achHardcore, achMellow, achInitial, achTraffic, achPerformer, achConnector, achCacophony, achMelodic, achPlayboy, achSync
	if achHardcore>0 and achHardcore<30:
		achHardcore+=1
	if achMellow>0 and achMellow<30:
		achMellow+=1
	if achInitial>0 and achInitial<30:
		achInitial+=1
	if achTraffic>0 and achTraffic<30:
		achTraffic+=1
	if achPerformer>0 and achPerformer<30:
		achPerformer+=1
	if achConnector>0 and achConnector<30:
		achConnector+=1
	if achCacophony>0 and achCacophony<30:
		achCacophony+=1
	if achMelodic>0 and achMelodic<30:
		achMelodic+=1
	if achPlayboy>0 and achPlayboy<30:
		achPlayboy+=1
	if achSync>0 and achSync<30:
		achSync+=1

def checkAchievements():
	global votedAchLevels, connectCount, postCount, maxSounds, showLastScreen
	global achHardcore, achMellow, achInitial, achTraffic, achPerformer, achConnector, achCacophony, achMelodic, achPlayboy, achSync
	if postCount<100:
		return						# only check achievements when >=100 sample posts are given
		
	if showLastScreen:				# don't evaluate achievements in final screen, so now achievements accidentally pops up while showing the screen
		return
		
	incAchievements()
		
	if bpm>195:
		if achHardcore==0:
			achHardcore=1
	if bpm<105:
		if achMellow==0:
			achMellow=1
	if postCount>100:
		if achInitial==0:
			achInitial=1
	if postCount>1000:
		if achTraffic==0:
			achTraffic=1
	if postCount>10000:
		if achPerformer==0:
			achPerformer=1
	if connectCount>100:
		if achConnector==0:
			achConnector=1
	melodicCounter=0
	playboyCounter=0
	syncCounter=0
	cacoCounter=0
	for i in range(16):
		if votedAchLevels[i][2][0]>0.8:
			cacoCounter+=1
		if votedAchLevels[i][1][0]<0.5:
			syncCounter+=1
		for x in range(maxSounds):
			if votedAchLevels[i][x][1]>=6 and votedAchLevels[i][x][1]<=9:
				melodicCounter+=1
			if votedAchLevels[i][x][1]==11 or votedAchLevels[i][x][1]==12:
				playboyCounter+=1
	if cacoCounter>=8:
		if achCacophony==0:
			achCacophony=1
	if melodicCounter>=8:
		if achMelodic==0:
			achMelodic=1
	if playboyCounter>=8:
		if achPlayboy==0:
			achPlayboy=1
	if syncCounter>=8:
		if achSync==0:
			achSync=1
	

#------------ web server stuff
def getFile(filename, mode):
	if cache.has_key(filename):
		return cache[filename]
	else:
		try:
			f=open(curdir + sep + filename, mode)
			buf=f.read()
			f.close()
			cache[filename]=buf
			return buf
		except Exception as e:
			print "error({0}): {1} {2}".format(e.errno, e.strerror, filename)
	
class MyHandler(BaseHTTPRequestHandler):
	def do_GET(self):
		global votedLevels, connectCount, postCount, bpm, serverRunning
		if not serverRunning:
			return
		try:
			filename=path.basename(self.path)
			if len(filename)==2:
				instr=ord(filename[0])-97
				patpos=ord(filename[1])-97
				if instr>=0 and instr<numChannels and patpos>=0 and patpos<16:
					votedLevels[patpos][instr][0]+=0.1
#					votedLevels[patpos][instr][0]=votedLevels[patpos][instr][0]*0.9+0.1		# alternative way of calculating samples, this is recommended if fast changes are required, even with a lot of posts
					postCount+=1
				self.send_response(200)
				return
			if len(filename)==1:
				if filename=="a":
					bpm-=1.0
					if (bpm<100.0):
						bpm=100.0
					postCount+=1
				if filename=="b":
					bpm+=1.0
					if (bpm>200.0):
						bpm=200.0
					postCount+=1
			if filename.endswith(".gif") or filename.endswith(".png"):
				self.send_response(200)
				if filename.endswith(".gif"):
					self.send_header('Content-type', 'image/gif')
				if filename.endswith(".png"):
					self.send_header('Content-type', 'image/png')
				self.end_headers()
				self.wfile.write(getFile("samples"+sep+filename, "rb"))
				return
			# fallback - we always deliver the index.html if anything else (or nothing) is requested
			if filename=="index.html" or filename=="":
				self.send_response(200)
				self.send_header('Content-type', 'text/html')
				self.end_headers()
				self.wfile.write(getFile("index.html", "r"))
				connectCount+=1
				return
			return
		except IOError:
			self.send_error(404,'File Not Found: %s' % self.path)
	def log_message(self, format, *args):
		return

# -------- play one bar given by pos
def normalizeLevels(pos):
	global votedLevels
	maxlevel=0.0
	for x in range(numChannels):
		if votedLevels[pos][x][0]>maxlevel:
			maxlevel=votedLevels[pos][x][0]
	if maxlevel<=0:
		maxlevel=1
	return maxlevel
	
def falldownLevels():
	global votedLevels
	for y in range(16):
		for x in range(numChannels):
			votedLevels[y][x][0]*=0.996

def getVotedKey(item):
	return item[0]
def playBar(pos):
	global votedAchLevels, votedLevels, masterVolume, songPos
	falldownLevels()
	maxlevel=normalizeLevels(pos)
	votedSortedLevels=sorted(votedLevels[pos], key=getVotedKey, reverse=True)			# sort all voted volumes for the position
	for i in range(numChannels):														# store the weighted sorted levels in global list for achievement checking
		votedAchLevels[pos][i][1]=votedSortedLevels[i][1]
		votedAchLevels[pos][i][0]=votedSortedLevels[i][0]/maxlevel
	for i in range(numChannels):														# first level falldown of all channels
		displayLevels[i]=max(0.0,displayLevels[i]-0.15)
	for curSample in range(maxSounds):													# only play the first <maxSounds> highest voted sounds
		initsample=votedSortedLevels[curSample][1]
		if initsample>=6 and initsample<=9:												# the tone samples need to be handled differently due to harmonic structures
			sample=harmonySample[initsample-6][songPos]
		else:
			sample=initsample
		volume=votedSortedLevels[curSample][0]/maxlevel
		if volume>0.0:																	# do not accidentally mute playing sounds
			volume=min(1.0,volume)
			channels[sample].set_volume(volume*masterVolume*sampleVolume[initsample])	# set the volume (capped to 1.0)
			channels[sample].play(sounds[sample])										# and play the sample on its respective channel
			displayLevels[initsample]=volume
	checkAchievements()
	
# -------- set the timer depending on the BPM (retriggers the timer interval)
def setBPM():
	return 60.0/bpm/4.0

# -------- update the screen
def drawAchievement(surfAch, achStep):
	if achStep>0 and achStep<30:
		surfsize=min(0.3, max(0.0, math.sin(float(achStep)*0.1047)))
		surf.blit(pygame.transform.scale(surfAch,(getPixX(surfsize), getPixY(surfsize*0.375))),(getPixX(0.17-surfsize/2.0),getPixY(0.3-surfsize/4.0)))

def drawScreen():
	global achHardcore, achMellow, achInitial, achTraffic, achPerformer, achConnector, achCacophony, achMelodic, achPlayboy, achSync, bpm, pos
	global surfCacophony, surfMelodic, surfSync, surfPlayboy, surfHardcore, surfMellow, surfInitial, surfTraffic, surfPerformer, surfConnector, surfStepOn, surfStepOff, surfLogo, surfConnect, surfPost, surfDancer
	global connectCount, postCount, font, fontCredits, fadeOutStart, masterVolume
	surf.fill((48,46,42))
	surf.blit(pygame.transform.scale(surfLogo,(getPixX(0.3),getPixY(0.2))), (getPixX(0.0),getPixY(0.0)))
	
	if not showLastScreen:
		if surfConnect!=None:																									# primary screen
#			surf.blit(pygame.transform.scale(surfConnect,(getPixX(0.09),getPixY(0.06))), (getPixX(0.45),getPixY(0.13)))
			surf.blit(surfConnect, (getPixX(0.45),getPixY(0.13)))
		text=font.render(str(int(connectCount)), True, (255,255,255))
		surf.blit(text, (getPixX(0.6),getPixY(0.13)))
		if surfPost!=None:
			surf.blit(surfPost, (getPixX(0.45),getPixY(0.18)))
		text=font.render(str(int(postCount)), True, (255,255,255))
		surf.blit(text, (getPixX(0.6),getPixY(0.18)))
		if surfBPM!=None:
			surf.blit(surfBPM, (getPixX(0.45),getPixY(0.23)))
		text=font.render(str(int(bpm)), True, (255,255,255))
		surf.blit(text, (getPixX(0.6),getPixY(0.23)))
		if surfIP!=None:
			surf.blit(surfIP, (getPixX(0.447),getPixY(0.04)))
		if surfSteps!=None:
			surf.blit(surfSteps, (getPixX(0.05),getPixY(0.75)))
		for i in range(1, numChannels):
			size=1.0/numChannels*displayLevels[i]*0.7+0.03
#			surf.blit(pygame.transform.scale(icons[i],(getPixX(size),getPixY(size*1.5))),(0.05+getPixX(1.0/numChannels*i-size/2.0),getPixY(0.5-size/2.0)))						# zoom sample icons completely out
			surf.blit(pygame.transform.scale(icons[i],(getPixX(size),getPixY(size*1.5))),(getPixX(0.415+float(i%4)*0.07-size/2.0),getPixY(0.35+float(i/4)*0.082-size/2.0)))		# zoom sample icons only to a certain amount

		surf.blit(pygame.transform.scale(surfDancer[0+(pos/4)%2],(getPixX(0.1),getPixY(0.3))), (getPixX(0.265),getPixY(0.34)))
		surf.blit(pygame.transform.scale(surfDancer[2+(pos/4)%2],(getPixX(0.1),getPixY(0.3))), (getPixX(0.665),getPixY(0.34)))
		
		drawAchievement(surfCacophony, achCacophony)
		drawAchievement(surfMelodic, achMelodic)
		drawAchievement(surfSync, achSync)
		drawAchievement(surfPlayboy, achPlayboy)
		drawAchievement(surfHardcore, achHardcore)
		drawAchievement(surfMellow, achMellow)
		drawAchievement(surfInitial, achInitial)
		drawAchievement(surfTraffic, achTraffic)
		drawAchievement(surfPerformer, achPerformer)
		drawAchievement(surfConnector, achConnector)
		
		for i in range(16):
			if i==pos:
				surf.blit(pygame.transform.scale(surfStepOn,(getPixX(0.035),getPixY(0.053))), (getPixX(0.13+float(i)/20.3), getPixY(0.68)))
			else:
				surf.blit(pygame.transform.scale(surfStepOff,(getPixX(0.035),getPixY(0.053))), (getPixX(0.13+float(i)/20.3), getPixY(0.68)))
				
	else:																														# last screen ("outtro")
		fadeTime=float(pygame.time.get_ticks()-fadeOutStart)/1000.0
		masterVolume=max(1.0-fadeTime/3.0, 0.0)
		achStr=["[  ]", "[x]"]
		achCol=[(128,128,128), (0,255,50)]
		surf.blit(font.render("Thanks for your participation", True, (math.sin(fadeTime*5.0)*127.0+127.0,255,math.sin(fadeTime*5.0)*127.0+127.0)), (getPixX(0.47), getPixY(0.02)))
		surf.blit(font.render("Achievements:", True, (128,128,128)), (getPixX(0.47), getPixY(0.1)))
		surf.blit(font.render(achStr[achConnector>0]+" Networking", True, achCol[achConnector>0]), (getPixX(0.47), getPixY(0.2)))
		surf.blit(font.render(achStr[achInitial>0]+" Warm up", True, achCol[achInitial>0]), (getPixX(0.47), getPixY(0.27)))
		surf.blit(font.render(achStr[achTraffic>0]+" Performer", True, achCol[achTraffic>0]), (getPixX(0.47), getPixY(0.34)))
		surf.blit(font.render(achStr[achPerformer>0]+" Outperformer", True, achCol[achPerformer>0]), (getPixX(0.47), getPixY(0.41)))
		surf.blit(font.render(achStr[achMelodic>0]+" Supercomposer", True, achCol[achMelodic>0]), (getPixX(0.47), getPixY(0.48)))
		surf.blit(font.render(achStr[achCacophony>0]+" Cacophony", True, achCol[achCacophony>0]), (getPixX(0.47), getPixY(0.55)))
		surf.blit(font.render(achStr[achSync>0]+" Minds in sync", True, achCol[achSync>0]), (getPixX(0.47), getPixY(0.62)))
		surf.blit(font.render(achStr[achPlayboy>0]+" Playboy", True, achCol[achPlayboy>0]), (getPixX(0.47), getPixY(0.69)))
		surf.blit(font.render(achStr[achMellow>0]+" Ridiculous Speed", True, achCol[achMellow>0]), (getPixX(0.47), getPixY(0.76)))
		surf.blit(font.render(achStr[achHardcore>0]+" Ludicrous Speed", True, achCol[achHardcore>0]), (getPixX(0.47), getPixY(0.83)))
		surf.blit(fontCredits.render("Concept:", True, (128,128,128)), (getPixX(0.05), getPixY(0.65)))
		surf.blit(fontCredits.render("Code:", True, (128,128,128)), (getPixX(0.05), getPixY(0.7)))
		surf.blit(fontCredits.render("Graphics:", True, (128,128,128)), (getPixX(0.05), getPixY(0.75)))
		surf.blit(fontCredits.render("Samples:", True, (128,128,128)), (getPixX(0.05), getPixY(0.8)))
		surf.blit(fontCredits.render("Music:", True, (128,128,128)), (getPixX(0.05), getPixY(0.85)))
		surf.blit(fontCredits.render("SquoQuo", True, (128,128,128)), (getPixX(0.2), getPixY(0.65)))
		surf.blit(fontCredits.render("Hopper", True, (128,128,128)), (getPixX(0.2), getPixY(0.7)))
		surf.blit(fontCredits.render("Raven/Nuance", True, (128,128,128)), (getPixX(0.2), getPixY(0.75)))
		surf.blit(fontCredits.render("Hopper", True, (128,128,128)), (getPixX(0.2), getPixY(0.8)))
		surf.blit(fontCredits.render("You", True, (128,128,128)), (getPixX(0.2), getPixY(0.85)))


		
def getPixX(xFloat):
	return int(max(0.0,min(1.0,xFloat))*screenWidth)
def getPixY(yFloat):
	return int(max(0.0,min(1.0,yFloat))*screenHeight)

# ----------------- multithreading stuff
class webserver(threading.Thread):
	def __init__(self, threadID, name, counter):
		threading.Thread.__init__(self)
		self.threadID = threadID
		self.name = name
		self.counter = counter
	def run(self):
		global ip, running, runLocal, serverRunning
		if runLocal:
			server = HTTPServer(('', 80), MyHandler)				# local development
			print "started server thread at 127.0.0.1:80"
		else:
			server = HTTPServer((ip, 80), MyHandler)				# production setting
			print 'started server thread at '+ip+':80'
		while serverRunning:
			server.serve_forever()
		print 'server stopped'

def soundPlayer():
	global pos, surf, thread2, lastSoundCall, showJitter, songPos
	
	newInterval=setBPM()
	timeNow=time.clock()
	if lastSoundCall!=0.0:
		timeElapsed=timeNow-lastSoundCall
		jitter=timeElapsed-newInterval
	else:
		timeElapsed=newInterval
		jitter=0.0
	lastSoundCall=timeNow
	if showJitter:
		print "elapsed="+str(int(timeElapsed*1000.0))+" target="+str(int(newInterval*1000.0))+" jitter="+str(int(jitter*1000.0))

	playBar(pos)					# play the current bar
	pos+=1							# proceed to next bar
	if pos==16:
		pos=0
		songPos=(songPos+1)%8
 	if running:
 		jitter=max(min(jitter, 0.1), -0.03)								# constrain the correction factor to a sensible interval of +/- 30ms
		thread2=threading.Timer((newInterval-jitter*0.8), soundPlayer)	# correct the next interval with the jitter from the last interval. This may give a slight "swing" feeling to it, but overall the timing is stable this way
		thread2.start()


#---------------------- MAIN
for arg in sys.argv:
	if arg=="win":
		fullscreen=False
		print "window mode"
	if arg=="l":
		runLocal=True
		print "local mode"
	if arg=="j":
		showJitter=True
		print "showing jitter"
	if arg=="v":
		showVoteFlag=True
		print "showing votes"
	if arg[:2]=="w=":
		try:
			screenWidth=int(arg[2:])
			print "screenWidth="+str(screenWidth)
		except:
			print "wrong width argument"
	if arg[:2]=="h=":
		try:
			screenHeight=int(arg[2:])
			print "screenHeight="+str(screenHeight)
		except:
			print "wrong height argument"
	if arg[:3]=="ip=":
		try:
			ip=arg[3:]
			print "using ip "+ip
		except:
			print "using system ip"
	if arg[:2]=="m=":
		try:
			maxSounds=int(arg[2:])
			print "maxSounds="+str(maxSounds)
		except:
			print "wrong maxsounds argument"


# init stuff
if ip=="":
	if runLocal:
		ip="127.0.0.1"
	else:
		ip=socket.gethostbyname(socket.getfqdn())
initSound()
initDisplay()

clock=pygame.time.Clock()						# init the timer stuff

# set the inital pattern
for i in range(16):
	if i%4==0:
		votedLevels[i][1][0]=1.0
	else:
		votedLevels[i][0][0]=1.0

# Create new threads
thread1=webserver(1, "webserver", 1)
# and play it
thread2=threading.Timer(setBPM(), soundPlayer)
# Start new Threads
thread1.start()
thread2.start()
	
while running:									# main loop for drawing the screen if time is left :)
	try:
		drawScreen()							# draw the whole screen
		screen.blit(surf,(0,0))
		pygame.display.update()
		showVotes()

		if pygame.key.get_pressed()[pygame.K_ESCAPE]:
			if not keyBlocked:
				if not showLastScreen:			# we're in the main screen, so Escape switches to the last screen ("outtro")
					showLastScreen=True
					keyBlocked=True
					serverRunning=False
					fadeOutStart=pygame.time.get_ticks()
				else:
					running=False				# we're already on the last screen, so Escape stops the whole thing
				thread1._Thread__stop()			# unpolitely kill the generator and the webserver thread
		else:
			keyBlocked=False					# damn keyboard handling	
		if pygame.key.get_pressed()[pygame.K_SPACE]:
			for s in range(16):
				for i in range(16):
					if (s%4==0 and i==1) or (s%4!=0 and i==0) :
						votedLevels[s][i][0]=0.95*votedLevels[s][i][0]+0.05
					else:
						votedLevels[s][i][0]=0.95*votedLevels[s][i][0]
		pygame.event.pump()						# handle all other events

		clock.tick(30)							# limit output to 60 fps if necessary
	except Exception as e:
		print type(e)
		print e.args
		print e
		running=False
		sys.exit(0)
	
thread2.join()									# wait if the player is still playing before we destroy the mixer object
	
pygame.mixer.quit()
pygame.display.quit()

print "over and out"