float ft;
float PI = 3.14159265;
bool isPrimaryRay;

float light = 0.;

mat3 rot_x(float ang) { return mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang), -sin(ang),
			0.0, sin(ang), cos(ang)); }
mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }
mat3 rot_z(float ang) { return mat3(
			cos(ang), -sin(ang), 0.0,
			sin(ang), cos(ang), 0.0,
			0.0, 0.0, 1.0); }

float rot;

struct ray_t 
{
	vec3 o;
	vec3 d;
};

void doplane(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0) { loc_max = curdist; }
	}
}

void domies(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	
		if (abs(det) > 0.0000001)
		{
			float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
			vec3 hp = ray.o + ray.d * curdist;
					
			vec2 u = hp.xy;
			u.x *= -.07;
			u.y *= .23;
			u.y += 2.;
			
			float f = ft;
			f = floor(mod(24.*f, 44.));
			
			
			if (f > 21.) f = 43. - f;
			
			//f = 1.;
			
			vec2 uxy = vec2(1./16. + (1./8.) * mod(f,8.0), 1. - 1./8. - (1./8.)*mod(floor(f/8.),8.));
			vec2 rxy = vec2(u.x, u.y);
			
			rxy.x += .22*sin(ft);
			
			rxy.x = clamp(rxy.x,-0.45, 0.45);
			rxy.y = clamp(rxy.y,0.0, 0.98);
			rxy /= 8.0;
			
			vec2 ruv = vec2(rxy + uxy);
			
			float alpha = texture2D(iChannel0, ruv - vec2(0.,0.5)).r;
		
			if (alpha > .1)
			{
				if (det > 0.0) { loc_min = curdist; loc_obj_id=obj_id; }
				if (det < 0.0) { loc_max = curdist; }
			}
		}
	
}


vec3 ls1;
vec4 pl1 = vec4(0.0, -1., 0.0, 10.0);
vec4 pl2 = vec4(0.0, 1., 0.0, 10.0);
vec4 pl3 = vec4(1.0, 0., 0.0, 10.0);
vec4 pl4 = vec4(-1.0, 0., 0.0, 10.0);
vec4 mies = -vec4(0.0, 0.0, -1.0, 0.0);

float b1ang = 0.0;

float shoot(inout ray_t ray, out int obj_id)
{
	int loc_obj_id;
	float loc_min;
	float loc_max;

	float dist;

	obj_id = 0;
	dist = 100000.0;
	loc_min = -1000000.0;
	loc_max = 1000000.0;
	
	//lattia
	doplane(ray, pl1, 1, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	doplane(ray, pl2, 2, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	doplane(ray, pl3, 3, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	doplane(ray, pl4, 4, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	domies(ray, mies, -1, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	
	return dist;
}

float snoise(vec3 co){
    return fract(sin(dot(co.xyz ,vec3(12.9898,78.233, 191.666))) * 43758.5453);
}


float shade(inout ray_t ray, in float dist, in int obj_id, inout vec3 outcol, inout vec3 refblendfac)
{

	if (obj_id == 0)
	{
		vec3 color;
		color = clamp(ray.d.y * 2.0, 0.0, 1.0) * vec3(0.51, 0.784, 0.98);
		outcol += color * refblendfac;


		return 0.0;
	}

	vec3 color;

	vec3 hp = ray.o + ray.d * dist;
	vec3 normal;
	vec3 thiscol = vec3(0.0);

	vec3 hprot = hp;

	vec2 r;
	normal = -pl1.xyz;
	float scale = .5;
	
	float fr = ft*8.;

	//varjo
	if (obj_id == -1)	
	{

	}
	
	//lattia
	else if (obj_id == 1)
	{
		r = vec2(scale*-10.+ hp.x + fr, hp.z + fr);
	}
	//katto
	else if (obj_id == 2)
	{
		r = vec2(hp.x - fr, hp.z + fr);
	}
	//vasen
	else if (obj_id == 3)
	{
		r = vec2(scale*-10. + hp.y + fr, hp.z + fr);
	}
	
	else if (obj_id == 4)
	{
		r = vec2(hp.y - fr, hp.z + fr);
	}
	
	color = vec3(2.0) * mod(floor(r.x * 1./(10.*scale)) + floor(r.y * 1./(10.*scale)), 2.0);

	float an = mod(1.*ft+4.*atan(hp.x,hp.y)/PI,1.);
	if (an < .5 && mod(ft,1.23) + 2.*sin(an+3.33*ft) < .05) color *= vec3(0.,2.,0.);
	
	r.x *= .025;
	r.y *= .05;
	r = mod(r,1.);
	color += 1.*texture2D(iChannel1, r).rgb;
	
	//normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
	normal = normalize(normal);

	vec3 ld = ls1 - hp;
	float lightdist = length(ld);

	ld /= lightdist;

	float ld_normal_dp = dot(ld, normal);

	float diffuse = max(0.0, ld_normal_dp);

	float specular_amount = 1.0;

	
	ray_t shadowray;
	shadowray.o = hp + ld * 0.0001;
	shadowray.d = ld;

	int id_unused;
	if (shoot(shadowray, id_unused) < lightdist)
	{
		diffuse = 0.0;
		specular_amount = 0.0;
	}
	
	

	vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
	float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

	//float atten = max(0.0, 1.0 - dist * 0.0006);
	vec3 reflection_amount = vec3(0.1) + color * 0.4;
    vec3 new_refblendfac = ref_fac * refblendfac * reflection_amount;

 	// ambient
	thiscol += color * 0.05;
	// diffuse
	thiscol += color * diffuse * 0.9;
	// SMG lighting
	thiscol += vec3(pow(1.0 - ref_fac, 5.0) * 0.2);

	//säkenöinti
	//if (obj_id != -1 && obj_id != 1 && obj_id != 4)
	//{
		float a = mod(atan(hp.x,hp.z)/(2.*PI),1.); 
		float g = mod(a,1.);
		float r1 = 1.-mod(ft + texture2D(iChannel1,vec2(mod(.8*g,.5),mod(.02*hp.y,.5))).b,1.);
		r1 = pow(r1,8.);
		float flash = texture2D(iChannel0,vec2(mod(.8*g,.5),mod(.002*hp.y,.5))).r;
		flash = 1.*pow(flash,8.) * r1;
		thiscol += vec3(flash);
		
		light = flash;
		
	//} 
	 
	outcol += thiscol * refblendfac;
	outcol += vec3(0.8) * pow(max(dot(ref_ray_d, ld), 0.0), 20.0) * specular_amount;

	ray.d = ref_ray_d;
	ray.o = hp;
	refblendfac = new_refblendfac;

	return length(refblendfac);
}

void lights(in ray_t ray, inout vec3 outcol, in float dist, in vec3 refblendfac, in float pwrbase)
{
	vec3 lsv1 = (ls1 - ray.o);
	float light_dist = length(lsv1);
	float ld1 = pow(max(0.0, dot(normalize(lsv1), ray.d)), pwrbase * light_dist);
	//if (light_dist < dist)
	//	outcol += vec3(5.0) * ld1 * refblendfac;
}


vec3 trace(in ray_t p_ray)
{
	ray_t ray;

	int obj_id;
	float dist;
	vec3 refblendfac;
	float cont;

	vec3 outcol;

	outcol = vec3(0.0);
	refblendfac = vec3(1.0);
	ray = p_ray;

	dist = shoot(ray, obj_id);
	lights(ray, outcol, dist, refblendfac, 1000.0);
	cont = shade(ray, dist, obj_id, outcol, refblendfac);

	isPrimaryRay = false;

	vec3 fuggol = vec3(0.0);
	
#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 0.0, 1.0);
	}
#endif


#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 0.0);
	}
#endif


#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 1.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 1.0);
	}
#endif

	return outcol;
}


void set_scene()
{
	ls1 = vec3(0.0, -5.0, 5.0);
#if 1
	ls1.x = 0.+sin(ft * 1.2) * 2.0;
	//ls1.y = -5.+ cos(ft * 1.2) * 2.0;
//	ls1.y = cos(ft * 1.7912) * 1.0 - 5.7; 
	//ls1.z = 0.;//cos(ft * 1.2) * 20.0;
	
	//ls1 = ball1.xyz + vec3(0.,5.,1.);
#endif

	float floor_h = -5.9;
	if (ls1.y < floor_h)
		ls1.y = floor_h-(ls1.y-floor_h);
}


float bshape(vec2 p)
{
	vec2 q = abs(p);
	return max((q.x*0.866025+q.y*0.5),q.y);
}

mat3 lookat(vec3 p1, vec3 p2)
{
	vec3 tovec = normalize(p2 - p1);
	vec3 side = cross(tovec, vec3(0.0, -1.5, 0.0));
	vec3 up = cross(tovec, side);

	return mat3(side, up, tovec);
}

vec4 function()
{
	ft = motionblur(2.0);
	
	set_scene();


	mat3 camdir_mtx = mat3(1.0);

	camdir_mtx = rot_x(-0.4) * camdir_mtx;
	camdir_mtx = rot_y(cos(ft*0.96)*-0.1) * camdir_mtx;
	camdir_mtx = rot_z(sin(ft*5.3)*0.01) * camdir_mtx;


	// ray setup
	ray_t tr;
	tr.o = vec3(0.0, -1.0, -13.0);

	rot = ft*0.56;
	
	tr.o.x = 0.0 ;
	tr.o.y =  0.0 ;
	tr.o.z = 13.0 ;

	tr.o += sin(vec3(6.231,6.912,6.523)*ft) * 0.04;

	camdir_mtx = lookat(tr.o, vec3(0.0, 0.0, 0.0));

	float focal_z_dist = 20.;//mix(fd1, fd2, 0.5 + sin(ft * 0.742) * 0.5);


	tr.d = (vec3(uv2*1.0, 2.0));

	vec3 ray_target = tr.o + camdir_mtx * tr.d * abs(focal_z_dist / tr.d.z);

	// integration setup
	vec3 outcol = vec3(0.0);
	vec2 kpjit = vec2(0.0); 
	kpjit += (texture2D(u_blurnoise, -uvr).rg-vec2(0.5)) * 1.5;

	float accu = 0.0;

	const int kw =3;
	
	for (int x = 0; x < kw; x++)
	{
		for (int y = 0; y < kw; y++)
		{
			ray_t ray;

			vec2 kp = (((vec2(x,y)+kpjit+0.5) / vec2(kw, kw))-0.5)*2.0;

#if 0
			//float bf = 0.9-length(kp);
			float bf = 0.9 - bshape(kp);
			if (bf < 0.0)
				continue;
#endif
			vec2 nuv = uv2 * 0.05;

			#if 1
			nuv += kp * 0.4;
			#endif
 
			// rotatointiin: tee vektorit up ja left, sitten kerro nuv.x ja nuv.y niillä

			ray.o = camdir_mtx * vec3(nuv, 0.0) + tr.o;

			ray.d = normalize(ray_target - ray.o);

			//ray.d = tr.d;

			isPrimaryRay = true;

			outcol += trace(ray);
			accu += 1.0;
		}
	}

	outcol /= accu;

 	float f = floor(mod(24.*ft, 44.));
	
	if (f > 21.) f = 43. - f;
	
	vec2 uxy = vec2(1./16. + (1./8.) * mod(f,8.0), 1. - 1./8. - (1./8.)*mod(floor(f/8.),8.));
	vec2 rxy = vec2(0.5*uv2.x, uv.y);
	
	rxy.x += .22*sin(ft);
	
	rxy.x = clamp(rxy.x,-0.45, 0.45);
	rxy.y = clamp(rxy.y,0.0, 0.98);
	rxy /= 8.0;
	
	vec2 ruv = vec2(rxy + uxy);
	vec3 logo = (1.4+ 1.*light) * texture2D(iChannel0, ruv).rgb;
	
	ruv.x += -.003+texture2D(u_blurnoise, uv * 1.923+sin(ft*vec2(92.212,3.212))).r*0.006;
	float alpha = texture2D(iChannel0, ruv - vec2(0.,.5)).r;
	
	outcol = 1.2*(1.-alpha)*outcol + alpha*logo;
	
	return vec4(outcol, 0.0);
}