uniform sampler2D Texture;
uniform sampler2D Texture2;

uniform vec4 TextureRes;
uniform float Intensity;

varying vec2 v_texCoord;

float GatherAndApply(sampler2D textureSampler, vec2 uv, float baseCoC, vec4 currCol, float stepDistance, out vec4 outCol)
{
	outCol = currCol;
	vec4 col = texture2D(textureSampler, uv);

	bool blurNear = col.w < 0.0;
	float absCoC = abs(col.w);

	if ((absCoC > stepDistance) &&
		(blurNear || (baseCoC > 0.0 && absCoC < baseCoC * 2.0)))
	{
		if (blurNear)
		{
			if (outCol.w < 0.0)
			{
				outCol.w = min(outCol.w, col.w);
			}
			else
			{
				if (-col.w > outCol.w)
				{
					outCol.w = col.w;
				}
			}
		}

		float sampleFraction = clamp((absCoC - stepDistance) * TextureRes.y, 0.0, 1.0);
		outCol.xyz += col.xyz * vec3(sampleFraction);

		return sampleFraction;
	}
	return 0.0;
}


void main()
{
	vec2 uv = v_texCoord;
	vec4 baseColour = texture2D(Texture, uv);

	float divi = 1.0 / 12.0;
	float OneOverScreenWidth = 1.0 / TextureRes.x;
	float OneOverScreenHeight = 1.0 / TextureRes.y;
	float xStep = 0.866 * (OneOverScreenWidth / OneOverScreenHeight);
	vec4 color = vec4(0.0, 0.0, 0.0, baseColour.w);
	vec4 color2 = vec4(0.0, 0.0, 0.0, baseColour.w);

	float sampleCount1 = 0.0;
	float sampleCount2 = 0.0;
	
	for(float i = 0.0; i < 12.0; i += 1.0)
	{
		float stepDistance = (i + 0.5) / TextureRes.y * Intensity;
		vec2 step1 = vec2(0.0, 1.0) * stepDistance;
		vec2 step2 = vec2(xStep, -0.5) * stepDistance;

		//sampleCount1 += GatherAndApply(Texture, uv + step1, baseColour.w, color, stepDistance, color);
		//sampleCount2 += GatherAndApply(Texture, uv + step2, baseColour.w, color2, stepDistance, color2);
		color += texture2D(Texture, uv + step1);
		color2 += texture2D(Texture2, uv + step2);
		sampleCount1 += 1.0;
		sampleCount2 += 1.0;

	}

	
	color.rgb = sampleCount1 > 0.0 ? color.rgb / sampleCount1 : baseColour.rgb;
	color2.rgb = sampleCount2 > 0.0 ? color2.rgb / sampleCount2 : baseColour.rgb;
	
	float maxA = max(color.w, color2.w);
	vec4 out1 = color;
	vec4 out2 = (color + color2);
	out1.w = maxA;
	out2.w = maxA;

	gl_FragData[0] = out1;
	gl_FragData[1] = out2;
}