uniform sampler2D Texture;
uniform sampler2D Texture2;

uniform vec4 TextureRes;
uniform float Intensity;

varying vec2 v_texCoord;

void main()
{
	vec2 uv = v_texCoord;

	vec4 baseColour = texture2D(Texture, uv);

	float divi = 1.0 / 12.0;
	float OneOverScreenWidth = 1.0 / TextureRes.x;
	float OneOverScreenHeight = 1.0 / TextureRes.y;
	vec4 color = vec4(0.0, 0.0, 0.0, baseColour.w);
	vec4 color2 = vec4(0.0, 0.0, 0.0, baseColour.w);
	float xStep = 0.866 * (OneOverScreenWidth/OneOverScreenHeight);
	vec2 step0 = vec2( xStep, -0.5);
	vec2 step1 = vec2(-xStep, -0.5);
	float sampleCount1 = 0.0;
	float sampleCount2 = 0.0;
	
	for(float i = 0.0; i < 12.0; i += 1.0)
	{
		float stepDistance = (i + 0.5) / TextureRes.y * Intensity;

		color += texture2D(Texture, uv + step0 * stepDistance);
		color2 += texture2D(Texture2, uv + step1 * stepDistance);
		sampleCount1 += 1.0;
		sampleCount2 += 1.0;
	}
	
	color.rgb = sampleCount1 > 0.0 ? color.rgb / sampleCount1 : baseColour.rgb;
	color2.rgb = sampleCount2 > 0.0 ? color2.rgb / sampleCount2 : baseColour.rgb;

	vec3 rgbVal = (color.rgb + color2.rgb) / 3.0;
	float alphaVal = max(color.a, color2.a);

	gl_FragData[0] = vec4(rgbVal, baseColour.w);
}
