uniform sampler2D Texture;
uniform sampler2D Texture2;
uniform float Intensity;
uniform float Brightness;
uniform float Distort;
uniform float IntensityAdd;
uniform float Time;
varying vec2 v_texCoord;

void main()
{
	vec2 tc = v_texCoord;
	float y = tc.y;
	float intens = sin(Time * 4.0 + y * 6.0) * 0.5 + 0.5;
	tc.x += (sin(Time * 40.0 + y * 2009.7) + sin(Time * 31.0 + y * y * 3009.1)) * intens * 0.002 * Distort;
	vec4 color1  = texture2D(Texture, tc).rgba;
	vec4 color2 = texture2D(Texture2, tc).rgba;
	
	float intensity = min(1.0, color2.a + IntensityAdd);
	intensity = clamp(intensity, 0.0, 1.0);
	intensity = Intensity * (intensity);

	color1 *= Brightness;
	vec3 col = mix(color2.rgb, color1.rgb, intensity);
	
	gl_FragColor = vec4(col.rgb, 1.0);
}
