#version 150

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in vData
{
    vec2 texCoord;
	vec4 normal;
	vec3 normalLocal;
	vec2 depth;
	vec4 color;
	vec4 eye;
	vec4 pos;
	float height;
}vertex[];

uniform mat4 ProjectionMatrix;
uniform mat4 CameraWorldMatrix;
uniform float Time;
uniform float Extrude;
uniform sampler2D Noise;


out fData
{
    vec2 texCoord;
    vec4 normal;
    vec2 depth;
    vec4 eye;
    vec3 colorMul;
    vec4 pos;
}frag;

mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

float noise( vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);
	vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
	vec2 rg = texture2D( Noise, (uv+ 0.5)/256.0, -100.0 ).yx;
	return -1.0+2.0*mix( rg.x, rg.y, f.z );
}

void main() {
	vec3 mid = (vertex[0].pos.xyz + vertex[1].pos.xyz + vertex[2].pos.xyz) / 3.0;
	vec2 uvMid = (vertex[0].texCoord.xy + vertex[1].texCoord.xy + vertex[2].texCoord.xy) / 3.0 - vec2(0.5);
	
	vec3 relativePos1 = vertex[0].pos.xyz - mid;
	vec3 relativePos2 = vertex[1].pos.xyz - mid;
	vec3 relativePos3 = vertex[2].pos.xyz - mid;
	
	float intens = (noise(vertex[0].pos.xyz) * 0.5 + 0.53) * Extrude;
	mat4 rota = rotationMatrix(vec3(noise(vertex[0].pos.xyz), noise(vertex[1].pos.xyz), 0.0), intens * 1.5);
	vec4 nor1 = rota * vertex[0].normal;
	vec4 nor2 = rota * vertex[1].normal;
	vec4 nor3 = rota * vertex[2].normal;
	
	relativePos1 = (rota * vec4(relativePos1, 1.0)).xyz;
	relativePos2 = (rota * vec4(relativePos2, 1.0)).xyz;
	relativePos3 = (rota * vec4(relativePos3, 1.0)).xyz;
	
	// Gravity
	relativePos1.y -= intens * intens * 8.0;
	relativePos2.y -= intens * intens * 8.0;
	relativePos3.y -= intens * intens * 8.0;
	

	vec3 norBase = vertex[0].normalLocal + vec3(noise(vertex[0].pos.xyz), noise(vertex[1].pos.xyz), noise(vertex[2].pos.xyz)) * 0.5;
	vec3 normi = norBase * 5.0;
	vec4 trans1 = ProjectionMatrix * CameraWorldMatrix * vec4(relativePos1 + mid + normi * intens, 1.0);
	vec4 trans2 = ProjectionMatrix * CameraWorldMatrix * vec4(relativePos2 + mid + normi * intens, 1.0);
	vec4 trans3 = ProjectionMatrix * CameraWorldMatrix * vec4(relativePos3 + mid + normi * intens, 1.0);

    gl_Position = trans1;
    frag.texCoord = vertex[0].texCoord;
    frag.normal = nor1;
    frag.depth = vec2(trans1.z, trans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = vertex[0].pos;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = trans2;
    frag.texCoord = vertex[1].texCoord;
    frag.normal = nor2;
    frag.depth = vec2(trans2.z, trans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = vertex[1].pos;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = trans3;
    frag.texCoord = vertex[2].texCoord;
    frag.normal = nor3;
    frag.depth = vec2(trans3.z, trans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = vertex[2].pos;
    frag.colorMul = vec3(1.0);
    EmitVertex();

    EndPrimitive();
}
