#version 150

layout(triangles) in;
layout(triangle_strip, max_vertices = 24) out;

in vData
{
    vec2 texCoord;
	vec4 normal;
	vec3 normalLocal;
	vec2 depth;
	vec4 color;
	vec4 eye;
	vec4 pos;
	float height;
}vertex[];

uniform mat4 ProjectionMatrix;
uniform mat4 CameraWorldMatrix;
uniform float Time;
uniform float Extrude;


out fData
{
    vec2 texCoord;
    vec4 normal;
    vec2 depth;
    vec4 eye;
    vec3 colorMul;
    vec4 pos;
}frag;

void main() {
	float str = (vertex[0].height + vertex[1].height + vertex[2].height) / 3.0;
	//str *= sin(Time * 1.0) * 0.5 + 0.5;
	str *= Extrude;
	vec3 mul2 = vec3(1.0 - str) * 0.5;
	
	vec4 ltrans1 = vec4(vertex[0].pos.xyz + vertex[0].normalLocal * str, 1.0);
	vec4 ltrans2 = vec4(vertex[1].pos.xyz + vertex[1].normalLocal * str, 1.0);
	vec4 ltrans3 = vec4(vertex[2].pos.xyz + vertex[2].normalLocal * str, 1.0);
	vec4 lntrans1 = vec4(vertex[0].pos.xyz, 1.0);
	vec4 lntrans2 = vec4(vertex[1].pos.xyz, 1.0);
	vec4 lntrans3 = vec4(vertex[2].pos.xyz, 1.0);
	
	vec4 trans1 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[0].pos.xyz + vertex[0].normalLocal * str, 1.0);
	vec4 trans2 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[1].pos.xyz + vertex[1].normalLocal * str, 1.0);
	vec4 trans3 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[2].pos.xyz + vertex[2].normalLocal * str, 1.0);
	vec4 ntrans1 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[0].pos.xyz, 1.0);
	vec4 ntrans2 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[1].pos.xyz, 1.0);
	vec4 ntrans3 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[2].pos.xyz, 1.0);
	
	vec2 uv1 = vec2(vertex[0].texCoord.x, vertex[1].texCoord.y);
	vec2 uv3 = vec2(vertex[0].texCoord.x, vertex[2].texCoord.y);
	vec2 uv2 = vec2(vertex[1].texCoord.x, vertex[0].texCoord.y);
	vec2 uv5 = vec2(vertex[1].texCoord.x, vertex[2].texCoord.y);
	vec2 uv4 = vec2(vertex[2].texCoord.x, vertex[0].texCoord.y);
	vec2 uv6 = vec2(vertex[2].texCoord.x, vertex[1].texCoord.y);
	
    gl_Position = trans1;
    frag.texCoord = vertex[0].texCoord;
    frag.normal = vertex[0].normal;
    frag.depth = vec2(trans1.z, trans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = ltrans1;
    frag.colorMul = vec3(1.0);
    EmitVertex();

    gl_Position = trans2;
    frag.texCoord = vertex[1].texCoord;
    frag.normal = vertex[1].normal;
    frag.depth = vec2(trans2.z, trans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = ltrans2;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = trans3;
    frag.texCoord = vertex[2].texCoord;
    frag.normal = vertex[2].normal;
    frag.depth = vec2(trans3.z, trans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = ltrans3;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    EndPrimitive();
    
    // 2- 0 side
    // *****************
    gl_Position = trans3;
    frag.texCoord = vertex[2].texCoord;
    frag.normal = vertex[2].normal;
    frag.depth = vec2(trans3.z, trans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = ltrans3;
    frag.colorMul = vec3(1.0);
    EmitVertex();

    gl_Position = ntrans3;
    frag.texCoord = uv5;
    frag.normal = vertex[2].normal;
    frag.depth = vec2(ntrans3.z, ntrans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = lntrans3;
    frag.colorMul = mul2;
    EmitVertex();
    
    gl_Position = trans1;
    frag.texCoord = vertex[0].texCoord;
    frag.normal = vertex[0].normal;
    frag.depth = vec2(trans1.z, trans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = ltrans1;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = ntrans1;
    frag.texCoord = uv2;//uv3;
    frag.normal = vertex[0].normal;
    frag.depth = vec2(ntrans1.z, ntrans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = lntrans1;
    frag.colorMul = mul2;
    EmitVertex();
    
    EndPrimitive();
    
    // 0 - 1 side
    // ****************************
    gl_Position = trans1;
    frag.texCoord = vertex[0].texCoord;
    frag.normal = vertex[0].normal;
    frag.depth  = vec2(trans1.z, trans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = ltrans1;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    
    gl_Position = ntrans1;
    frag.texCoord = uv3;
    frag.normal = vertex[0].normal;
    frag.depth = vec2(ntrans1.z, ntrans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = lntrans1;
    frag.colorMul = mul2;
    EmitVertex();

    gl_Position = trans2;
    frag.texCoord = vertex[1].texCoord;
    frag.normal = vertex[1].normal;
    frag.depth = vec2(trans2.z, trans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = ltrans2;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = ntrans2;
    frag.texCoord = uv5;
    frag.normal = vertex[1].normal;
    frag.depth = vec2(ntrans2.z, ntrans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = lntrans2;
    frag.colorMul = mul2;
    EmitVertex();
    EndPrimitive();
    
    // 1 - 2 side
    // ****************************
    gl_Position = trans2;
    frag.texCoord = vertex[1].texCoord;
    frag.normal = vertex[1].normal;
    frag.depth = vec2(trans2.z, trans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = ltrans2;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = ntrans2;
    frag.texCoord = uv5;
    frag.normal = vertex[1].normal;
    frag.depth = vec2(ntrans2.z, ntrans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = lntrans2;
    frag.colorMul = mul2;
    EmitVertex();
    
    gl_Position = trans3;
    frag.texCoord = vertex[2].texCoord;
    frag.normal = vertex[2].normal;
    frag.depth = vec2(trans3.z, trans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = ltrans3;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = ntrans3;
    frag.texCoord = vertex[0].texCoord;
    frag.normal = vertex[2].normal;
    frag.depth = vec2(ntrans3.z, ntrans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = lntrans3;
    frag.colorMul = mul2;
    EmitVertex();


    EndPrimitive();
}
