#define PI 3.141596
#define GOLDEN_ANGLE 2.39996323
#define NUMBER 200.0
#define ITERATIONS (GOLDEN_ANGLE * NUMBER)

uniform sampler2D Texture;
uniform vec4 TextureRes;
uniform vec4 BokehValues;

vec2 Sample(in float theta, inout float r)
{
    r += 1.0 / r;
	return (r-1.0) * vec2(cos(theta), sin(theta));
}

vec3 Bokeh(vec2 uv, float radius, float amount)
{
	vec3 acc = vec3(0.0);
	vec3 div = vec3(0.0);
    vec2 pixel = vec2(TextureRes.y / TextureRes.x, 1.0) * radius * .002;
    float r = 1.0;
	for (float j = 0.0; j < ITERATIONS; j += GOLDEN_ANGLE)
    {
		
		vec3 col = texture2D(Texture, uv + pixel * Sample(j, r)).xyz;
        col = col * col * 1.4;
		vec3 bokeh = vec3(5.0) + pow(col, vec3(9.0)) * amount;
		acc += col * bokeh;
		div += bokeh;
	}
	return acc / div;
}

void main()
{
	vec2 fragCoord = gl_FragCoord.xy;
	vec2 uv = fragCoord.xy / TextureRes.xy;
      
	float r = BokehValues.x;
	float a = BokehValues.y;
    
	r *= uv.y;

	gl_FragColor= vec4(Bokeh(uv, r, a), 1.0);
}