#version 150

uniform sampler2D Texture;
uniform float CoCScale;
uniform float CoCBias;
uniform float OneOverFilmSize;
uniform vec4 Diffuse;
uniform vec4 Emissive;

in vec4 v_normal;
in vec2 v_texCoord;
in vec2 v_depth;

void main()
{
	vec3 N = normalize(v_normal.xyz);
	vec3 L = normalize(vec3(1.7, 1.3, -0.4));
	float LdotN = max(0.0, dot(L, N));
	
	vec4 baseColor = texture2D(Texture, v_texCoord);
	LdotN += 0.5;
	vec3 color = baseColor.rgb * LdotN * Diffuse.rgb + Emissive.rgb;

	float depth = v_depth.x / v_depth.y;
	depth = (CoCScale * depth) + CoCBias;
	depth *= OneOverFilmSize;

	gl_FragData[0] = vec4(color.rgb, depth);
}
