#version 150

uniform sampler2D Texture;
uniform sampler2D Texture2;
uniform float CoCScale;
uniform float CoCBias;
uniform float OneOverFilmSize;


/*in vData
{
    vec2 texCoord;
	vec4 normal;
	vec3 normalLocal;
	vec4 eye;
	vec2 depth;
	vec4 color;
	vec4 pos;
	float height;
}frag;*/

in fData
{
	vec2 texCoord;
	vec4 normal;
	vec2 depth;
	vec4 eye;
	vec3 colorMul;
	vec4 pos;
}frag;

void main()
{
	vec2 ssPos = vec2(frag.pos.xy) / frag.pos.w;
	ssPos += vec2(1.0);
	ssPos *= 0.5;
	ssPos = vec2(ssPos.x, 1.0 - ssPos.y);
	vec4 color = texture2D(Texture, ssPos);
	float depth = frag.pos.z * 0.1;
	depth = (CoCScale * depth) + CoCBias;
	depth *= OneOverFilmSize;

	color.rgb *= 0.3;
	color.rgb += texture2D(Texture2, frag.texCoord).rgb * (1.0 - length(vec2(0.5, 0.5) - frag.texCoord) * 2.0);

	gl_FragData[0] = vec4(color.rgb, depth);
}
