#version 150

layout(triangles) in;
layout(triangle_strip, max_vertices = 24) out;

in vData
{
    vec2 texCoord;
	vec4 normal;
	vec3 normalLocal;
	vec2 depth;
	vec4 color;
	vec4 eye;
	vec4 pos;
	float height;
}vertex[];

uniform mat4 ProjectionMatrix;
uniform mat4 CameraWorldMatrix;
uniform float Time;
uniform float Extrude;


out fData
{
    vec2 texCoord;
    vec4 normal;
    vec2 depth;
    vec4 eye;
    vec3 colorMul;
    vec4 pos;
}frag;

void main() {
	float str = (vertex[0].height + vertex[1].height + vertex[2].height) / 3.0;
	//str *= sin(Time * 6.0) * 0.5 + 0.5;
	str *= Extrude;
	vec3 mul2 = vec3(1.0 - str) * 0.5;
	
	vec4 trans1 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[0].pos.xyz + vertex[0].normalLocal * str, 1.0);
	vec4 trans2 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[1].pos.xyz + vertex[1].normalLocal * str, 1.0);
	vec4 trans3 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[2].pos.xyz + vertex[2].normalLocal * str, 1.0);
	vec4 ntrans1 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[0].pos.xyz, 1.0);
	vec4 ntrans2 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[1].pos.xyz, 1.0);
	vec4 ntrans3 = ProjectionMatrix * CameraWorldMatrix * vec4(vertex[2].pos.xyz, 1.0);
	
	vec2 uv1 = vec2(vertex[0].texCoord.x, vertex[1].texCoord.y);
	vec2 uv3 = vec2(vertex[0].texCoord.x, vertex[2].texCoord.y);
	vec2 uv2 = vec2(vertex[1].texCoord.x, vertex[0].texCoord.y);
	vec2 uv5 = vec2(vertex[1].texCoord.x, vertex[2].texCoord.y);
	vec2 uv4 = vec2(vertex[2].texCoord.x, vertex[0].texCoord.y);
	vec2 uv6 = vec2(vertex[2].texCoord.x, vertex[1].texCoord.y);
	
    gl_Position = trans1;
    frag.texCoord = vertex[0].texCoord;
    frag.normal = vertex[0].normal;
    frag.depth = vec2(trans1.z, trans1.w);
    frag.eye = vertex[0].eye;
    frag.pos = trans1;
    frag.colorMul = vec3(1.0);
    EmitVertex();

    gl_Position = trans2;
    frag.texCoord = vertex[1].texCoord;
    frag.normal = vertex[1].normal;
    frag.depth = vec2(trans2.z, trans2.w);
    frag.eye = vertex[1].eye;
    frag.pos = trans2;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    gl_Position = trans3;
    frag.texCoord = vertex[2].texCoord;
    frag.normal = vertex[2].normal;
    frag.depth = vec2(trans3.z, trans3.w);
    frag.eye = vertex[2].eye;
    frag.pos = trans3;
    frag.colorMul = vec3(1.0);
    EmitVertex();
    
    EndPrimitive();
}
