
uniform sampler2D vertextex;
uniform float psize;
uniform float time;
uniform float frq;
uniform float power;
uniform vec3 lpos;
uniform float fadein;

varying vec4 color;
varying float dist;
varying float life;
varying float brz;
#define pi2 6.2831853

void main() {
  vec2 tc = gl_MultiTexCoord1.xy;
  vec4 paske = texture2DLod(vertextex, tc, 0.0);
  vec4 pos = vec4(paske.rgb, 1.0);
   
#ifdef XPLOSIVE

  vec4 xplodir=vec4(1.0);
  float len = length(pos);
  float ddd = 1.0/(len*len);
  xplodir.x = pos.x + sin(pos.z*2324.42)*0.5;
  xplodir.y = pos.y + sin(pos.x*3128.76)*0.5 - 1.0;
  xplodir.z = pos.z + sin(pos.y*6712.63)*0.5 + 1.0;
  xplodir = normalize(xplodir) * ddd;
  pos += xplodir * (1.0 - fadein*fadein) * 2.0;
  pos.y -= (1.0-fadein)*(1.0-fadein)*(1.0-fadein) * 4.0;
  float pier = sqrt(fadein);

#else

  float fade = clamp(0.5+(pos.x+0.5)*3.0 - fadein*4.0, 0.0, 1.0);
  fade *= fade;
  
  vec4 startpos = vec4(1.0);
  startpos.x = sin(time*9.127+fade*15.21)*sin(pos.y*5.632+time*7.281)*0.125;
  startpos.y = sin(time*11.71+fade*21.21)*sin(pos.z*8.421-time*5.612)*0.125-1.0;
  
  pos = mix(pos, startpos, fade);
  pos.x += sin(pos.y*4.632+time*7.281)*fade;
  pos.y += sin(pos.z*5.632+time*8.281)*fade;
  if (fade==0.0) pos.y = 1000.0;
  float pier = 1.0-fade;
  
#endif
 
 
  float dd = -(gl_ModelViewMatrix*pos).z;
  pier *= 0.75;
  pier *= pier*pier*pier*pier;
  color = (gl_Color + vec4(0.6, 0.0, 0.3, 1.0)) * pier * vec4(2.0, 1.8, 1.0, 1.0);
  dist = dd;
  gl_PointSize = clamp((1.0 + 128.0/dd) * psize, 1.0, 16.0);
  gl_TexCoord[0] = gl_MultiTexCoord0;
  gl_Position = gl_ModelViewProjectionMatrix * pos;
}
