var kvg = {}, LightNS = LightNS = {};
LightNS.inject = function(a, c) {
  a.createNS = function(b) {
    b = b.split(".");
    var e = a;
    b[0] === c && (b = b.slice(1));
    for (var d = 0;d < b.length;d++) {
      var g = b[d];
      "undefined" === typeof e[g] && (e[g] = {});
      e = e[g];
    }
    return e;
  };
};
kvg.core = {};
kvg.core.assets = {};
(function() {
  var a = kvg.core.assets, c = {};
  a.register = function(a, e, d, g) {
    console.log("register " + a);
    if (g && (d = base64DecToArr(d, 1), d = (new Zlib.Inflate(d)).decompress(), "json" === e)) {
      g = "";
      for (var h = 0;h < d.length;h++) {
        g += String.fromCharCode(d[h]);
      }
      d = g;
    }
    "png" === e || "jpg" === e ? (g = new Image, g.src = "data:image/" + ("jpg" === e ? "jpeg" : e) + ";base64," + d, c[a] = g) : "mp3" === e || "ogg" === e ? c[a] = d : "json" === e ? c[a] = JSON.parse(d) : "object" === e && (c[a] = d);
  };
  a.preload = function() {
  };
  a.get = function(a) {
    c[a] || console.log("Asset " + a + " not found");
    return c[a];
  };
})();
kvg.util = {};
kvg.util.geometryHelper = {};
(function() {
  kvg.util.geometryHelper.assignUVs = function(a) {
    a.faceVertexUvs[0] = [];
    a.faces.forEach(function(c) {
      var b = ["x", "y", "z"].sort(function(a, b) {
        return Math.abs(c.normal[a]) > Math.abs(c.normal[b]);
      }), e = a.vertices[c.a], d = a.vertices[c.b], g = a.vertices[c.c];
      a.faceVertexUvs[0].push([new THREE.Vector2(e[b[0]], e[b[1]]), new THREE.Vector2(d[b[0]], d[b[1]]), new THREE.Vector2(g[b[0]], g[b[1]])]);
    });
    a.uvsNeedUpdate = !0;
  };
})();
kvg.graphics = {};
kvg.graphics.post = {};
kvg.graphics.post.RGBShift = {};
(function() {
  var a = kvg.graphics.post;
  a.RGBShift = function(a, e, d) {
    this.uniforms = c.uniforms;
    this.uniforms.rshift.value = a;
    this.uniforms.gshift.value = e;
    this.uniforms.bshift.value = d;
    this.material = new THREE.ShaderMaterial({uniforms:this.uniforms, vertexShader:c.vertex, fragmentShader:c.fragment});
    this.enabled = !0;
    this.renderToScreen = !1;
    this.needsSwap = !0;
  };
  a.RGBShift.prototype.render = function(a, c, d, g) {
    this.uniforms.tDiffuse.value = d;
    THREE.EffectComposer.quad.material = this.material;
    this.renderToScreen ? a.render(THREE.EffectComposer.scene, THREE.EffectComposer.camera) : a.render(THREE.EffectComposer.scene, THREE.EffectComposer.camera, c, !1);
  };
  var c = {attributes:{}, uniforms:{gshift:{type:"f", value:0}, rshift:{type:"f", value:0}, bshift:{type:"f", value:0}, zoom:{type:"f", value:0}, resolution:{type:"v2", value:new THREE.Vector2(1280, 720)}, time:{type:"f", value:164}, tear:{type:"f", value:0}, rndStrength:{type:"f", value:0}, color:{type:"v3", value:new THREE.Vector3(0, 0, 0)}, tDiffuse:{type:"t"}, pixelate:{type:"v2", value:new THREE.Vector2(1280, 720)}, pixelsize:{type:"v2", value:new THREE.Vector2(0, 0)}, pixelcenter:{type:"v2", 
  value:new THREE.Vector2(.5, .5)}}, vertex:"varying vec2 vUv;\nvoid main() {\nvec3 p = position;\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );\n}", fragment:"varying vec2 vUv;\nuniform vec2 resolution;\nuniform vec2 pixelate;\nuniform vec2 pixelsize;\nuniform vec2 pixelcenter;\nuniform float time;\nuniform float tear;\nuniform float rshift;\nuniform float gshift;\nuniform float bshift;\nuniform sampler2D tDiffuse;\nuniform vec3 color;\nuniform float rndStrength;\nfloat rand(vec2 co){\nreturn fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n}\nvoid main() {\nvec2 uv = gl_FragCoord.xy;\nfloat rnd =rndStrength* rand(vec2(time*0.5*uv.x, time*uv.y*1.2));\nvec2 uv2 = vUv;\nuv2.x = abs(uv2.y-pixelcenter.x) > pixelsize.x ? uv2.x : floor(uv2.x*pixelate.x)/pixelate.x;\nuv2.y = abs(uv2.x-pixelcenter.y) > pixelsize.y ? uv2.y : floor(uv2.y*pixelate.y)/pixelate.y;\nuv2.x += tear*rnd*sin(time);\nvec4 c = texture2D(tDiffuse,uv2);\nvec4 ro = texture2D(tDiffuse,vec2(uv2.x-rshift, uv2.y));\nvec4 go = texture2D(tDiffuse,vec2(uv2.x-gshift, uv2.y));\nvec4 bo = texture2D(tDiffuse,vec2(uv2.x-bshift, uv2.y));\nc = vec4(ro.r, go.g, bo.b, c.w);\ngl_FragColor = c *1.0 + 0.12* vec4(rnd*0.25+color.r,rnd*0.25+color.g,rnd*0.250+color.b,0);\n}"};
})();
kvg.demo = {};
kvg.demo.CameraController = {};
(function() {
  var a = function() {
    this.modes = [a.STATIC, a.LINEAR, a.BEZIER, a.FOLLOW];
  };
  a.STATIC = "static";
  a.LINEAR = "linear";
  a.BEZIER = "bezier";
  a.FOLLOW = "follow";
  var c = a.prototype;
  kvg.demo.CameraController = a;
  a.stopAllControl = function() {
    a.HALT = !0;
  };
  c.attachCamera = function(a) {
    this.camera = a;
  };
  c.setMode = function(b) {
    -1 == this.modes.indexOf(b) && (b = a.STATIC);
    this.mode = b;
  };
  c.initialize = function(b, c, d) {
    this.setMode(d);
    this.points = b;
    this.looks = c;
    this.mode == a.STATIC ? this.initStatic() : this.mode == a.LINEAR ? this.initLinear() : this.mode == a.FOLLOW ? this.initFollow() : this.initBezier();
  };
  c.initStatic = function() {
  };
  c.initFollow = function() {
    this.follow || (this.mode = STATIC);
    this.followOffset || (this.followOffset = new THREE.Vector3(0, 0, 0));
    this.followLookOffset || (this.followLookOffset = new THREE.Vector3(0, 0, 0));
  };
  c.initLinear = function() {
  };
  c.initBezier = function() {
    this.path = new THREE.SplineCurve3(this.points);
    this.lookPath = new THREE.SplineCurve3(this.looks);
  };
  c.update = function(b) {
    if (!a.HALT) {
      if (this.mode == a.STATIC) {
        this.camera.position.x = this.points[b].x, this.camera.position.y = this.points[b].y, this.camera.position.z = this.points[b].z, this.camera.lookAt(this.points[b].look);
      } else {
        if (this.mode != a.LINEAR) {
          if (this.mode == a.FOLLOW) {
            this.camera.position.x = this.follow.position.x + this.followOffset.x, this.camera.position.y = this.follow.position.y + this.followOffset.y, this.camera.position.z = this.follow.position.z + this.followOffset.z, this.camera.lookAt(this.follow.position + this.followLookOffset);
          } else {
            if (this.mode == a.BEZIER) {
              0 > b ? b = 0 : 1 < b && (b = 1);
              var c = this.path.getPoint(b);
              this.camera.position.x = c.x;
              this.camera.position.y = c.y;
              this.camera.position.z = c.z;
              c = this.lookPath.getPoint(b);
              this.camera.lookAt(c);
            }
          }
        }
      }
    }
  };
})();
(function() {
})();
kvg.core.graphics = {};
(function() {
  var a = kvg.core.graphics;
  a.container = null;
  a.camera = null;
  a.scene = null;
  a.renderer = null;
  a.stopped = !1;
  a.onRender = new signals.Signal;
  a.initWebGL = function(b) {
    console.log("initializing WegGL context");
    a.clearColor = b.clearColor ? b.clearColor : 0;
    a.container = $("#demo");
    a.renderer = new THREE.WebGLRenderer({preserveDrawingBuffer:b.DEBUG});
    a.renderer.setClearColor(b.clearColor);
    console.log("Setting viewport size", b.width, b.height);
    a.renderer.setSize(b.width, b.height);
    a.container.append(a.renderer.domElement);
    a.renderer.domElement.width = b.width;
    a.renderer.domElement.height = b.height;
    a.viewport = {width:b.width, height:b.height};
    a.layerEffect = {};
    a.frameCount = 0;
    a.renderer.setClearColor(a.clearColor, 1);
    a.renderer.autoClear = !0;
    console.log("Init done");
  };
  a.store = function() {
    a.renderer.storeClear = a.renderer.autoClear;
    a.renderer.storeClearColor = a.renderer.getClearColor();
  };
  a.restore = function() {
    a.renderer.autoClear = a.renderer.storeClear;
    a.renderer.setClearColor(a.renderer.storeClearColor);
  };
  a.getRenderTarget = function(b, c, d) {
    return new THREE.WebGLRenderTarget(a.viewport.width, a.viewport.height, {minFilter:b ? b : THREE.LinearFilter, magFilter:c ? c : THREE.NearestFilter, format:d ? d : THREE.RGBFormat});
  };
  a.start = function() {
    a.stopped = !1;
    c();
    $("#demo").animate({opacity:1}, 400);
  };
  a.stop = function() {
    a.stopped = !0;
    $("#demo").animate({opacity:0}, 400);
  };
  var c = function() {
    a.onRender.dispatch();
    a.stopped || requestAnimationFrame(c);
  };
})();
kvg.loader = {};
(function() {
})();
kvg.core.Part = {};
(function() {
  var a = (kvg.core.Part = function() {
  }).prototype;
  a.addTrigger = function(a, b) {
    this.trigger.has(a) ? this.trigger.get(a).push(b) : this.trigger.set(a, [b]);
  };
  a.init = function(a) {
    this.clearColor = "#000";
    this.trigger = new Map;
    this.running = !1;
    this.autoClear = a;
    this.layerEffect = {};
    this.renderTo = kvg.core.graphics.getRenderTarget();
    this.addTrigger(new kvg.core.TimeSig(-1, 2, -1, kvg.core.TimeSig.PATTERN), this.post);
  };
  a.post = function(a) {
    28 > a.bar && (console.log("Post"), this.pos = this.pos || 0, this.layerEffect.standard && (this.lastPost = a.toMilliseconds(), this.layerEffect.standard.uniforms.offset.value = 8 > a.bar ? 0 : .2, this.layerEffect.standard.uniforms.pos.value = this.pos += .3));
  };
  a.postInit = function() {
  };
  a.initStandardScene = function() {
    this.scene = new THREE.Scene;
    this.camera = new THREE.PerspectiveCamera(70, kvg.core.graphics.viewport.width / kvg.core.graphics.viewport.height, 1, 1E3);
    this.camera.position.y = 0;
    this.camera.position.x = 0;
    this.camera.position.z = 500;
    this.camera.part = this;
    this.camera.lookAt(new THREE.Vector3(0, 0, 0));
    this.scene.autoUpdate = !0;
    this.scene.add(this.camera);
    this.renderPass = new THREE.RenderPass(this.scene, this.camera, null, 0, 0);
    kvg.debug.ManualControl.attachCamera(this.camera);
  };
  a.initStandardComposer = function(a, b, e) {
    var d = kvg.core.graphics;
    this.composerRT = this.renderTo || d.getRenderTarget();
    var g = new THREE.RenderPass(this.scene, this.camera, null, 0, 0);
    this.composer = new THREE.EffectComposer(d.renderer, this.composerRT);
    this.composer.renderTarget1.format = THREE.RGBAFormat;
    this.composer.renderTarget2.format = THREE.RGBAFormat;
    this.composer.addPass(g);
    a && (this.layerEffect.bloom = new THREE.BloomPass(1.32, 20, 18, 512), this.composer.addPass(this.layerEffect.bloom));
    b && (this.layerEffect.rgbShift = new kvg.graphics.post.RGBShift(.002, -.002, 0), this.composer.addPass(this.layerEffect.rgbShift));
    e && (this.layerEffect.standard = new kvg.graphics.post.StandardShader, this.composer.addPass(this.layerEffect.standard));
    this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
    this.copyPass.renderToScreen = this.renderToScreen;
    this.composer.addPass(this.copyPass);
  };
  a.setRenderToScreen = function(a) {
    this._debug_renderToScreen && console.log("debug render");
    this.copyPass && (this.copyPass.renderToScreen = a || this._debug_renderToScreen);
    this.renderToScreen = a || this._debug_renderToScreen;
  };
  a.start = function() {
    console.log("Started");
    this.running = !0;
  };
  a.stop = function() {
    console.log("Stopped");
    this.running = !1;
  };
  a.update = function(a, b, e) {
    this.layerEffect.standard && (27 > a.bar && (this.layerEffect.standard.uniforms.offset.value = .1 * Math.max(0, (this.lastPost + 200 - a.toMilliseconds()) / 200)), 0 > this.layerEffect.standard.uniforms.offset || 30 < a.bar) && (this.layerEffect.standard.uniforms.offset = 0);
  };
  a.render = function() {
    var a = kvg.core.graphics.renderer;
    a.autoClear = this.autoClear;
    a.setClearColor(this.clearColor, 1);
    this.composer ? this.composer.render() : kvg.core.graphics.renderer.render(this.scene, this.camera, this.renderTo);
  };
})();
kvg.core.TimeSig = {};
(function() {
  var a = kvg.core.TimeSig = function(a, c, d, g) {
    this.bar = a;
    this.beat = c;
    this.tick = d;
    this.pattern = g || "absolute";
  };
  a.ABSOLUTE = "absolute";
  a.RELATIVE = "relative";
  a.PATTERN = "pattern";
  a.BEATSPATTERN = "beats";
  a.TICKSPATTERN = "bars";
  var c = a.prototype;
  c.matchesPattern = function(b, c) {
    if (this.pattern === a.ABSOLUTE) {
      return b.equals(this);
    }
    if (this.pattern === a.RELATIVE) {
      return b.bar === c.bar + this.bar && b.beat === c.beat + this.beat && b.tick === c.tick + this.tick;
    }
    if (this.pattern === a.PATTERN) {
      return(-1 === this.bar || 0 === b.bar % this.bar) && (-1 === this.beat || b.beat % kvg.Config.BEATS_PER_BAR === this.beat) && (-1 === this.tick || b.tick % kvg.Config.TICKS_PER_BEAT === this.tick);
    }
    if (this.pattern == a.BEATSPATTERN) {
      return b.beat % kvg.Config.BEATS_PER_BAR === this.beat;
    }
    if (this.pattern == a.TICKSPATTERN) {
      return b.tick % kvg.Config.TICKS_PER_BEAT === this.tick;
    }
  };
  c.addBars = function(a) {
    this.bar += a;
  };
  c.addBeats = function(a) {
    this.beat += a;
    this.bar += Math.floor(this.beat / kvg.Config.BEATS_PER_BAR);
    this.beat %= kvg.Config.BEATS_PER_BAR;
  };
  c.addTicks = function(a) {
    for (this.tick += a;this.tick >= kvg.Config.TICKS_PER_BEAT;) {
      this.tick -= kvg.Config.TICKS_PER_BEAT, this.beat++;
    }
    for (;this.beat >= kvg.Config.BEATS_PER_BAR;) {
      this.beat -= kvg.Config.BEATS_PER_BAR, this.bar++;
    }
  };
  c.add = function(a) {
    this.addBars(a.bar);
    this.addBeats(a.beat);
    this.addTicks(a.tick);
  };
  c.fromTimeSig = function(a) {
    this.bar = a.bar;
    this.beat = a.beat;
    this.tick = a.tick;
  };
  c.fromTime = function(a) {
    a *= kvg.Config.BEATS_PER_MINUTE;
    this.bar = Math.floor(a / kvg.Config.BEATS_PER_BAR);
    this.beat = Math.floor(a % kvg.Config.BEATS_PER_BAR);
    this.tick = Math.floor((a - Math.floor(a)) * kvg.Config.TICKS_PER_BEAT);
    return this;
  };
  c.isInside = function(a, c) {
    return this.isSmallerThan(c) && this.isLargerThan(a);
  };
  c.isSmallerThan = function(a) {
    return this.bar * kvg.Config.BEATS_PER_BAR * kvg.Config.TICKS_PER_BEAT + this.beat * kvg.Config.TICKS_PER_BEAT + this.tick < a.bar * kvg.Config.BEATS_PER_BAR * kvg.Config.TICKS_PER_BEAT + a.beat * kvg.Config.TICKS_PER_BEAT + a.tick;
  };
  c.isLargerThan = function(a) {
    return this.bar * kvg.Config.BEATS_PER_BAR * kvg.Config.TICKS_PER_BEAT + this.beat * kvg.Config.TICKS_PER_BEAT + this.tick >= a.bar * kvg.Config.BEATS_PER_BAR * kvg.Config.TICKS_PER_BEAT + a.beat * kvg.Config.TICKS_PER_BEAT + a.tick;
  };
  c.toMilliseconds = function() {
    return 6E4 * (this.bar * kvg.Config.BEATS_PER_BAR / kvg.Config.BEATS_PER_MINUTE + this.beat / kvg.Config.BEATS_PER_MINUTE + this.tick / kvg.Config.TICKS_PER_BEAT / kvg.Config.BEATS_PER_MINUTE);
  };
  c.equals = function(a) {
    return this.bar * kvg.Config.BEATS_PER_BAR * kvg.Config.TICKS_PER_BEAT + this.beat * kvg.Config.TICKS_PER_BEAT + this.tick === a.bar * kvg.Config.BEATS_PER_BAR * kvg.Config.TICKS_PER_BEAT + a.beat * kvg.Config.TICKS_PER_BEAT + a.tick;
  };
  c.clone = function() {
    return new a(this.bar, this.beat, this.tick);
  };
  c.toString = function() {
    return this.bar + ":" + this.beat + ":" + this.tick;
  };
})();
kvg.sound = {};
(function() {
  var a = kvg.sound;
  a.onSoundLoaded = new signals.Signal;
  a.onSoundComplete = new signals.Signal;
  a.onSoundReady = new signals.Signal;
  var c = new kvg.core.TimeSig(0, 0, 0);
  a.init = function() {
    console.log("sound init");
    a.FFT = {db:g, frequency:h, waveform:k};
    a.volume = 1;
    if (createjs.Sound.initializeDefaultPlugins()) {
      if (createjs.WebAudioPlugin.isSupported()) {
        e();
      } else {
        a: {
          if (console.log("Player not compatible with web audio plugin. Trying to load scripted sounds"), okToInit = !1, a.musicAsset = kvg.core.assets.get("bg.ogg"), a.musicAsset) {
            try {
              a.musicByteArray = Base64Binary.decodeArrayBuffer(a.musicAsset), a.loaded = !0, console.log("Sound loaded ");
            } catch (b) {
              e();
              break a;
            }
            a.onSoundLoaded.dispatch();
          } else {
            e();
          }
        }
      }
    } else {
      alert("Sound could not be initialized.");
    }
  };
  a.setVolume = function(b) {
    console.log("set volume to: " + b);
    a.volume = b;
    null != a.instance && (a.instance.volume = b);
  };
  a.getPosition = function() {
    a.instance ? c.fromTime(a.instance.position / 1E3 / 60 - kvg.Config.MUSIC_BEGIN / 1E3 / 60) : a.context && c.fromTime((a.context.currentTime - a.startTime) / 60 - kvg.Config.MUSIC_BEGIN / 1E3 / 60);
    return c;
  };
  a.getFFT = function() {
    var b = 0;
    a.instance && (b = a.instance.position);
    a.context && (b = a.context.currentTime);
    if (a.lastFFT != b) {
      if (a.lastFFT = b, (a.instance || a.context) && kvg.Config.song.enableFFT && d) {
        d.getFloatFrequencyData(g), d.getByteFrequencyData(h), d.getByteTimeDomainData(k);
      } else {
        for (var b = a.precalcFFT[Math.floor(b / 33)], c = b.d.length, e = g.length / c, f = 0;f < c;f++) {
          g[f * e] = b.d[f];
          h[f * e] = b.f[f];
          k[f * e] = b.w[f];
          for (var m = f < c - 1 ? f + 1 : f, l = 1;l < e;l++) {
            g[f * e + l] = b.d[f] + (b.d[m] - b.d[f]) * l / e, h[f * e + l] = b.f[f] + (b.f[m] - b.f[f]) * l / e, k[f * e + l] = b.w[f] + (b.w[m] - b.w[f]) * l / e;
          }
        }
      }
    }
    return a.FFT;
  };
  a.start = function() {
    a.musicAsset ? (console.log("Load asset"), a.context = new AudioContext, a.context.decodeAudioData(a.musicByteArray, function(d) {
      a.dynamicsCompressorNode = a.context.createDynamicsCompressor();
      a.dynamicsCompressorNode.connect(a.context.destination);
      a.gainNode = a.context.createGain();
      a.gainNode.connect(a.dynamicsCompressorNode);
      a.gainNode.value = this.volume;
      var c = a.context.createBufferSource();
      c.buffer = d;
      c.connect(a.context.destination);
      c.start();
      a.startTime = a.context.currentTime;
      c.onended = b;
      kvg.Config.song.enableFFT && m();
      a.onSoundReady.dispatch();
    }, function(b) {
      console.log("err(decodeAudioData): " + b);
      a.musicAsset = null;
      e();
    })) : (console.log("File music"), console.log("volume: " + a.volume), a.context = createjs.Sound.activePlugin.context, a.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode, a.instance = createjs.Sound.play("music"), a.instance.on("complete", b), a.instance.volume = a.volume, kvg.Config.song.enableFFT && m(), console.log("dispatch onSoundReady"), a.onSoundReady.dispatch());
  };
  var b = function() {
    a.onSoundComplete.dispatch();
  }, e = function() {
    var a = [{id:"music", src:kvg.Config.song.src}];
    createjs.Sound.alternateExtensions = ["mp3"];
    createjs.Sound.addEventListener("fileload", f);
    createjs.Sound.registerSounds(a);
  }, d, g, h, k, m = function() {
    var b = a.context, c = 1024;
    b && b.createAnalyser ? (d = b.createAnalyser(), d.fftSize = c, d.smoothingTimeConstant = .85, d.connect(b.destination), b = a.dynamicsCompressorNode, b.disconnect(), b.connect(d), g = new Float32Array(d.frequencyBinCount), h = new Uint8Array(d.frequencyBinCount), k = new Uint8Array(d.frequencyBinCount), console.log("Live FFT initialized")) : (c = 1024, a.precalcFFT = kvg.core.assets.get("fft.json"), g = new Float32Array(c >> 2), h = new Uint8Array(c >> 2), k = new Uint8Array(c >> 2), console.log("Precalculated FFT initialized. Current configuration does not support real time calculation. Run on browser with web audio with local file reading allowed or from a server to enable live FFT."));
    a.FFT.db = g;
    a.FFT.frequency = h;
    a.FFT.waveform = k;
  }, f = function() {
    a.loaded = !0;
    console.log("Sound loaded ");
    a.onSoundLoaded.dispatch();
  };
})();
kvg.proxy = {};
(function() {
  kvg.proxy = function() {
  };
})();
kvg.util.random = {};
(function() {
  var a = kvg.util.random;
  a.init = function(c) {
    a.seed = c;
    a.inited = !0;
    Math.random = a.nextFloat;
  };
  a.next = function() {
    a.inited || a.init(1237);
    a.seed = 16807 * a.seed % 4294967295;
    return a.seed;
  };
  a.getRange = function(c, b) {
    var e = a.nextFloat();
    return Math.floor(e * (b - c));
  };
  a.nextFloat = function() {
    a.inited || a.init(1237);
    return a.next() / 4294967295;
  };
})();
kvg.graphics.post.StandardShader = {};
(function() {
  var a = kvg.graphics.post;
  a.StandardShader = function(a) {
    this.uniforms = c.uniforms;
    this.uniforms.gamma.value = a || 2.2;
    this.material = new THREE.ShaderMaterial({uniforms:this.uniforms, vertexShader:c.vertex, fragmentShader:c.fragment});
    this.enabled = !0;
    this.renderToScreen = !1;
    this.needsSwap = !0;
  };
  a.StandardShader.prototype.render = function(a, c, d, g) {
    this.uniforms.tDiffuse.value = d;
    THREE.EffectComposer.quad.material = this.material;
    this.renderToScreen ? a.render(THREE.EffectComposer.scene, THREE.EffectComposer.camera) : a.render(THREE.EffectComposer.scene, THREE.EffectComposer.camera, c, !1);
  };
  var c = {attributes:{}, uniforms:{gamma:{type:"f", value:0}, tDiffuse:{type:"t"}, offset:{type:"f", value:0}, pos:{type:"f", value:0}}, vertex:"varying vec2 vUv;\nvoid main() {\nvec3 p = position;\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );\n}", fragment:"float rand(vec2 co){\nreturn fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n}\nuniform float gamma;\nuniform sampler2D tDiffuse;\nvarying vec2 vUv;\nuniform float offset;\nuniform float pos;\nvoid main() {\nvec2 uv = vUv;\nuv.x*=1. + offset*step(mod(uv.y+pos, 0.03),0.005)*rand(uv);\nvec4 c = texture2D(tDiffuse,uv);\nc = pow(c, vec4(1.0/gamma));\ngl_FragColor = c;\n}"};
})();
kvg.graphics.demo = {};
(function() {
  var a = kvg.graphics.demo;
  a.Effect = function() {
    this.onInitialize = new signals.Signal;
    this.onUpdate = new signals.Signal;
    this.onRender = new signals.Signal;
  };
  a.Effect.setRenderPass = function(a) {
    this.renderPass = a;
  };
  a.Effect.prototype.initialize = function(a) {
    this.onInitialize.dispatch();
  };
  a.Effect.prototype.update = function(a, b, e) {
    this.time = a;
    this.partial = b;
    this.timesig = e;
    this.onUpdate.dispatch(elapsedtime, b, e);
  };
})();
kvg.debug = {};
kvg.debug.ManualControl = {};
(function() {
  var a = {};
  kvg.debug.ManualControl = a;
  var c = !1;
  a.init = function() {
    c || (c = !0, document.addEventListener("keydown", kvg.debug.ManualControl.handleKeyDown, !1), a.ctrlDown = !0, a.cameras = [], a.storedPoints = {});
  };
  a.attachCamera = function(b) {
    a.cameras && a.cameras.push(b);
  };
  a.handleKeyDown = function(b) {
    console.log("keydown");
    "90" == b.keyCode && (a.ctrlDown = !1, document.addEventListener("keyup", function(b) {
      "90" == b.keyCode && (a.ctrlDown = !0);
    }));
    for (var c = 0;c < a.cameras.length;c++) {
      var d = a.cameras[c];
      if (null != d && null != d.part && d.part.renderToScreen) {
        var g = new THREE.Vector3(0, 0, -1 * (a.ctrlDown ? 10 : 1)), h = new THREE.Vector3(-1 * (a.ctrlDown ? 10 : 1), 0, 0), k = new THREE.Vector3(1 * (a.ctrlDown ? 10 : 1), 0, 0), m = new THREE.Vector3(0, 1 * (a.ctrlDown ? 10 : 1), 0), f = new THREE.Vector3(0, -1 * (a.ctrlDown ? 10 : 1), 0), p = new THREE.Vector3(0, 0, -1 * (a.ctrlDown ? 10 : 1)), q = new THREE.Vector3(0, 0, 1 * (a.ctrlDown ? 10 : 1)), r = new THREE.Vector3(0, 0, .1 * (a.ctrlDown ? 10 : 1)), t = new THREE.Vector3(.1 * (a.ctrlDown ? 
        10 : 1), 0, 0), u = new THREE.Vector3(0, .1 * (a.ctrlDown ? 10 : 1), 0), l = new THREE.Vector3(0, -.1 * (a.ctrlDown ? 10 : 1), 0);
        g.applyQuaternion(d.quaternion);
        h.applyQuaternion(d.quaternion);
        k.applyQuaternion(d.quaternion);
        m.applyQuaternion(d.quaternion);
        f.applyQuaternion(d.quaternion);
        p.applyQuaternion(d.quaternion);
        q.applyQuaternion(d.quaternion);
        r.applyQuaternion(d.quaternion);
        t.applyQuaternion(d.quaternion);
        u.applyQuaternion(d.quaternion);
        l.applyQuaternion(d.quaternion);
        "37" == b.keyCode && d.position.add(h);
        "39" == b.keyCode && d.position.add(k);
        "38" == b.keyCode && d.position.add(m);
        "40" == b.keyCode && d.position.add(f);
        "79" == b.keyCode && d.position.add(p);
        "76" == b.keyCode && d.position.add(q);
        "65" == b.keyCode && d.rotateOnAxis(new THREE.Vector3(0, 1, 0), .01 * (a.ctrlDown ? 10 : 1));
        "68" == b.keyCode && d.rotateOnAxis(new THREE.Vector3(0, 1, 0), -.01 * (a.ctrlDown ? 10 : 1));
        "87" == b.keyCode && d.rotateOnAxis(new THREE.Vector3(1, 0, 0), .01 * (a.ctrlDown ? 10 : 1));
        "83" == b.keyCode && d.rotateOnAxis(new THREE.Vector3(1, 0, 0), -.01 * (a.ctrlDown ? 10 : 1));
        "81" == b.keyCode && d.rotateOnAxis(new THREE.Vector3(0, 0, 1), .01 * (a.ctrlDown ? 10 : 1));
        "69" == b.keyCode && d.rotateOnAxis(new THREE.Vector3(0, 0, 1), -.01 * (a.ctrlDown ? 10 : 1));
        "80" == b.keyCode && (kvg.demo.CameraController.stopAllControl(), console.log("--- " + d.name + " ---"), console.log("Pos: x: " + d.position.x + " y: " + d.position.y + " z: " + d.position.z), console.log("Dir: " + g.x + ", " + g.y + ", " + g.z), console.log("Look at: "), h = d.position.clone().add(g), console.log(h.x + ", " + h.y + ", " + h.z), console.log("Camera rotations: x " + d.rotation.x + " y " + d.rotation.y + " z " + d.rotation.z + " Array ( " + d.rotation.x + "," + d.rotation.y + 
        "," + d.rotation.z + " )"));
        "84" == b.keyCode && (console.log("point stored"), null == a.storedPoints[d.name] && (a.storedPoints[d.name] = {pos:[], rot:[], look:[]}), h = d.position.clone().add(g), a.storedPoints[d.name].pos.push("new THREE.Vector3(" + Math.round(d.position.x) + "," + Math.round(d.position.y) + "," + Math.round(d.position.z) + ")"), a.storedPoints[d.name].rot.push("new THREE.Vector3(" + Math.round(d.rotation.x) + "," + Math.round(d.rotation.y) + "," + Math.round(d.rotation.z) + ")\n"), a.storedPoints[d.name].look.push("new THREE.Vector3(" + 
        Math.round(h.x) + "," + Math.round(h.y) + "," + Math.round(h.z) + ")"));
        if ("82" == b.keyCode) {
          console.log("------------------------");
          for (point in a.storedPoints) {
            console.log("--- " + point + " ---"), console.log("[\r\n" + a.storedPoints[point].pos.join(",\r\n") + "],[\r\n" + a.storedPoints[point].look.join(",\r\n") + "]");
          }
          storedPoints = {};
        }
      }
    }
  };
})();
kvg.core.demo = {};
(function() {
  var a = kvg.core.demo;
  a.scene = null;
  a.camera = null;
  a.initialize = function(b) {
    console.log("Demo initialized");
    kvg.Config.DEBUG && kvg.debug.ManualControl.init();
    a.compareTS = (new kvg.core.TimeSig).fromTime(0);
    a.previousTS = (new kvg.core.TimeSig).fromTime(0);
    if (null === kvg.Config) {
      throw Error("Config not found");
    }
    a.parts = {};
    for (part in kvg.Config.PARTS) {
      if ("string" === typeof kvg.Config.PARTS[part]) {
        b = kvg.Config.PARTS[part].split(".");
        for (var h = window, k = 0;k < b.length;k++) {
          h = h[b[k]];
        }
        a.parts[part] = new h;
      } else {
        a.parts[part] = kvg.Config.PARTS[part]();
      }
    }
    for (part in a.parts) {
      a.parts[part].id = part, a.parts[part].init();
    }
    for (part in a.parts) {
      a.parts[part].postInit();
    }
    for (part in a.parts) {
      a.parts[part].render();
    }
    b = null;
    for (timeline in kvg.Config.TIMELINE) {
      timeline = kvg.Config.TIMELINE[timeline], h = a.parts[timeline.part], b && (b.nextPart = h), h.previousPart = b, b = h;
    }
    kvg.sound.onSoundReady.add(c);
    kvg.sound.onSoundComplete.add(d);
    kvg.core.graphics.onRender.add(e);
  };
  a.start = function() {
    a.clock = new THREE.Clock;
    console.log("GO");
    $("#demo canvas").css("display", "none");
    kvg.core.graphics.start();
    a.interval = setInterval(b, 33);
    setTimeout(kvg.sound.start, 1E3);
  };
  var c = function() {
    console.log("SOUND ready");
  };
  a.end = function() {
    kvg.core.graphics.stop();
  };
  var b = function() {
    var b = kvg.sound.getPosition(), c = a.clock.getDelta();
    createjs.Tween.tick(c, !1);
    !this.visible && 0 < b.toMilliseconds() && (this.visible = !0, $("#demo canvas").css("display", ""));
    for (var d = 0;d < kvg.Config.TIMELINE.length;d++) {
      var e = kvg.Config.TIMELINE[d];
      if (b.isInside(e.start, e.end)) {
        var f = a.parts[e.part];
        f.setRenderToScreen(e.rts);
        f.renderContinuous || (f.begin = e.start, f.end = e.end);
        if (!f.running) {
          if (f.renderContinuous) {
            for (f.begin = e.start, f.end = e.end, e = 1;e + d < kvg.Config.TIMELINE.length && kvg.Config.TIMELINE[d + e].part == f.id;) {
              f.end = kvg.Config.TIMELINE[d + e++].end;
            }
          }
          f.start();
        }
        f._wasInside = !0;
      }
    }
    for (name in a.parts) {
      f = a.parts[name], !f._wasInside && f.running ? (console.log("Stop " + name), f.stop()) : f.running && (f._wasInside = !1, d = f.end.toMilliseconds() - f.begin.toMilliseconds(), e = 0, 0 < d && (e = (b.toMilliseconds() - f.begin.toMilliseconds()) / d), f.update(b, e, c));
    }
    for (;a.previousTS.isSmallerThan(b);) {
      for (name in a.parts) {
        f = a.parts[name], f.running && f.trigger.forEach(function(d, c) {
          var e = c.matchesPattern(a.previousTS, f.begin);
          if (e && !c._triggered) {
            for (c._triggered = !0, e = 0;e < d.length;e++) {
              d[e] && d[e].call(f, b);
            }
          } else {
            e || (c._triggered = !1);
          }
        });
      }
      a.previousTS.addTicks(1);
    }
  }, e = function() {
    var b = null, d = null;
    for (name in a.parts) {
      var c = a.parts[name];
      c.running && (null == b && c.renderToScreen ? b = c : c.render());
      c._debug_renderToScreen && (d = c);
    }
    b && b.render();
    d && d.render();
  }, d = function() {
    a.end();
  };
})();
kvg.setup = {};
(function() {
  function a(a) {
    $("#setup").hide();
    BigScreen.enabled ? BigScreen.request($("#demo")[0], c, b, e) : console.log("BigScreen not enabled!");
  }
  function c() {
    $("#muted input").is(":checked") && kvg.sound.setVolume(0);
    kvg.core.graphics.initWebGL({width:screen.width, height:screen.height, clearColor:2105376});
    g();
  }
  function b() {
  }
  function e() {
    console.log("Could not start fullscreen");
  }
  function d(a) {
    $("#setup").hide();
    $("#demo").css("transform", "").css("-webkit-transform", "");
    a = "on" === $("#aspectLock input").val();
    var b = $("#muted input").is(":checked"), c = $("#resolution .active input[name='options']").val(), d = 1280, e = 720;
    "b" === c ? (d = 1920, e = 1080) : "c" === c && (d = window.innerWidth, e = window.innerHeight, c = 1280 / 720, a && 1 * d / c < e ? e = 720 * window.innerWidth / 1280 : a && e < 1 * d / c && (d = 1280 * window.innerHeight / 720));
    $("#demo").css("width", d).css("height", e);
    kvg.core.graphics.initWebGL({width:d, height:e, clearColor:2105376});
    console.log("debug volume: " + b);
    b && kvg.sound.setVolume(0);
    g();
  }
  function g() {
    console.log("WEBGL initialized");
    kvg.core.demo.initialize();
    console.log("Demo initialized");
    kvg.sound.loaded ? (console.log("Sound loaded, starting"), kvg.core.demo.start()) : kvg.sound.onSoundLoaded.add(h);
  }
  function h() {
    console.log("Sound loaded");
    kvg.core.demo.start();
  }
  kvg.setup.init = function() {
    var b = $("#setup");
    b.find("#resolution");
    var c = b.find("#fullscreen"), b = b.find("#start");
    c.click(a);
    b.click(d);
    console.log("Setup initialized");
  };
})();
(function() {
  kvg.debug.init = function() {
    kvg.Config && kvg.Config.DEBUG && $().ready(a);
  };
  var a = function() {
    console.log("Debug initialized");
    var a = kvg.core.demo.start;
    kvg.core.demo.start = function() {
      a.call(kvg.core.demo);
      b(kvg.core.demo);
      setInterval(c, 33);
      document.addEventListener("keydown", function(a) {
        "109" != a.keyCode && "188" != a.keyCode || !kvg.sound.instance || (kvg.sound.instance.setPosition(kvg.sound.instance.getPosition() - 5E3), createjs.Tween.tick(-5E3, !1));
        "107" != a.keyCode && "190" != a.keyCode || !kvg.sound.instance || (kvg.sound.instance.setPosition(kvg.sound.instance.getPosition() + 5E3), createjs.Tween.tick(5E3, !1));
      }, !1);
    };
  }, c = function() {
    var a = kvg.sound.getPosition();
    $("#debug_timesig").html(a.toString() + "<br/>" + Math.round(a.toMilliseconds() / 100) / 10 + "s");
    for (n in kvg.core.demo.parts) {
      (a = kvg.core.demo.parts[n]) && a.running ? $("#debug_parts div").filter(function() {
        return $(this).text() === n;
      }).addClass("running") : $("#debug_parts div").filter(function() {
        return $(this).text() === n;
      }).removeClass("running");
    }
  }, b = function(a) {
    for (name in a.parts) {
      a = $('<div id="debug_' + name + '">' + name + "</div>"), $("#debug_parts").append(a), a.mouseover(e), a.mouseout(d);
    }
    kvg.core.graphics.onRender.add(g);
  }, e = function(a) {
    a = $(a.currentTarget).text();
    a = kvg.core.demo.parts[a];
    for (n in kvg.core.demo.parts) {
      kvg.core.demo.parts[n]._debug_renderToScreen = !1;
    }
    a && (a._debug_renderToScreen = !0, a.setRenderToScreen(!1));
  }, d = function(a) {
    for (n in kvg.core.demo.parts) {
      kvg.core.demo.parts[n] && (kvg.core.demo.parts[n]._debug_renderToScreen = !1);
    }
  }, g = function() {
  };
})();

