import ddf.minim.*;

public interface Effect {
  public void setup(PGraphics pg);
  public void draw(PGraphics pg); 
}

  static Effect[] effects;
  static float partTimes[] = {600, 3500, 1000, 3000, 
                              4500, 5000, 14000};
  Minim minim;
  AudioPlayer player;
  float startTime = -1;
  int activePart = 0, lastPart = -1;
//  int frame = 0;

  PGraphics pg;

  void setup() {
    pg = createGraphics(displayWidth, displayHeight);
    pg.background(0);
    pg.setSize(displayWidth, displayHeight);
    pg.smooth();
    frameRate(25);
    sketchFullScreen();
    minim = new Minim(this);
    print(dataPath("valmet_children_-_ohansevarma_demoedit.mp3"));
    player = minim.loadFile(dataPath("valmet_children_-_ohansevarma_demoedit.mp3"), 2048);
    effects = new Effect[7];
    effects[0] = new Sleeper();
    effects[1] = new Starfield3();
    effects[2] = new Starfield3();
    effects[3] = new Starfield3();
    effects[4] = new Starfield4();
    effects[5] = new Starfield5();
    effects[6] = new Starfield1();
    for (Effect fx: effects) {
      fx.setup(pg);
    }
    player.play();
  }  

  void draw()
  {
    if (startTime == -1)
      startTime = millis();
    lastPart = activePart;
    float pastParts = 0;
    for (int i = 0; i < activePart; i++)
      pastParts += partTimes[i];
    if (millis() - pastParts - startTime > partTimes[activePart]) {
      println(millis()-pastParts-startTime + " greater than " + partTimes[activePart] + ", moving on to next part...");
      lastPart = activePart++;
    }
    if ((lastPart == 3 && activePart == 4) 
        || (lastPart == 4 && activePart == 5)
        || (lastPart == 5 && activePart == 6))
    {
      println("Last part: " + lastPart + ", active: " + activePart + ", clearing...");
      pg.clear();      
      clear();
    }
    if (activePart < effects.length)
      effects[activePart].draw(pg);
    else
      exit();
    image(((PImage)pg), 0, 0);
//    save(frame + ".png");
//    frame++;
  }
  
  void stop()
  {
    player.close();
    minim.stop();
    super.stop();
  }

