/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.MapLayout;
import treemap.MapModel;
import treemap.Mappable;
import treemap.Rect;

public class StripTreemap
implements MapLayout {
    public static final boolean DEBUG = false;
    Mappable[] items;
    Rect layoutBox;
    boolean lookahead = true;

    public String getName() {
        return "StripTreemap";
    }

    public String getDescription() {
        return "An Ordered Squarified Treemap";
    }

    public void setLookahead(boolean lookahead) {
        this.lookahead = lookahead;
    }

    public void layout(MapModel model, double x, double y, double w, double h) {
        this.layout(model, new Rect(x, y, w, h));
    }

    public void layout(MapModel model, Rect bounds) {
        this.items = model.getItems();
        this.layoutBox = bounds;
        double totalSize = 0.0;
        int i = 0;
        while (i < this.items.length) {
            totalSize += this.items[i].getSize();
            ++i;
        }
        double area = this.layoutBox.w * this.layoutBox.h;
        double scaleFactor = Math.sqrt(area / totalSize);
        int finishedIndex = 0;
        int numItems = 0;
        double yoffset = 0.0;
        Rect box = new Rect(this.layoutBox);
        box.x /= scaleFactor;
        box.y /= scaleFactor;
        box.w /= scaleFactor;
        box.h /= scaleFactor;
        while (finishedIndex < this.items.length) {
            this.debug("A: finishedIndex = " + finishedIndex);
            numItems = this.layoutStrip(box, finishedIndex);
            if (this.lookahead && finishedIndex + numItems < this.items.length) {
                int numItems2 = this.layoutStrip(box, finishedIndex + numItems);
                double ar2a = this.computeAverageAspectRatio(finishedIndex, numItems + numItems2);
                this.computeHorizontalBoxLayout(box, finishedIndex, numItems + numItems2);
                double ar2b = this.computeAverageAspectRatio(finishedIndex, numItems + numItems2);
                this.debug("F: numItems2 = " + numItems2 + ", ar2a=" + ar2a + ", ar2b=" + ar2b);
                if (ar2b < ar2a) {
                    this.debug("G: numItems = " + (numItems += numItems2));
                } else {
                    this.computeHorizontalBoxLayout(box, finishedIndex, numItems);
                    this.debug("H: backup numItems = " + numItems);
                }
            }
            i = finishedIndex;
            while (i < finishedIndex + numItems) {
                this.items[i].getBounds().y += yoffset;
                ++i;
            }
            double height = this.items[finishedIndex].getBounds().h;
            yoffset += height;
            box.y += height;
            box.h -= height;
            finishedIndex += numItems;
        }
        i = 0;
        while (i < this.items.length) {
            Rect rect = this.items[i].getBounds();
            rect.x *= scaleFactor;
            rect.y *= scaleFactor;
            rect.w *= scaleFactor;
            rect.h *= scaleFactor;
            rect.x += bounds.x;
            rect.y += bounds.y;
            this.items[i].setBounds(rect);
            ++i;
        }
    }

    protected int layoutStrip(Rect box, int index) {
        double prevAR;
        int numItems = 0;
        double ar = Double.MAX_VALUE;
        do {
            prevAR = ar;
            ar = this.computeAverageAspectRatio(index, ++numItems);
            this.debug("L.1: numItems=" + numItems + ", prevAR=" + prevAR + ", ar=" + ar);
        } while (ar < prevAR && index + numItems < this.items.length);
        if (ar >= prevAR) {
            ar = this.computeAverageAspectRatio(index, --numItems);
            this.debug("L.2: backup: numItems=" + numItems);
        }
        return numItems;
    }

    protected double computeHorizontalBoxLayout(Rect box, int index, int numItems) {
        double totalSize = this.computeSize(index, numItems);
        double height = totalSize / box.w;
        double x = 0.0;
        int i = 0;
        while (i < numItems) {
            double width = this.items[i + index].getSize() / height;
            this.items[i + index].setBounds(x, 0.0, width, height);
            x += width;
            ++i;
        }
        return height;
    }

    public void debug(String str) {
    }

    double computeSize(int index, int num) {
        double size = 0.0;
        int i = 0;
        while (i < num) {
            size += this.items[i + index].getSize();
            ++i;
        }
        return size;
    }

    double computeAverageAspectRatio(int index, int numItems) {
        double tar = 0.0;
        int i = 0;
        while (i < numItems) {
            double w = this.items[i + index].getBounds().w;
            double h = this.items[i + index].getBounds().h;
            double ar = Math.max(w / h, h / w);
            tar += ar;
            ++i;
        }
        return tar /= (double)numItems;
    }

    double computeAspectRatio(int index) {
        double w = this.items[index].getBounds().w;
        double h = this.items[index].getBounds().h;
        double ar = Math.max(w / h, h / w);
        return ar;
    }
}

