/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.MapModel;
import treemap.Mappable;
import treemap.Rect;

public class LayoutDifference {
    private Rect[] old;

    public void recordLayout(MapModel model) {
        this.recordLayout(model.getItems());
    }

    public void recordLayout(Mappable[] m) {
        this.old = null;
        if (m == null) {
            return;
        }
        this.old = new Rect[m.length];
        int i = 0;
        while (i < m.length) {
            this.old[i] = m[i].getBounds().copy();
            ++i;
        }
    }

    public double averageDistance(MapModel model) {
        return this.averageDistance(model.getItems());
    }

    public double averageDistance(Mappable[] m) {
        double d = 0.0;
        int n = m.length;
        if (m == null || this.old == null || n != this.old.length) {
            System.out.println("Can't compare models.");
            return 0.0;
        }
        int i = 0;
        while (i < n) {
            d += this.old[i].distance(m[i].getBounds());
            ++i;
        }
        return d / (double)n;
    }
}

