/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Toolkit;

public class EditorHeader
extends JComponent {
    static final int SCROLLBAR_WIDTH = 16;
    static final int MARGIN_WIDTH = 6;
    static final int ARROW_GAP_WIDTH = 8;
    static final int NOTCH = 0;
    static final int TAB_HEIGHT = 25;
    static final int TAB_STRETCH = 3;
    static final int TAB_BETWEEN = 2;
    static final int TEXT_MARGIN = 10;
    static final int NO_TEXT_WIDTH = 10;
    Color bgColor;
    boolean hiding;
    Color hideColor;
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    Color modifiedColor;
    Editor editor;
    Tab[] tabs = new Tab[0];
    Tab[] visitOrder;
    Font font;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    int menuLeft;
    int menuRight;
    static final String[] STATUS = new String[]{"unsel", "sel"};
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    static final int PIECE_WIDTH = 4;
    static final int PIECE_HEIGHT = 33;
    Image[][] pieces;
    static final int ARROW_WIDTH = 14;
    static final int ARROW_HEIGHT = 14;
    static Image tabArrow;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    String lastNoticeName;

    public EditorHeader(Editor eddie) {
        this.editor = eddie;
        this.updateMode();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x > EditorHeader.this.menuLeft && x < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, x, y);
                } else {
                    Sketch sketch = EditorHeader.this.editor.getSketch();
                    Tab[] tabArray = EditorHeader.this.tabs;
                    int n = EditorHeader.this.tabs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tab tab = tabArray[n2];
                        if (tab.contains(x)) {
                            sketch.setCurrentCode(tab.index);
                            EditorHeader.this.repaint();
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (EditorHeader.this.lastNoticeName != null) {
                    EditorHeader.this.editor.clearNotice(EditorHeader.this.lastNoticeName);
                    EditorHeader.this.lastNoticeName = null;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                Tab[] tabArray = EditorHeader.this.tabs;
                int n = EditorHeader.this.tabs.length;
                int n2 = 0;
                while (n2 < n) {
                    Tab tab = tabArray[n2];
                    if (tab.contains(x) && !tab.textVisible) {
                        EditorHeader.this.lastNoticeName = EditorHeader.this.editor.getSketch().getCode(tab.index).getPrettyName();
                        EditorHeader.this.editor.statusNotice(EditorHeader.this.lastNoticeName);
                    }
                    ++n2;
                }
            }
        });
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        if (tabArrow == null) {
            String suffix = Toolkit.highResDisplay() ? "-2x.png" : ".png";
            tabArrow = Toolkit.getLibImage("tab-arrow" + suffix);
        }
        this.bgColor = mode.getColor("header.bgcolor");
        this.hiding = Preferences.getBoolean("buttons.hide.image");
        this.hideColor = mode.getColor("buttons.hide.color");
        this.textColor[1] = mode.getColor("header.text.selected.color");
        this.textColor[0] = mode.getColor("header.text.unselected.color");
        this.font = mode.getFont("header.text.font");
        this.tabColor[1] = mode.getColor("header.tab.selected.color");
        this.tabColor[0] = mode.getColor("header.tab.unselected.color");
        this.modifiedColor = mode.getColor("editor.selection.color");
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (screen == null) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        if (sketch == null) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = Toolkit.highResDisplay() ? this.createImage(this.imageW * 2, this.imageH * 2) : this.createImage(this.imageW, this.imageH);
        }
        Graphics g = this.offscreen.getGraphics();
        g.setFont(this.font);
        if (this.fontAscent == 0) {
            this.fontAscent = (int)Toolkit.getAscent(g);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (Toolkit.highResDisplay()) {
            g2.scale(2.0, 2.0);
            if (Base.isUsableOracleJava()) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(this.hiding ? this.hideColor : this.bgColor);
        g.fillRect(0, 0, this.imageW, this.imageH);
        if (!this.hiding) {
            this.editor.getMode().drawBackground(g, 32);
        }
        if (this.tabs.length != sketch.getCodeCount()) {
            this.tabs = new Tab[sketch.getCodeCount()];
            int i = 0;
            while (i < this.tabs.length) {
                this.tabs[i] = new Tab(i);
                ++i;
            }
            this.visitOrder = new Tab[sketch.getCodeCount() - 1];
        }
        int leftover = 28;
        int tabMax = this.getWidth() - leftover;
        Tab[] tabArray = this.tabs;
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            SketchCode code = sketch.getCode(tab.index);
            tab.textVisible = true;
            tab.lastVisited = code.lastVisited();
            boolean hide = this.editor.getMode().hideExtension(code.getExtension());
            tab.text = hide ? code.getPrettyName() : code.getFileName();
            tab.textWidth = (int)this.font.getStringBounds(tab.text, g2.getFontRenderContext()).getWidth();
            ++n2;
        }
        if (!this.placeTabs(6, tabMax, null)) {
            int index = 0;
            int i = this.tabs.length - 1;
            while (i > 0) {
                this.visitOrder[index++] = this.tabs[i];
                --i;
            }
            Arrays.sort(this.visitOrder);
            i = 0;
            while (i < this.visitOrder.length) {
                this.tabs[this.visitOrder[i].index].textVisible = false;
                if (this.placeTabs(6, tabMax, null)) break;
                ++i;
            }
        }
        this.placeTabs(6, tabMax, g2);
        this.menuLeft = this.tabs[this.tabs.length - 1].right + 8;
        this.menuRight = this.menuLeft + 14;
        int arrowY = this.getHeight() - 25 - 3 + 5;
        g.drawImage(tabArrow, this.menuLeft, arrowY, 14, 14, null);
        screen.drawImage(this.offscreen, 0, 0, this.imageW, this.imageH, null);
    }

    private boolean placeTabs(int left, int right, Graphics2D g) {
        Sketch sketch = this.editor.getSketch();
        int x = left;
        int bottom = this.getHeight() - 3;
        int top = bottom - 25;
        GeneralPath path = null;
        int i = 0;
        while (i < sketch.getCodeCount()) {
            int state;
            SketchCode code = sketch.getCode(i);
            Tab tab = this.tabs[i];
            int n = state = code == sketch.getCurrentCode() ? 1 : 0;
            if (g != null) {
                path = new GeneralPath();
                path.moveTo(x, bottom);
                path.lineTo(x, top + 0);
                path.lineTo(x + 0, top);
            }
            tab.left = x;
            x += 10;
            int drawWidth = tab.textVisible ? tab.textWidth : 10;
            tab.right = x += drawWidth + 10;
            if (g != null) {
                path.lineTo(x - 0, top);
                path.lineTo(x, top + 0);
                path.lineTo(x, bottom);
                path.closePath();
                g.setColor(this.tabColor[state]);
                g.fill(path);
                g.draw(path);
                if (tab.textVisible) {
                    int textLeft = tab.left + (tab.right - tab.left - tab.textWidth) / 2;
                    g.setColor(this.textColor[state]);
                    int tabHeight = 25;
                    int baseline = top + (tabHeight + this.fontAscent) / 2;
                    g.drawString(tab.text, textLeft, baseline);
                }
                if (code.isModified()) {
                    g.setColor(this.modifiedColor);
                    g.drawLine(tab.left + 0, top, tab.right - 0, top);
                }
            }
            x += 2;
            ++i;
        }
        if (g != null) {
            g.setColor(this.tabColor[1]);
            g.fillRect(0, bottom, this.getWidth(), 3);
        }
        return x <= right;
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
    }

    public void rebuildMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            this.popup = this.menu.getPopupMenu();
            this.add(this.popup);
            this.popup.setLightWeightPopupEnabled(true);
        }
        JMenuItem item = Toolkit.newJMenuItemShift("New Tab", 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleNewCode();
            }
        });
        this.menu.add(item);
        item = new JMenuItem("Rename");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleRenameCode();
            }
        });
        this.menu.add(item);
        item = new JMenuItem("Delete");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sketch sketch = EditorHeader.this.editor.getSketch();
                if (!Base.isMacOS() && EditorHeader.this.editor.base.editors.size() == 1 && sketch.getCurrentCodeIndex() == 0) {
                    Base.showWarning("Yeah, no.", "You can't delete the last tab of the last open sketch.", null);
                } else {
                    EditorHeader.this.editor.getSketch().handleDeleteCode();
                }
            }
        });
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem("Previous Tab");
        KeyStroke ctrlAltLeft = KeyStroke.getKeyStroke(37, Toolkit.SHORTCUT_ALT_KEY_MASK);
        item.setAccelerator(ctrlAltLeft);
        this.menu.add(item);
        item = new JMenuItem("Next Tab");
        KeyStroke ctrlAltRight = KeyStroke.getKeyStroke(39, Toolkit.SHORTCUT_ALT_KEY_MASK);
        item.setAccelerator(ctrlAltRight);
        this.menu.add(item);
        Sketch sketch = this.editor.getSketch();
        if (sketch != null) {
            this.menu.addSeparator();
            ActionListener jumpListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorHeader.this.editor.getSketch().setCurrentCode(e.getActionCommand());
                }
            };
            SketchCode[] sketchCodeArray = sketch.getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode code = sketchCodeArray[n2];
                item = new JMenuItem(code.getPrettyName());
                item.addActionListener(jumpListener);
                this.menu.add(item);
                ++n2;
            }
        }
    }

    public void deselectMenu() {
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 32);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    class Tab
    implements Comparable {
        int index;
        int left;
        int right;
        String text;
        int textWidth;
        boolean textVisible;
        long lastVisited;

        Tab(int index) {
            this.index = index;
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        public int compareTo(Object o) {
            Tab other = (Tab)o;
            if (this.lastVisited == other.lastVisited) {
                return 0;
            }
            if (this.lastVisited == 0L) {
                return -1;
            }
            if (other.lastVisited == 0L) {
                return 1;
            }
            return (int)(this.lastVisited - other.lastVisited);
        }
    }
}

