/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Toolkit;

public abstract class EditorToolbar
extends JComponent
implements MouseInputListener,
KeyListener {
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_GAP = 5;
    static final int BUTTON_IMAGE_SIZE = 33;
    static final int INACTIVE = 0;
    static final int ROLLOVER = 1;
    static final int ACTIVE = 2;
    protected Base base;
    protected Editor editor;
    protected Mode mode;
    Image offscreen;
    int width;
    int height;
    Color bgColor;
    boolean hiding;
    Color hideColor;
    protected Button rollover;
    Font statusFont;
    int statusAscent;
    Color statusColor;
    boolean shiftPressed;
    Color modeButtonColor;
    Font modeTextFont;
    int modeTextAscent;
    Color modeTextColor;
    String modeTitle;
    int modeX1;
    int modeY1;
    int modeX2;
    int modeY2;
    JMenu modeMenu;
    protected ArrayList<Button> buttons;
    static final int ARROW_WIDTH = 7;
    static final int ARROW_HEIGHT = 6;
    static Image modeArrow;

    public EditorToolbar(Editor editor, Base base) {
        this.editor = editor;
        this.base = base;
        this.buttons = new ArrayList();
        this.rollover = null;
        this.mode = editor.getMode();
        this.bgColor = this.mode.getColor("buttons.bgcolor");
        this.statusFont = this.mode.getFont("buttons.status.font");
        this.statusColor = this.mode.getColor("buttons.status.color");
        this.modeTitle = this.mode.getTitle();
        this.modeTextFont = this.mode.getFont("mode.button.font");
        this.modeButtonColor = this.mode.getColor("mode.button.color");
        this.hiding = Preferences.getBoolean("buttons.hide.image");
        this.hideColor = this.mode.getColor("buttons.hide.color");
        if (modeArrow == null) {
            String suffix = Toolkit.highResDisplay() ? "-2x.png" : ".png";
            modeArrow = Toolkit.getLibImage("mode-arrow" + suffix);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public abstract void init();

    public Image[][] loadImages() {
        int res = Toolkit.highResDisplay() ? 2 : 1;
        String suffix = null;
        Image allButtons = null;
        if (res == 2 && (allButtons = this.mode.loadImage("theme/buttons" + (suffix = "-2x.png"))) == null) {
            res = 1;
        }
        if (res == 1 && (allButtons = this.mode.loadImage("theme/buttons" + (suffix = ".png"))) == null) {
            suffix = ".gif";
            allButtons = this.mode.loadImage("theme/buttons" + suffix);
        }
        int count = allButtons.getWidth(this) / 27 * res;
        Image[][] buttonImages = new Image[count][3];
        int i = 0;
        while (i < count) {
            int state = 0;
            while (state < 3) {
                BufferedImage image = new BufferedImage(27 * res, 32 * res, 2);
                Graphics g = ((Image)image).getGraphics();
                g.drawImage(allButtons, -(i * 33 * res) - 3, (state - 2) * 33 * res, null);
                g.dispose();
                buttonImages[i][state] = image;
                ++state;
            }
            ++i;
        }
        return buttonImages;
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (this.buttons.size() == 0) {
            this.init();
        }
        Dimension size = this.getSize();
        if (this.offscreen == null || size.width != this.width || size.height != this.height) {
            this.offscreen = Toolkit.highResDisplay() ? this.createImage(size.width * 2, size.height * 2) : this.createImage(size.width, size.height);
            this.width = size.width;
            this.height = size.height;
            int offsetX = 3;
            for (Button b : this.buttons) {
                b.left = offsetX;
                if (b.gap) {
                    b.left += 5;
                }
                offsetX = b.right = b.left + 27;
            }
        }
        Graphics g = this.offscreen.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        if (Toolkit.highResDisplay()) {
            g2.scale(2.0, 2.0);
            if (Base.isUsableOracleJava()) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(this.hiding ? this.hideColor : this.bgColor);
        g.fillRect(0, 0, this.width, this.height);
        if (!this.hiding) {
            this.mode.drawBackground(g, 0);
        }
        for (Button b : this.buttons) {
            g.drawImage(b.stateImage, b.left, 0, 27, 32, null);
        }
        g.setColor(this.statusColor);
        g.setFont(this.statusFont);
        if (this.statusAscent == 0) {
            this.statusAscent = (int)Toolkit.getAscent(g);
        }
        if (this.rollover != null) {
            int statusY = (32 + this.statusAscent) / 2;
            String status = this.shiftPressed ? this.rollover.titleShift : this.rollover.title;
            g.drawString(status, this.buttons.size() * 27 + 15, statusY);
        }
        g.setFont(this.modeTextFont);
        FontMetrics metrics = g.getFontMetrics();
        if (this.modeTextAscent == 0) {
            this.modeTextAscent = (int)Toolkit.getAscent(g);
        }
        int modeTextWidth = metrics.stringWidth(this.modeTitle);
        this.modeX2 = this.getWidth() - 16;
        this.modeX1 = this.modeX2 - (8 + modeTextWidth + 8 + 7 + 8);
        this.modeY1 = (this.getHeight() - 20) / 2;
        this.modeY2 = this.modeY1 + 20;
        g.setColor(this.modeButtonColor);
        g.drawRect(this.modeX1, this.modeY1, this.modeX2 - this.modeX1, this.modeY2 - this.modeY1 - 1);
        g.drawString(this.modeTitle, this.modeX1 + 8, this.modeY1 + (20 + this.modeTextAscent) / 2);
        g.drawImage(modeArrow, this.modeX2 - 7 - 8, this.modeY1 + 7, 7, 6, null);
        screen.drawImage(this.offscreen, 0, 0, size.width, size.height, null);
    }

    protected void checkRollover(int x, int y) {
        Button over = this.findSelection(x, y);
        if (over != null && over.state != 2) {
            over.setState(1, true);
            this.rollover = over;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.offscreen == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.rollover != null) {
            if (y > 0 && y < this.getHeight() && x > this.rollover.left && x < this.rollover.right) {
                return;
            }
            if (this.rollover.state == 1) {
                this.rollover.setState(0, true);
            }
            this.rollover = null;
        }
        this.checkRollover(x, y);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private Button findSelection(int x, int y) {
        if (this.offscreen != null && y > 0 && y < this.getHeight()) {
            for (Button b : this.buttons) {
                if (x <= b.left || x >= b.right) continue;
                return b;
            }
        }
        return null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getComponent() != this) {
            return;
        }
        if (this.rollover != null) {
            if (this.rollover.state == 1) {
                this.rollover.setState(0, true);
            }
            this.rollover = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEnabled()) {
            int x = e.getX();
            int y = e.getY();
            if (x > this.modeX1 && x < this.modeX2 && y > this.modeY1 && y < this.modeY2) {
                JPopupMenu popup = this.editor.getModeMenu().getPopupMenu();
                popup.show(this, x, y);
            }
            this.checkRollover(x, y);
            if (this.rollover != null) {
                this.handlePressed(e, this.buttons.indexOf(this.rollover));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public abstract void handlePressed(MouseEvent var1, int var2);

    public void activate(int what) {
        this.buttons.get(what).setState(2, true);
    }

    public void deactivate(int what) {
        this.buttons.get(what).setState(0, true);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension((this.buttons.size() + 1) * 27, 32);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = true;
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = false;
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void addButton(String title, String shiftTitle, Image[] images, boolean gap) {
        Button b = new Button(title, shiftTitle, images, gap);
        this.buttons.add(b);
    }

    public class Button {
        String title;
        String titleShift;
        Image[] images;
        int state;
        Image stateImage;
        int left;
        int right;
        boolean gap;

        public Button(String title, String titleShift, Image[] images, boolean gap) {
            this.title = title;
            this.titleShift = titleShift;
            this.images = images;
            this.gap = gap;
            this.state = 0;
            this.stateImage = images[0];
        }

        public void setState(int newState, boolean updateAfter) {
            this.state = newState;
            this.stateImage = this.images[newState];
            if (updateAfter) {
                EditorToolbar.this.repaint();
            }
        }
    }
}

