/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorState;
import processing.app.Library;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.SketchReference;
import processing.app.Toolkit;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TokenMarker;
import processing.core.PApplet;

public abstract class Mode {
    protected Base base;
    protected File folder;
    protected TokenMarker tokenMarker;
    protected HashMap<String, String> keywordToReference = new HashMap();
    protected Settings theme;
    protected HashMap<String, ArrayList<Library>> importToLibraryTable;
    protected JMenu examplesMenu;
    protected JMenu importMenu;
    protected JFrame examplesFrame;
    protected JMenu toolbarMenu;
    protected File examplesFolder;
    protected File librariesFolder;
    protected File referenceFolder;
    public ArrayList<Library> coreLibraries;
    public ArrayList<Library> contribLibraries;
    protected Library coreLibrary;
    protected ClassLoader classLoader;
    static final int BACKGROUND_WIDTH = 1025;
    static final int BACKGROUND_HEIGHT = 65;
    protected Image backgroundImage;

    public Mode(Base base, File folder) {
        this.base = base;
        this.folder = folder;
        this.tokenMarker = this.createTokenMarker();
        this.examplesFolder = new File(folder, "examples");
        this.librariesFolder = new File(folder, "libraries");
        this.referenceFolder = new File(folder, "reference");
        this.rebuildLibraryList();
        try {
            File[] fileArray = this.getKeywordFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.loadKeywords(file);
                ++n2;
            }
        }
        catch (IOException e) {
            Base.showWarning("Problem loading keywords", "Could not load keywords file for " + this.getTitle() + " mode.", e);
        }
    }

    public File[] getKeywordFiles() {
        return new File[]{new File(this.folder, "keywords.txt")};
    }

    protected void loadKeywords(File keywordFile) throws IOException {
        this.loadKeywords(keywordFile, "#");
    }

    protected void loadKeywords(File keywordFile, String commentPrefix) throws IOException {
        BufferedReader reader = PApplet.createReader((File)keywordFile);
        String line = null;
        while ((line = reader.readLine()) != null) {
            String htmlFilename;
            String[] pieces;
            if (line.trim().startsWith(commentPrefix) || (pieces = PApplet.splitTokens((String)line)).length < 2) continue;
            String keyword = pieces[0];
            String coloring = pieces[1];
            if (coloring.length() > 0) {
                this.tokenMarker.addColoring(keyword, coloring);
            }
            if (pieces.length != 3 || (htmlFilename = pieces[2]).length() <= 0) continue;
            if (htmlFilename.endsWith("_")) {
                keyword = String.valueOf(keyword) + "_";
            }
            this.keywordToReference.put(keyword, htmlFilename);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setupGUI() {
        try {
            this.theme = new Settings(Base.getContentFile("lib/theme.txt"));
            File modeTheme = new File(this.folder, "theme/theme.txt");
            if (modeTheme.exists()) {
                this.theme.load(modeTheme);
            }
            this.theme.setColor("run.window.bgcolor", SystemColor.control);
            this.loadBackground();
        }
        catch (IOException e) {
            Base.showError("Problem loading theme.txt", "Could not load theme.txt, please re-install Processing", e);
        }
    }

    protected void loadBackground() {
        String suffix = Toolkit.highResDisplay() ? "-2x.png" : ".png";
        this.backgroundImage = this.loadImage("theme/mode" + suffix);
        if (this.backgroundImage == null) {
            suffix = !Toolkit.highResDisplay() ? "-2x.png" : ".png";
            this.backgroundImage = this.loadImage("theme/mode" + suffix);
        }
    }

    public void drawBackground(Graphics g, int offset) {
        if (this.backgroundImage != null) {
            if (!Toolkit.highResDisplay()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            g.drawImage(this.backgroundImage, 0, -offset, 1025, 65, null);
        }
    }

    public File getContentFile(String path) {
        return new File(this.folder, path);
    }

    public InputStream getContentStream(String path) throws FileNotFoundException {
        return new FileInputStream(this.getContentFile(path));
    }

    public abstract String getTitle();

    public String getIdentifier() {
        return this.getClass().getCanonicalName();
    }

    public abstract Editor createEditor(Base var1, String var2, EditorState var3);

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public File getLibrariesFolder() {
        return this.librariesFolder;
    }

    public File getReferenceFolder() {
        return this.referenceFolder;
    }

    public void rebuildLibraryList() {
        this.importToLibraryTable = new HashMap();
        this.coreLibraries = Library.list(this.librariesFolder);
        for (Library lib : this.coreLibraries) {
            lib.addPackageList(this.importToLibraryTable);
        }
        File contribLibrariesFolder = Base.getSketchbookLibrariesFolder();
        if (contribLibrariesFolder != null) {
            this.contribLibraries = Library.list(contribLibrariesFolder);
            for (Library lib : this.contribLibraries) {
                lib.addPackageList(this.importToLibraryTable);
            }
        }
    }

    public Library getCoreLibrary() {
        return null;
    }

    public Library getLibrary(String pkgName) throws SketchException {
        ArrayList<Library> libraries = this.importToLibraryTable.get(pkgName);
        if (libraries == null) {
            return null;
        }
        if (libraries.size() > 1) {
            String primary = "More than one library is competing for this sketch.";
            String secondary = "The import " + pkgName + " points to multiple libraries:<br>";
            for (Library library : libraries) {
                String location = library.getPath();
                if (location.startsWith(this.getLibrariesFolder().getAbsolutePath())) {
                    location = "part of Processing";
                }
                secondary = String.valueOf(secondary) + "<b>" + library.getName() + "</b> (" + location + ")<br>";
            }
            secondary = String.valueOf(secondary) + "Extra libraries need to be removed before this sketch can be used.";
            Base.showWarningTiered("Duplicate Library Problem", primary, secondary, null);
            throw new SketchException("Duplicate libraries found for " + pkgName + ".");
        }
        return libraries.get(0);
    }

    public JMenu getToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        }
        return this.toolbarMenu;
    }

    public void insertToolbarRecentMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        } else {
            this.toolbarMenu.insert(this.base.getToolbarRecentMenu(), 1);
        }
    }

    public void removeToolbarRecentMenu() {
        this.toolbarMenu.remove(this.base.getToolbarRecentMenu());
    }

    protected void rebuildToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.toolbarMenu = new JMenu();
        } else {
            this.toolbarMenu.removeAll();
        }
        JMenuItem item = Toolkit.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.base.handleOpenPrompt();
            }
        });
        this.toolbarMenu.add(item);
        this.insertToolbarRecentMenu();
        item = Toolkit.newJMenuItemShift("Examples...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.showExamplesFrame();
            }
        });
        this.toolbarMenu.add(item);
        this.toolbarMenu.addSeparator();
        this.base.populateSketchbookMenu(this.toolbarMenu);
    }

    public JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.rebuildImportMenu();
        }
        return this.importMenu;
    }

    public void rebuildImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu("Import Library...");
        } else {
            this.importMenu.removeAll();
        }
        JMenuItem addLib = new JMenuItem("Add Library...");
        addLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.base.handleOpenLibraryManager();
            }
        });
        this.importMenu.add(addLib);
        this.importMenu.addSeparator();
        this.rebuildLibraryList();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.base.activeEditor.handleImportLibrary(e.getActionCommand());
            }
        };
        if (this.coreLibraries.size() == 0) {
            JMenuItem item = new JMenuItem(String.valueOf(this.getTitle()) + " mode has no core libraries");
            item.setEnabled(false);
            this.importMenu.add(item);
        } else {
            for (Library library : this.coreLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getJarPath());
                this.importMenu.add(item);
            }
        }
        if (this.contribLibraries.size() != 0) {
            this.importMenu.addSeparator();
            JMenuItem contrib = new JMenuItem("Contributed");
            contrib.setEnabled(false);
            this.importMenu.add(contrib);
            HashMap<String, JMenu> subfolders = new HashMap<String, JMenu>();
            for (Library library : this.contribLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getJarPath());
                String group = library.getGroup();
                if (group != null) {
                    JMenu subMenu = (JMenu)subfolders.get(group);
                    if (subMenu == null) {
                        subMenu = new JMenu(group);
                        this.importMenu.add(subMenu);
                        subfolders.put(group, subMenu);
                    }
                    subMenu.add(item);
                    continue;
                }
                this.importMenu.add(item);
            }
        }
    }

    public File[] getExampleCategoryFolders() {
        return this.examplesFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.charAt(0) != '.';
            }
        });
    }

    public JTree buildExamplesTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Examples");
        JTree examplesTree = new JTree(node);
        try {
            File[] subfolders = this.getExampleCategoryFolders();
            File[] fileArray = subfolders;
            int n = subfolders.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(sub.getName());
                if (this.base.addSketches(subNode, sub)) {
                    node.add(subNode);
                }
                ++n2;
            }
            boolean any = false;
            DefaultMutableTreeNode libParent = new DefaultMutableTreeNode("Libraries");
            for (Library lib : this.coreLibraries) {
                if (!lib.hasExamples()) continue;
                DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib.getName());
                any |= this.base.addSketches(libNode, lib.getExamplesFolder());
                libParent.add(libNode);
            }
            if (any) {
                node.add(libParent);
            }
            any = false;
            for (Library lib : this.contribLibraries) {
                if (!lib.hasExamples()) continue;
                any = true;
            }
            if (any) {
                DefaultMutableTreeNode contribParent = new DefaultMutableTreeNode("Contributed Libraries");
                for (Library lib : this.contribLibraries) {
                    if (!lib.hasExamples()) continue;
                    DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib.getName());
                    this.base.addSketches(libNode, lib.getExamplesFolder());
                    contribParent.add(libNode);
                }
                node.add(contribParent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return examplesTree;
    }

    public void resetExamples() {
        if (this.examplesFrame != null) {
            boolean visible = this.examplesFrame.isVisible();
            Rectangle bounds = null;
            if (visible) {
                bounds = this.examplesFrame.getBounds();
                this.examplesFrame.setVisible(false);
            }
            this.examplesFrame = null;
            if (visible) {
                this.showExamplesFrame();
                this.examplesFrame.setBounds(bounds);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void showExamplesFrame() {
        if (this.examplesFrame == null) {
            this.examplesFrame = new JFrame(String.valueOf(this.getTitle()) + " Examples");
            Toolkit.setIcon(this.examplesFrame);
            Toolkit.registerWindowCloseKeys(this.examplesFrame.getRootPane(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Mode.this.examplesFrame.setVisible(false);
                }
            });
            tree = this.buildExamplesTree();
            tree.getSelectionModel().setSelectionMode(1);
            tree.setShowsRootHandles(true);
            tree.expandRow(0);
            tree.setRootVisible(false);
            tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                        int selRow = tree.getRowForLocation(e.getX(), e.getY());
                        if (node != null && node.isLeaf() && selRow != -1) {
                            SketchReference sketch = (SketchReference)node.getUserObject();
                            Mode.this.base.handleOpen(sketch.getPath());
                        }
                    }
                }
            });
            tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        Mode.this.examplesFrame.setVisible(false);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    DefaultMutableTreeNode node;
                    if (e.getKeyChar() == '\n' && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                        SketchReference sketch = (SketchReference)node.getUserObject();
                        Mode.this.base.handleOpen(sketch.getPath());
                    }
                }
            });
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    Mode.this.updateExpanded(tree);
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    Mode.this.updateExpanded(tree);
                }
            });
            tree.setBorder(new EmptyBorder(5, 5, 5, 5));
            if (Base.isMacOS()) {
                tree.setToggleClickCount(2);
            } else {
                tree.setToggleClickCount(1);
            }
            treePane = new JScrollPane(tree);
            treePane.setPreferredSize(new Dimension(250, 450));
            treePane.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.examplesFrame.getContentPane().add(treePane);
            this.examplesFrame.pack();
            this.restoreExpanded(tree);
        }
        roughWidth = this.examplesFrame.getWidth() + 20;
        p = null;
        if (this.base.activeEditor == null) ** GOTO lbl-1000
        p = this.base.activeEditor.getLocation();
        if (p.x < roughWidth) lbl-1000:
        // 2 sources

        {
            this.examplesFrame.setLocationRelativeTo(null);
        } else {
            this.examplesFrame.setLocation(p.x - roughWidth, p.y);
        }
        this.examplesFrame.setVisible(true);
    }

    protected void updateExpanded(JTree tree) {
        Enumeration<TreePath> en = tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
        StringBuilder s = new StringBuilder();
        while (en.hasMoreElements()) {
            Object[] path;
            TreePath tp = en.nextElement();
            Object[] objectArray = path = tp.getPath();
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                DefaultMutableTreeNode p = (DefaultMutableTreeNode)o;
                String name = (String)p.getUserObject();
                s.append(name);
                s.append(File.separatorChar);
                ++n2;
            }
            s.setCharAt(s.length() - 1, File.pathSeparatorChar);
        }
        s.setLength(s.length() - 1);
        String pref = "examples." + this.getClass().getName() + ".visible";
        Preferences.set(pref, s.toString());
        Preferences.save();
    }

    protected void restoreExpanded(JTree tree) {
        String pref = "examples." + this.getClass().getName() + ".visible";
        String value = Preferences.get(pref);
        if (value != null) {
            String[] paths;
            String[] stringArray = paths = PApplet.split((String)value, (String)File.pathSeparator);
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String[] items = PApplet.split((String)path, (String)File.separator);
                DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[items.length];
                this.expandTree(tree, null, items, nodes, 0);
                ++n2;
            }
        }
    }

    void expandTree(JTree tree, Object object, String[] items, DefaultMutableTreeNode[] nodes, int index) {
        TreeModel model = tree.getModel();
        if (index == 0) {
            nodes[0] = (DefaultMutableTreeNode)model.getRoot();
            this.expandTree(tree, nodes[0], items, nodes, 1);
        } else if (index < items.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            int count = model.getChildCount(node);
            int i = 0;
            while (i < count) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(node, i);
                if (items[index].equals(child.getUserObject())) {
                    nodes[index] = child;
                    this.expandTree(tree, child, items, nodes, index + 1);
                }
                ++i;
            }
        } else {
            tree.expandPath(new TreePath(nodes));
        }
    }

    public Image loadImage(String filename) {
        File file = new File(this.folder, filename);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(file.getAbsolutePath()).getImage();
    }

    public String lookupReference(String keyword) {
        return this.keywordToReference.get(keyword);
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    protected TokenMarker createTokenMarker() {
        return new PdeKeywords();
    }

    public boolean getBoolean(String attribute) {
        return this.theme.getBoolean(attribute);
    }

    public int getInteger(String attribute) {
        return this.theme.getInteger(attribute);
    }

    public Color getColor(String attribute) {
        return this.theme.getColor(attribute);
    }

    public Font getFont(String attribute) {
        return this.theme.getFont(attribute);
    }

    public SyntaxStyle getStyle(String attribute) {
        String str = Preferences.get("editor.token." + attribute + ".style");
        if (str == null) {
            throw new IllegalArgumentException("No style found for " + attribute);
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        String s = st.nextToken();
        if (s.indexOf("#") == 0) {
            s = s.substring(1);
        }
        Color color = new Color(Integer.parseInt(s, 16));
        s = st.nextToken();
        boolean bold = s.indexOf("bold") != -1;
        return new SyntaxStyle(color, bold);
    }

    public boolean hideExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(SketchCode code) {
        return code.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean canEdit(File f) {
        int dot = f.getName().lastIndexOf(46);
        if (dot < 0) {
            return false;
        }
        return this.validExtension(f.getName().substring(dot + 1));
    }

    public boolean validExtension(String what) {
        String[] ext = this.getExtensions();
        int i = 0;
        while (i < ext.length) {
            if (ext[i].equals(what)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract String getDefaultExtension();

    public String getModuleExtension() {
        return this.getDefaultExtension();
    }

    public abstract String[] getExtensions();

    public abstract String[] getIgnorable();

    public void prepareExportFolder(File targetFolder) {
        if (targetFolder != null) {
            if (Preferences.getBoolean("export.delete_target_folder")) {
                Base.removeDir(targetFolder);
            }
            targetFolder.mkdirs();
        }
    }

    public String toString() {
        return this.getTitle();
    }
}

