/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Preferences;
import processing.core.PApplet;

public class Recent {
    static final String FILENAME = "recent.txt";
    static final String VERSION = "2";
    Base base;
    File file;
    int remember;
    ArrayList<Record> records;
    JMenu mainMenu;
    JMenu toolbarMenu;

    public Recent(Base base) {
        this.base = base;
        this.remember = Preferences.getInteger("recent.count");
        this.file = Base.getSettingsFile(FILENAME);
        this.mainMenu = new JMenu("Recent");
        this.toolbarMenu = new JMenu("Recent");
        try {
            this.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void load() throws IOException {
        BufferedReader reader;
        String version;
        this.records = new ArrayList();
        if (this.file.exists() && (version = (reader = PApplet.createReader((File)this.file)).readLine()) != null && version.equals(VERSION)) {
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (new File(line).exists()) {
                    this.records.add(new Record(line));
                    continue;
                }
                Base.log(this, "ghost file: " + line);
            }
        }
        this.updateMenu(this.mainMenu);
        this.updateMenu(this.toolbarMenu);
    }

    protected void save() {
        PrintWriter writer = PApplet.createWriter((File)this.file);
        writer.println(VERSION);
        for (Record record : this.records) {
            writer.println(record.path);
        }
        writer.flush();
        writer.close();
        this.updateMenu(this.mainMenu);
        this.updateMenu(this.toolbarMenu);
    }

    public JMenu getMenu() {
        return this.mainMenu;
    }

    public JMenu getToolbarMenu() {
        return this.toolbarMenu;
    }

    private void updateMenu(JMenu menu) {
        menu.removeAll();
        String sketchbookPath = Base.getSketchbookFolder().getAbsolutePath();
        for (Record rec : this.records) {
            this.updateMenuRecord(menu, rec, sketchbookPath);
        }
    }

    private void updateMenuRecord(JMenu menu, final Record rec, String sketchbookPath) {
        try {
            String recPath = new File(rec.getPath()).getParent();
            String purtyPath = null;
            if (recPath.startsWith(sketchbookPath)) {
                purtyPath = "sketchbook \u2192 " + recPath.substring(sketchbookPath.length() + 1);
            } else {
                ArrayList<Mode> modes = this.base.getModeList();
                block2: for (Mode mode : modes) {
                    File examplesFolder = mode.getExamplesFolder();
                    String examplesPath = examplesFolder.getAbsolutePath();
                    if (recPath.startsWith(examplesPath)) {
                        String modePrefix = String.valueOf(mode.getTitle()) + " ";
                        if (mode.getTitle().equals("Standard")) {
                            modePrefix = "";
                        }
                        purtyPath = String.valueOf(modePrefix) + "examples \u2192 " + recPath.substring(examplesPath.length() + 1);
                        break;
                    }
                    if (mode.coreLibraries != null) {
                        for (Library lib : mode.coreLibraries) {
                            examplesFolder = lib.getExamplesFolder();
                            examplesPath = examplesFolder.getAbsolutePath();
                            if (!recPath.startsWith(examplesPath)) continue;
                            purtyPath = String.valueOf(lib.getName()) + " examples \u2192 " + recPath.substring(examplesPath.length() + 1);
                            break;
                        }
                    }
                    if (mode.contribLibraries == null) continue;
                    for (Library lib : mode.contribLibraries) {
                        examplesFolder = lib.getExamplesFolder();
                        examplesPath = examplesFolder.getAbsolutePath();
                        if (!recPath.startsWith(examplesPath)) continue;
                        purtyPath = String.valueOf(lib.getName()) + " examples \u2192 " + recPath.substring(examplesPath.length() + 1);
                        continue block2;
                    }
                }
            }
            if (purtyPath == null) {
                purtyPath = recPath;
            }
            JMenuItem item = new JMenuItem(purtyPath);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Recent.this.base.handleOpen(rec.path);
                }
            });
            menu.insert(item, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void remove(Editor editor) {
        int index = this.findRecord(editor.getSketch().getMainFilePath());
        if (index != -1) {
            this.records.remove(index);
        }
    }

    synchronized void handle(Editor editor) {
        if (!editor.getSketch().isUntitled()) {
            this.remove(editor);
            if (this.records.size() == this.remember) {
                this.records.remove(0);
            }
            this.records.add(new Record(editor));
            this.save();
        }
    }

    int findRecord(String path) {
        int i = 0;
        while (i < this.records.size()) {
            if (path.equals(this.records.get((int)i).path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    class Record {
        String path;
        Editor editor;

        Record(String path) {
            this.path = path;
        }

        Record(Editor editor) {
            this.editor = editor;
            this.path = editor.getSketch().getMainFilePath();
        }

        String getName() {
            if (this.editor != null) {
                return this.editor.getSketch().getName();
            }
            String name = this.path.substring(this.path.lastIndexOf(File.separatorChar) + 1);
            return name.substring(0, name.indexOf(46));
        }

        String getPath() {
            return this.path;
        }
    }
}

