/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Random;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Preferences;
import processing.core.PApplet;

public class UpdateCheck {
    Base base;
    String downloadURL = "http://processing.org/download/latest.txt";
    static final long ONE_DAY = 86400000L;

    public UpdateCheck(Base base) {
        this.base = base;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    UpdateCheck.this.updateCheck();
                }
                catch (Exception exception) {}
            }
        }).start();
    }

    public void updateCheck() throws Exception {
        long when;
        Random r = new Random();
        long id = r.nextLong();
        String idString = Preferences.get("update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            Preferences.set("update.id", String.valueOf(id));
        }
        String info = PApplet.urlEncode((String)(String.valueOf(id) + "\t" + PApplet.nf((int)Base.getRevision(), (int)4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch")));
        int latest = this.readInt(String.valueOf(this.downloadURL) + "?" + info);
        String lastString = Preferences.get("update.last");
        long now = System.currentTimeMillis();
        if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
            return;
        }
        Preferences.set("update.last", String.valueOf(now));
        if (this.base.activeEditor != null) {
            boolean offerToUpdateContributions = true;
            if (latest > Base.getRevision()) {
                System.out.println("You are running Processing revision 0" + Base.getRevision() + ", the latest build is 0" + latest + ".");
                boolean bl = offerToUpdateContributions = !this.promptToVisitDownloadPage();
            }
            if (offerToUpdateContributions) {
                Thread.sleep(5000L);
                if (!this.base.libraryManagerFrame.hasAlreadyBeenOpened() && this.base.libraryManagerFrame.hasUpdates() || !this.base.toolManagerFrame.hasAlreadyBeenOpened() && this.base.toolManagerFrame.hasUpdates() || !this.base.modeManagerFrame.hasAlreadyBeenOpened() && this.base.modeManagerFrame.hasUpdates()) {
                    this.promptToOpenContributionManager();
                }
            }
        }
    }

    protected boolean promptToVisitDownloadPage() {
        String prompt = "A new version of Processing is available,\nwould you like to visit the Processing download page?";
        Object[] options = new Object[]{"Yes", "No"};
        int result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, "Update", 0, 3, null, options, options[0]);
        if (result == 0) {
            Base.openURL("http://processing.org/download/");
            return true;
        }
        return false;
    }

    protected boolean promptToOpenContributionManager() {
        String contributionPrompt = "There are updates available for some of the installed contributions,\nwould you like to open the the Contribution Manager now?";
        Object[] options = new Object[]{"Yes", "No"};
        int result = JOptionPane.showOptionDialog(this.base.activeEditor, contributionPrompt, "Update", 0, 3, null, options, options[0]);
        if (result == 0) {
            this.base.handleShowUpdates();
            return true;
        }
        return false;
    }

    protected int readInt(String filename) throws Exception {
        URL url = new URL(filename);
        InputStream stream = url.openStream();
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        return Integer.parseInt(reader.readLine());
    }
}

