/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Editor;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.StatusPanel;
import processing.core.PApplet;

class AvailableContribution
extends Contribution {
    protected final ContributionType type;
    protected final String link;

    public AvailableContribution(ContributionType type, HashMap<String, String> params) {
        this.type = type;
        this.link = params.get("download");
        this.categories = AvailableContribution.parseCategories(params.get("category"));
        this.name = params.get("name");
        this.authorList = params.get("authorList");
        this.url = params.get("url");
        this.sentence = params.get("sentence");
        this.paragraph = params.get("paragraph");
        String versionStr = params.get("version");
        if (versionStr != null) {
            this.version = PApplet.parseInt((String)versionStr, (int)0);
        }
        this.prettyVersion = params.get("prettyVersion");
    }

    public LocalContribution install(Editor editor, File contribArchive, boolean confirmReplace, StatusPanel status) {
        File tempFolder = null;
        try {
            tempFolder = this.type.createTempFolder();
        }
        catch (IOException iOException) {
            status.setErrorMessage("Could not create a temporary folder to install.");
            return null;
        }
        Base.unzip(contribArchive, tempFolder);
        File contribFolder = null;
        if (this.type.isCandidate(tempFolder)) {
            status.setErrorMessage(String.valueOf(this.getName()) + " needs to be repackaged according to the " + this.type.getTitle() + " guidelines.");
            return null;
        }
        contribFolder = this.type.findCandidate(tempFolder);
        LocalContribution installedContrib = null;
        if (contribFolder == null) {
            status.setErrorMessage("Could not find a " + (Object)((Object)this.type) + " in the downloaded file.");
        } else {
            File propFile = new File(contribFolder, (Object)((Object)this.type) + ".properties");
            if (this.writePropertiesFile(propFile)) {
                LocalContribution newContrib = this.type.load(editor.getBase(), contribFolder);
                File newContribFolder = newContrib.getFolder();
                installedContrib = newContrib.copyAndLoad(editor, confirmReplace, status);
                if (newContrib != null && this.type.requiresRestart()) {
                    installedContrib.setRestartFlag();
                }
                newContrib = null;
                System.gc();
                if (Base.isWindows()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Base.removeDir(newContribFolder);
            } else {
                status.setErrorMessage("Error overwriting .properties file.");
            }
        }
        if (tempFolder.exists()) {
            Base.removeDir(tempFolder);
        }
        return installedContrib;
    }

    @Override
    public boolean isInstalled() {
        return false;
    }

    @Override
    public ContributionType getType() {
        return this.type;
    }

    public boolean writePropertiesFile(File propFile) {
        try {
            if (propFile.delete() && propFile.createNewFile() && propFile.setWritable(true)) {
                PrintWriter writer = PApplet.createWriter((File)propFile);
                writer.println("name=" + this.getName());
                writer.println("category=" + this.getCategoryStr());
                writer.println("authorList=" + this.getAuthorList());
                writer.println("url=" + this.getUrl());
                writer.println("sentence=" + this.getSentence());
                writer.println("paragraph=" + this.getParagraph());
                writer.println("version=" + this.getVersion());
                writer.println("prettyVersion=" + this.getPrettyVersion());
                writer.flush();
                writer.close();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

