/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListPanel;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.JProgressMonitor;
import processing.app.contrib.LocalContribution;

class ContributionPanel
extends JPanel {
    public static final String REMOVE_RESTART_MESSAGE = "<i>Please restart Processing to finish removing this item.</i>";
    public static final String INSTALL_RESTART_MESSAGE = "<i>Please restart Processing to finish installing this item.</i>";
    private final ContributionListPanel listPanel;
    private final ContributionListing contribListing = ContributionListing.getInstance();
    private static final int BUTTON_WIDTH = 100;
    private Contribution contrib;
    private boolean alreadySelected;
    private boolean enableHyperlinks;
    private HyperlinkListener conditionalHyperlinkOpener;
    private JTextPane descriptionBlock;
    private JLabel notificationBlock;
    private JButton updateButton;
    private JProgressBar installProgressBar;
    private JButton installRemoveButton;
    private JPopupMenu contextMenu;
    private JMenuItem openFolder;
    private ActionListener removeActionListener;
    private ActionListener installActionListener;
    private ActionListener undoActionListener;

    ContributionPanel(ContributionListPanel contributionListPanel) {
        this.listPanel = contributionListPanel;
        this.enableHyperlinks = false;
        this.alreadySelected = false;
        this.conditionalHyperlinkOpener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && ContributionPanel.this.enableHyperlinks && e.getURL() != null) {
                    Base.openURL(e.getURL().toString());
                }
            }
        };
        this.installActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContributionPanel.this.contrib instanceof AvailableContribution) {
                    ContributionPanel.this.installContribution((AvailableContribution)ContributionPanel.this.contrib);
                    ContributionPanel.this.contribListing.replaceContribution(ContributionPanel.this.contrib, ContributionPanel.this.contrib);
                }
            }
        };
        this.undoActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContributionPanel.this.contrib instanceof LocalContribution) {
                    LocalContribution installed = (LocalContribution)ContributionPanel.this.contrib;
                    installed.setDeletionFlag(false);
                    ContributionPanel.this.contribListing.replaceContribution(ContributionPanel.this.contrib, ContributionPanel.this.contrib);
                }
            }
        };
        this.removeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg) {
                if (ContributionPanel.this.contrib.isInstalled() && ContributionPanel.this.contrib instanceof LocalContribution) {
                    ContributionPanel.this.updateButton.setEnabled(false);
                    ContributionPanel.this.installRemoveButton.setEnabled(false);
                    ContributionPanel.this.installProgressBar.setVisible(true);
                    ContributionPanel.this.installProgressBar.setIndeterminate(true);
                    ((LocalContribution)ContributionPanel.this.contrib).removeContribution(((ContributionPanel)ContributionPanel.this).listPanel.contribManager.editor, new JProgressMonitor(ContributionPanel.this.installProgressBar){

                        @Override
                        public void finishedAction() {
                            ContributionPanel.this.resetInstallProgressBarState();
                            ContributionPanel.this.installRemoveButton.setEnabled(true);
                        }
                    }, ((ContributionPanel)ContributionPanel.this).listPanel.contribManager.status);
                }
            }
        };
        this.contextMenu = new JPopupMenu();
        this.openFolder = new JMenuItem("Open Folder");
        this.openFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContributionPanel.this.contrib instanceof LocalContribution) {
                    File folder = ((LocalContribution)ContributionPanel.this.contrib).getFolder();
                    Base.openFolder(folder);
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.addPaneComponents();
        this.setBackground(this.listPanel.getBackground());
        this.setOpaque(true);
        this.setSelected(false);
        this.setExpandListener(this, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ContributionPanel.this.listPanel.setSelectedPanel(ContributionPanel.this);
            }
        });
    }

    private void addPaneComponents() {
        this.setLayout(new BorderLayout());
        this.descriptionBlock = new JTextPane();
        this.descriptionBlock.setInheritsPopupMenu(true);
        Insets margin = this.descriptionBlock.getMargin();
        margin.bottom = 0;
        this.descriptionBlock.setMargin(margin);
        this.descriptionBlock.setContentType("text/html");
        ContributionPanel.setTextStyle(this.descriptionBlock);
        this.descriptionBlock.setOpaque(false);
        this.descriptionBlock.setBorder(new EmptyBorder(4, 7, 7, 7));
        this.descriptionBlock.setHighlighter(null);
        this.add((Component)this.descriptionBlock, "Center");
        Box updateBox = Box.createHorizontalBox();
        this.notificationBlock = new JLabel();
        this.notificationBlock.setInheritsPopupMenu(true);
        this.notificationBlock.setVisible(false);
        this.notificationBlock.setOpaque(false);
        this.notificationBlock.setFont(new Font("Verdana", 2, 10));
        this.updateButton = new JButton("Update");
        this.updateButton.setInheritsPopupMenu(true);
        Dimension updateButtonDimensions = this.updateButton.getPreferredSize();
        updateButtonDimensions.width = 100;
        this.updateButton.setMinimumSize(updateButtonDimensions);
        this.updateButton.setPreferredSize(updateButtonDimensions);
        this.updateButton.setOpaque(false);
        this.updateButton.setVisible(false);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionPanel.this.updateButton.setEnabled(false);
                AvailableContribution ad = ContributionPanel.this.contribListing.getAvailableContribution(ContributionPanel.this.contrib);
                String url = ad.link;
                ContributionPanel.this.installContribution(ad, url);
            }
        });
        updateBox.add(this.updateButton);
        updateBox.add(this.notificationBlock);
        updateBox.setBorder(new EmptyBorder(4, 7, 7, 7));
        this.add((Component)updateBox, "South");
        JPanel rightPane = new JPanel();
        rightPane.setInheritsPopupMenu(true);
        rightPane.setOpaque(false);
        rightPane.setLayout(new BoxLayout(rightPane, 1));
        rightPane.setMinimumSize(new Dimension(100, 1));
        this.add((Component)rightPane, "East");
        this.installProgressBar = new JProgressBar();
        this.installProgressBar.setInheritsPopupMenu(true);
        this.installProgressBar.setStringPainted(true);
        this.resetInstallProgressBarState();
        Dimension d = this.installProgressBar.getPreferredSize();
        d.width = 100;
        this.installProgressBar.setPreferredSize(d);
        this.installProgressBar.setMaximumSize(d);
        this.installProgressBar.setMinimumSize(d);
        this.installProgressBar.setOpaque(false);
        rightPane.add(this.installProgressBar);
        this.installProgressBar.setAlignmentX(0.5f);
        rightPane.add(Box.createVerticalGlue());
        this.installRemoveButton = new JButton(" ");
        this.installRemoveButton.setInheritsPopupMenu(true);
        Dimension installButtonDimensions = this.installRemoveButton.getPreferredSize();
        installButtonDimensions.width = 100;
        this.installRemoveButton.setPreferredSize(installButtonDimensions);
        this.installRemoveButton.setMaximumSize(installButtonDimensions);
        this.installRemoveButton.setMinimumSize(installButtonDimensions);
        this.installRemoveButton.setOpaque(false);
        rightPane.add(this.installRemoveButton);
        this.installRemoveButton.setAlignmentX(0.5f);
        d = this.installProgressBar.getPreferredSize();
        Dimension d2 = this.installRemoveButton.getPreferredSize();
        d.width = 100;
        d.height += d2.height;
        rightPane.setMinimumSize(d);
        rightPane.setPreferredSize(d);
    }

    private void setExpandListener(Component component, MouseAdapter expandPanelMouseListener) {
        component.addMouseListener(expandPanelMouseListener);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                this.setExpandListener(child, expandPanelMouseListener);
                ++n2;
            }
        }
    }

    public void setContribution(Contribution contrib) {
        this.contrib = contrib;
        StringBuilder description = new StringBuilder();
        description.append("<html><body><b>");
        if (contrib.getUrl() == null) {
            description.append(contrib.getName());
        } else {
            description.append("<a href=\"" + contrib.getUrl() + "\">" + contrib.getName() + "</a>");
        }
        description.append("</b>");
        String authorList = contrib.getAuthorList();
        if (authorList != null && !authorList.isEmpty()) {
            description.append(" by ");
            description.append(ContributionPanel.toHtmlLinks(contrib.getAuthorList()));
        }
        description.append("<br/>");
        if (contrib.isDeletionFlagged()) {
            description.append(REMOVE_RESTART_MESSAGE);
        } else if (contrib.isRestartFlagged()) {
            description.append(INSTALL_RESTART_MESSAGE);
        } else {
            String sentence = contrib.getSentence();
            if (sentence == null || sentence.isEmpty()) {
                sentence = "<i>Description unavailable.</i>";
            } else {
                sentence = ContributionPanel.sanitizeHtmlTags(sentence);
                sentence = ContributionPanel.toHtmlLinks(sentence);
            }
            description.append(sentence);
        }
        description.append("</body></html>");
        this.descriptionBlock.setText(description.toString());
        if (this.contribListing.hasUpdates(contrib)) {
            StringBuilder versionText = new StringBuilder();
            versionText.append("<html><body><i>");
            if (contrib.isDeletionFlagged()) {
                versionText.append("To finish an update, reinstall this contribution after restarting.");
            } else {
                versionText.append("New version available!");
                if (contrib.getType().requiresRestart()) {
                    versionText.append(" To update, first remove the current version.");
                }
            }
            versionText.append("</i></body></html>");
            this.notificationBlock.setText(versionText.toString());
            this.notificationBlock.setVisible(true);
        } else {
            this.notificationBlock.setText("");
            this.notificationBlock.setVisible(false);
        }
        this.updateButton.setEnabled(true);
        if (contrib != null && !contrib.getType().requiresRestart()) {
            this.updateButton.setVisible(this.isSelected() && this.contribListing.hasUpdates(contrib));
        }
        this.installRemoveButton.removeActionListener(this.installActionListener);
        this.installRemoveButton.removeActionListener(this.removeActionListener);
        this.installRemoveButton.removeActionListener(this.undoActionListener);
        if (contrib.isDeletionFlagged()) {
            this.installRemoveButton.addActionListener(this.undoActionListener);
            this.installRemoveButton.setText("Undo");
        } else if (contrib.isInstalled()) {
            this.installRemoveButton.addActionListener(this.removeActionListener);
            this.installRemoveButton.setText("Remove");
            this.installRemoveButton.setVisible(true);
        } else {
            this.installRemoveButton.addActionListener(this.installActionListener);
            this.installRemoveButton.setText("Install");
        }
        this.contextMenu.removeAll();
        if (contrib.isInstalled()) {
            this.contextMenu.add(this.openFolder);
            this.setComponentPopupMenu(this.contextMenu);
        } else {
            this.setComponentPopupMenu(null);
        }
    }

    private void installContribution(AvailableContribution info) {
        if (info.link == null) {
            this.listPanel.contribManager.status.setErrorMessage("Your operating system doesn't appear to be supported. You should visit the " + (Object)((Object)info.getType()) + "'s library for more info.");
        } else {
            this.installContribution(info, info.link);
        }
    }

    private void installContribution(AvailableContribution ad, String url) {
        this.installRemoveButton.setEnabled(false);
        try {
            URL downloadUrl = new URL(url);
            this.installProgressBar.setVisible(true);
            JProgressMonitor downloadProgress = new JProgressMonitor(this.installProgressBar){

                @Override
                public void finishedAction() {
                }
            };
            JProgressMonitor installProgress = new JProgressMonitor(this.installProgressBar){

                @Override
                public void finishedAction() {
                    ContributionPanel.this.resetInstallProgressBarState();
                    ContributionPanel.this.installRemoveButton.setEnabled(true);
                    if (this.isError()) {
                        ((ContributionPanel)ContributionPanel.this).listPanel.contribManager.status.setErrorMessage("An error occured while downloading the contribution.");
                    }
                }
            };
            ContributionManager.downloadAndInstall(this.listPanel.contribManager.editor, downloadUrl, ad, downloadProgress, installProgress, this.listPanel.contribManager.status);
        }
        catch (MalformedURLException e) {
            Base.showWarning("Install Failed", "The link fetched from Processing.org is not valid.\nYou can still install this library manually by visiting\nthe library's website.", e);
        }
    }

    protected void resetInstallProgressBarState() {
        this.installProgressBar.setString("Starting");
        this.installProgressBar.setIndeterminate(false);
        this.installProgressBar.setValue(0);
        this.installProgressBar.setVisible(false);
    }

    public void setSelected(boolean isSelected) {
        this.enableHyperlinks = this.alreadySelected;
        if (this.contrib != null && !this.contrib.getType().requiresRestart()) {
            this.updateButton.setVisible(this.isSelected() && this.contribListing.hasUpdates(this.contrib));
        }
        this.installRemoveButton.setVisible(this.isSelected() || this.installRemoveButton.getText().equals("Remove"));
        JTextPane editorPane = this.descriptionBlock;
        editorPane.removeHyperlinkListener(ContributionListPanel.nullHyperlinkListener);
        editorPane.removeHyperlinkListener(this.conditionalHyperlinkOpener);
        if (this.isSelected()) {
            editorPane.addHyperlinkListener(this.conditionalHyperlinkOpener);
            editorPane.setEditable(false);
        } else {
            editorPane.addHyperlinkListener(ContributionListPanel.nullHyperlinkListener);
            editorPane.setEditable(true);
        }
        ContributionPanel.setSelectionStyle(this.descriptionBlock, this.isSelected());
        this.alreadySelected = this.isSelected();
    }

    public boolean isSelected() {
        return this.listPanel.getSelectedPanel() == this;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.contrib != null) {
            boolean installed = this.contrib.isInstalled();
            ContributionPanel.setForegroundStyle(this.descriptionBlock, installed, this.isSelected());
        }
    }

    static String sanitizeHtmlTags(String stringIn) {
        stringIn = stringIn.replaceAll("<", "&lt;");
        stringIn = stringIn.replaceAll(">", "&gt;");
        return stringIn;
    }

    static String toHtmlLinks(String stringIn) {
        Pattern p = Pattern.compile("\\[(.*?)\\]\\((.*?)\\)");
        Matcher m = p.matcher(stringIn);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (m.find(start)) {
            sb.append(stringIn.substring(start, m.start()));
            String text = m.group(1);
            String url = m.group(2);
            sb.append("<a href=\"");
            sb.append(url);
            sb.append("\">");
            sb.append(text);
            sb.append("</a>");
            start = m.end();
        }
        sb.append(stringIn.substring(start));
        return sb.toString();
    }

    static void setForegroundStyle(JTextPane textPane, boolean installed, boolean selected) {
        Document doc = textPane.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            String c = installed && !selected ? "#555555" : "#000000";
            stylesheet.addRule("body { color:" + c + "; }");
            stylesheet.addRule("a { color:" + c + "; }");
        }
    }

    static void setTextStyle(JTextPane textPane) {
        Document doc = textPane.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            stylesheet.addRule("body {   margin: 0; padding: 0;  font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;  font-size: 100%;font-size: 0.95em; }");
        }
    }

    static void setSelectionStyle(JTextPane textPane, boolean selected) {
        Document doc = textPane.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet styleSheet = html.getStyleSheet();
            if (selected) {
                styleSheet.addRule("a { text-decoration:underline } ");
            } else {
                styleSheet.addRule("a { text-decoration:none }");
            }
        }
    }
}

