/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.util.ArrayList;
import processing.app.Base;
import processing.app.Editor;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.app.tools.Tool;

public class ToolContribution
extends LocalContribution
implements Tool {
    private Tool tool;

    public static ToolContribution load(File folder) {
        try {
            return new ToolContribution(folder);
        }
        catch (LocalContribution.IgnorableException ig) {
            Base.log(ig.getMessage());
        }
        catch (Error err) {
            err.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private ToolContribution(File folder) throws Exception {
        super(folder);
        String className = this.initLoader(null);
        if (className != null) {
            Class<?> toolClass = this.loader.loadClass(className);
            this.tool = (Tool)toolClass.newInstance();
        }
    }

    public static ArrayList<ToolContribution> loadAll(File toolsFolder) {
        File[] list = ContributionType.TOOL.listCandidates(toolsFolder);
        ArrayList<ToolContribution> outgoing = new ArrayList<ToolContribution>();
        if (list != null) {
            File[] fileArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                try {
                    ToolContribution tc = ToolContribution.load(folder);
                    if (tc != null) {
                        outgoing.add(tc);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return outgoing;
    }

    @Override
    public void init(Editor editor) {
        this.tool.init(editor);
    }

    @Override
    public void run() {
        this.tool.run();
    }

    @Override
    public String getMenuTitle() {
        return this.tool.getMenuTitle();
    }

    @Override
    public ContributionType getType() {
        return ContributionType.TOOL;
    }
}

