/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import javax.swing.text.Segment;
import processing.app.Editor;
import processing.app.syntax.KeywordMap;
import processing.app.syntax.TokenMarker;

public class PdeKeywords
extends TokenMarker {
    private KeywordMap keywordColoring;
    private int lastOffset;
    private int lastKeyword;

    @Override
    public void addColoring(String keyword, String coloring) {
        if (this.keywordColoring == null) {
            this.keywordColoring = new KeywordMap(false);
        }
        int num = coloring.charAt(coloring.length() - 1) - 49;
        int id = 0;
        boolean paren = false;
        switch (coloring.charAt(0)) {
            case 'K': {
                id = 6 + num;
                break;
            }
            case 'L': {
                id = 3 + num;
                break;
            }
            case 'F': {
                id = 11 + num;
                paren = true;
            }
        }
        this.keywordColoring.add(keyword, (byte)id, paren);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int mlength = offset + line.count;
        boolean backslash = false;
        int i = offset;
        block21: while (i < mlength) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (token) {
                    case 0: {
                        switch (c) {
                            case '#': {
                                if (!backslash) break block0;
                                backslash = false;
                                break;
                            }
                            case '\"': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)3;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '\'': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)4;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case ':': {
                                if (this.lastKeyword == offset) {
                                    if (this.doKeyword(line, i, c)) break block0;
                                    backslash = false;
                                    this.addToken(i1 - this.lastOffset, (byte)5);
                                    this.lastOffset = this.lastKeyword = i1;
                                    break;
                                }
                                if (!this.doKeyword(line, i, c)) break block0;
                                break;
                            }
                            case '/': {
                                backslash = false;
                                this.doKeyword(line, i, c);
                                if (mlength - i <= 1) break block0;
                                switch (array[i1]) {
                                    case '*': {
                                        this.addToken(i - this.lastOffset, token);
                                        this.lastOffset = this.lastKeyword = i;
                                        if (mlength - i > 2 && array[i + 2] == '*') {
                                            token = (byte)2;
                                            break;
                                        }
                                        token = 1;
                                        break;
                                    }
                                    case '/': {
                                        this.addToken(i - this.lastOffset, token);
                                        this.addToken(mlength - i, (byte)1);
                                        this.lastOffset = this.lastKeyword = mlength;
                                        break block21;
                                    }
                                }
                                if (array[i1] == ' ') break block0;
                                ++i;
                                break;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_') break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        backslash = false;
                        if (c != '*' || mlength - i <= 1 || array[i1] != '/') break;
                        this.addToken(++i + 1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i + 1;
                        break;
                    }
                    case 3: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(i1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token);
                    }
                }
            }
            ++i;
        }
        if (token == 0) {
            this.doKeyword(line, mlength, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(mlength - this.lastOffset, (byte)16);
                return 0;
            }
            case 7: {
                this.addToken(mlength - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
                this.addToken(mlength - this.lastOffset, token);
                return token;
            }
        }
        this.addToken(mlength - this.lastOffset, token);
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        boolean paren = Editor.checkParen(line.array, i, line.array.length);
        byte id = this.keywordColoring.lookup(line, this.lastKeyword, len, paren);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

