/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import processing.app.Base;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.syntax.DefaultInputHandler;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;

public class PdeTextAreaDefaults
extends TextAreaDefaults {
    public PdeTextAreaDefaults(Mode mode) {
        this.inputHandler = new DefaultInputHandler();
        String mod = Base.isMacOS() ? "A" : "C";
        this.inputHandler.addKeyBinding("BACK_SPACE", InputHandler.BACKSPACE);
        if (Preferences.getBoolean("editor.keys.shift_backspace_is_delete")) {
            this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.DELETE);
        } else {
            this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.BACKSPACE);
        }
        this.inputHandler.addKeyBinding("DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "S+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+DELETE", InputHandler.DELETE_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "S+DELETE", InputHandler.DELETE_WORD);
        this.inputHandler.addKeyBinding("INSERT", InputHandler.OVERWRITE);
        if (Preferences.getBoolean("editor.keys.alternative_cut_copy_paste")) {
            this.inputHandler.addKeyBinding("C+INSERT", InputHandler.CLIPBOARD_COPY);
            this.inputHandler.addKeyBinding("S+INSERT", InputHandler.CLIPBOARD_PASTE);
            this.inputHandler.addKeyBinding("S+DELETE", InputHandler.CLIPBOARD_CUT);
        }
        if (Preferences.getBoolean("editor.keys.home_and_end_travel_far")) {
            this.inputHandler.addKeyBinding("HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_DOC_END);
        } else {
            this.inputHandler.addKeyBinding("HOME", InputHandler.HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_END);
            this.inputHandler.addKeyBinding("C+HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("C+END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_DOC_END);
        }
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("C+A", InputHandler.HOME);
            this.inputHandler.addKeyBinding("CS+A", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("C+E", InputHandler.END);
            this.inputHandler.addKeyBinding("CS+E", InputHandler.SELECT_END);
            this.inputHandler.addKeyBinding("C+D", InputHandler.DELETE);
            this.inputHandler.addKeyBinding("C+B", InputHandler.PREV_CHAR);
            this.inputHandler.addKeyBinding("CS+B", InputHandler.SELECT_PREV_CHAR);
            this.inputHandler.addKeyBinding("C+F", InputHandler.NEXT_CHAR);
            this.inputHandler.addKeyBinding("CS+F", InputHandler.SELECT_NEXT_CHAR);
            this.inputHandler.addKeyBinding("C+H", InputHandler.BACKSPACE);
            this.inputHandler.addKeyBinding("C+N", InputHandler.NEXT_LINE);
            this.inputHandler.addKeyBinding("CS+N", InputHandler.SELECT_NEXT_LINE);
            this.inputHandler.addKeyBinding("C+P", InputHandler.PREV_LINE);
            this.inputHandler.addKeyBinding("CS+P", InputHandler.SELECT_PREV_LINE);
        }
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("M+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("M+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("MS+LEFT", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("MS+RIGHT", InputHandler.SELECT_END);
        } else {
            this.inputHandler.addKeyBinding("C+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("C+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_END);
        }
        this.inputHandler.addKeyBinding("PAGE_UP", InputHandler.PREV_PAGE);
        this.inputHandler.addKeyBinding("PAGE_DOWN", InputHandler.NEXT_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_UP", InputHandler.SELECT_PREV_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_DOWN", InputHandler.SELECT_NEXT_PAGE);
        this.inputHandler.addKeyBinding("LEFT", InputHandler.PREV_CHAR);
        this.inputHandler.addKeyBinding("S+LEFT", InputHandler.SELECT_PREV_CHAR);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+LEFT", InputHandler.PREV_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "S+LEFT", InputHandler.SELECT_PREV_WORD);
        this.inputHandler.addKeyBinding("RIGHT", InputHandler.NEXT_CHAR);
        this.inputHandler.addKeyBinding("S+RIGHT", InputHandler.SELECT_NEXT_CHAR);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+RIGHT", InputHandler.NEXT_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "S+RIGHT", InputHandler.SELECT_NEXT_WORD);
        this.inputHandler.addKeyBinding("UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding("S+UP", InputHandler.SELECT_PREV_LINE);
        this.inputHandler.addKeyBinding("DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding("S+DOWN", InputHandler.SELECT_NEXT_LINE);
        this.inputHandler.addKeyBinding("MS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("CS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("MS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding("CS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+ENTER", InputHandler.REPEAT);
        this.document = new SyntaxDocument();
        this.electricScroll = 0;
        this.caretVisible = true;
        this.caretBlinks = Preferences.getBoolean("editor.caret.blink");
        this.blockCaret = Preferences.getBoolean("editor.caret.block");
        this.cols = 80;
        this.rows = 5;
        this.fgcolor = mode.getColor("editor.fgcolor");
        this.bgcolor = mode.getColor("editor.bgcolor");
        this.styles = new SyntaxStyle[17];
        this.styles[1] = mode.getStyle("comment1");
        this.styles[2] = mode.getStyle("comment2");
        this.styles[6] = mode.getStyle("keyword1");
        this.styles[7] = mode.getStyle("keyword2");
        this.styles[8] = mode.getStyle("keyword3");
        this.styles[9] = mode.getStyle("keyword4");
        this.styles[10] = mode.getStyle("keyword5");
        this.styles[11] = mode.getStyle("function1");
        this.styles[12] = mode.getStyle("function2");
        this.styles[13] = mode.getStyle("function3");
        this.styles[14] = mode.getStyle("function4");
        this.styles[3] = mode.getStyle("literal1");
        this.styles[4] = mode.getStyle("literal2");
        this.styles[5] = mode.getStyle("label");
        this.styles[15] = mode.getStyle("operator");
        this.styles[16] = mode.getStyle("invalid");
        this.caretColor = mode.getColor("editor.caret.color");
        this.selectionColor = mode.getColor("editor.selection.color");
        this.lineHighlight = mode.getBoolean("editor.linehighlight");
        this.lineHighlightColor = mode.getColor("editor.linehighlight.color");
        this.bracketHighlight = mode.getBoolean("editor.brackethighlight");
        this.bracketHighlightColor = mode.getColor("editor.brackethighlight.color");
        this.eolMarkers = mode.getBoolean("editor.eolmarkers");
        this.eolMarkerColor = mode.getColor("editor.eolmarkers.color");
    }
}

