/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.util.Stack;
import java.util.regex.Pattern;
import processing.app.Formatter;
import processing.app.Preferences;
import processing.core.PApplet;

public class AutoFormat
implements Formatter {
    private char[] chars;
    private final StringBuilder buf = new StringBuilder();
    private final StringBuilder result = new StringBuilder();
    private int indentValue;
    private boolean EOF;
    private boolean a_flg;
    private boolean if_flg;
    private boolean s_flag;
    private boolean elseFlag;
    private int conditionalLevel;
    private int pos;
    private int c_level;
    private int[][] sp_flg;
    private int[][] s_ind;
    private int if_lev;
    private int level;
    private int parenLevel;
    private int[] ind;
    private int[] p_flg;
    private char l_char;
    private int[][] s_tabs;
    private boolean jdoc_flag;
    private char cc;
    private int tabs;
    private char c;
    private char lastNonWhitespace = '\u0000';
    private final Stack<Boolean> castFlags = new Stack();

    private void handleMultiLineComment() {
        boolean saved_s_flag = this.s_flag;
        char ch = this.nextChar();
        this.buf.append(ch);
        do {
            ch = this.nextChar();
            this.buf.append(ch);
            while (ch != '/') {
                if (ch == '\n') {
                    this.writeIndentedComment();
                    this.s_flag = true;
                }
                ch = this.nextChar();
                this.buf.append(ch);
            }
        } while (this.buf.length() < 2 || this.buf.charAt(this.buf.length() - 2) != '*');
        this.jdoc_flag = false;
        this.writeIndentedComment();
        this.s_flag = saved_s_flag;
        this.jdoc_flag = false;
    }

    private void handleSingleLineComment() {
        char ch = this.nextChar();
        while (ch != '\n') {
            this.buf.append(ch);
            ch = this.nextChar();
        }
        this.writeIndentedLine();
        this.s_flag = true;
    }

    private void writeIndentedLine() {
        if (this.buf.length() == 0) {
            if (this.s_flag) {
                this.elseFlag = false;
                this.a_flg = false;
                this.s_flag = false;
            }
            return;
        }
        if (this.s_flag) {
            boolean shouldIndent;
            boolean bl = shouldIndent = this.tabs > 0 && this.buf.charAt(0) != '{' && this.a_flg;
            if (shouldIndent) {
                ++this.tabs;
            }
            this.printIndentation();
            this.s_flag = false;
            if (shouldIndent) {
                --this.tabs;
            }
            this.a_flg = false;
        }
        if (this.elseFlag) {
            if (this.lastNonSpaceChar() == '}') {
                this.trimRight(this.result);
                this.result.append(' ');
            }
            this.elseFlag = false;
        }
        this.result.append((CharSequence)this.buf);
        this.buf.setLength(0);
    }

    private char lastNonSpaceChar() {
        int i = this.result.length() - 1;
        while (i >= 0) {
            char c_i = this.result.charAt(i);
            if (c_i != ' ' && c_i != '\n') {
                return c_i;
            }
            --i;
        }
        return '\u0000';
    }

    private void writeIndentedComment() {
        boolean saved_s_flag = this.s_flag;
        if (this.buf.length() > 0) {
            if (this.s_flag) {
                this.printIndentation();
                this.s_flag = false;
            }
            int i = 0;
            while (this.buf.charAt(i) == ' ') {
                ++i;
            }
            if (this.lookup_com("/**")) {
                this.jdoc_flag = true;
            }
            if (this.buf.charAt(i) == '/' && this.buf.charAt(i + 1) == '*') {
                if (saved_s_flag && this.getLastNonWhitespace() != 59) {
                    this.result.append(this.buf.substring(i));
                } else {
                    this.result.append((CharSequence)this.buf);
                }
            } else if (this.buf.charAt(i) == '*' || !this.jdoc_flag) {
                this.result.append(" " + this.buf.substring(i));
            } else {
                this.result.append(" * " + this.buf.substring(i));
            }
            this.buf.setLength(0);
        }
    }

    private void printIndentation() {
        if (this.tabs < 0) {
            this.tabs = 0;
        }
        if (this.tabs == 0) {
            return;
        }
        int spaces = this.tabs * this.indentValue;
        int k = 0;
        while (k < spaces) {
            this.result.append(' ');
            ++k;
        }
    }

    private char peek() {
        if (this.pos + 1 >= this.chars.length) {
            return '\u0000';
        }
        return this.chars[this.pos + 1];
    }

    private int getLastNonWhitespace() {
        return this.lastNonWhitespace;
    }

    private void advanceToNonSpace() {
        if (this.EOF) {
            return;
        }
        do {
            ++this.pos;
        } while (this.pos < this.chars.length && this.chars[this.pos] == ' ');
        if (this.pos == this.chars.length - 1) {
            this.EOF = true;
        } else {
            --this.pos;
        }
    }

    private char nextChar() {
        char retVal;
        if (this.EOF) {
            return '\u0000';
        }
        ++this.pos;
        if (this.pos < this.chars.length) {
            retVal = this.chars[this.pos];
            if (!Character.isWhitespace(retVal)) {
                this.lastNonWhitespace = retVal;
            }
        } else {
            retVal = '\u0000';
        }
        if (this.pos == this.chars.length - 1) {
            this.EOF = true;
        }
        return retVal;
    }

    private void gotElse() {
        this.tabs = this.s_tabs[this.c_level][this.if_lev];
        this.p_flg[this.level] = this.sp_flg[this.c_level][this.if_lev];
        this.ind[this.level] = this.s_ind[this.c_level][this.if_lev];
        this.if_flg = true;
    }

    private boolean readUntilNewLine() {
        int savedTabs = this.tabs;
        char c = this.peek();
        while (!(this.EOF || c != '\t' && c != ' ')) {
            this.buf.append(this.nextChar());
            c = this.peek();
        }
        if (c == '/') {
            this.buf.append(this.nextChar());
            c = this.peek();
            if (c == '*') {
                this.buf.append(this.nextChar());
                this.handleMultiLineComment();
            } else if (c == '/') {
                this.buf.append(this.nextChar());
                this.handleSingleLineComment();
                return true;
            }
        }
        if ((c = this.peek()) == '\n') {
            this.nextChar();
            this.tabs = savedTabs;
            return true;
        }
        return false;
    }

    private boolean lookup(String keyword) {
        return Pattern.matches("^\\s*" + keyword + "(?![a-zA-Z0-9_&]).*$", this.buf);
    }

    private boolean lookup_com(String keyword) {
        String regex = "^\\s*" + keyword.replaceAll("\\*", "\\\\*") + ".*$";
        return Pattern.matches(regex, this.buf);
    }

    private void trimRight(StringBuilder sb) {
        while (sb.length() >= 1 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.setLength(sb.length() - 1);
        }
    }

    @Override
    public String format(String source) {
        String normalizedText = source.replaceAll("\r", "");
        String cleanText = String.valueOf(normalizedText) + (normalizedText.endsWith("\n") ? "" : "\n");
        this.result.setLength(0);
        this.indentValue = Preferences.getInteger("editor.tabs.size");
        this.if_flg = false;
        this.a_flg = false;
        boolean forFlag = false;
        this.s_flag = true;
        int forParenthLevel = 0;
        this.level = 0;
        this.if_lev = 0;
        this.c_level = 0;
        this.parenLevel = 0;
        this.conditionalLevel = 0;
        this.tabs = 0;
        this.jdoc_flag = false;
        int[] s_level = new int[10];
        this.sp_flg = new int[20][10];
        this.s_ind = new int[20][10];
        int[] s_if_lev = new int[10];
        boolean[] s_if_flg = new boolean[10];
        this.ind = new int[10];
        this.p_flg = new int[10];
        this.s_tabs = new int[20][10];
        this.pos = -1;
        this.chars = cleanText.toCharArray();
        this.EOF = false;
        block15: while (!this.EOF) {
            this.c = this.nextChar();
            switch (this.c) {
                default: {
                    this.buf.append(this.c);
                    this.l_char = this.c;
                    break;
                }
                case ',': {
                    this.trimRight(this.buf);
                    this.buf.append(this.c);
                    this.buf.append(' ');
                    this.advanceToNonSpace();
                    break;
                }
                case '\t': 
                case ' ': {
                    this.elseFlag = this.lookup("else");
                    if (this.elseFlag) {
                        this.gotElse();
                        if (!this.s_flag || this.buf.length() > 0) {
                            this.buf.append(this.c);
                        }
                        this.writeIndentedLine();
                        this.s_flag = false;
                        break;
                    }
                    if (this.s_flag && this.buf.length() <= 0) continue block15;
                    this.buf.append(this.c);
                    break;
                }
                case '\n': {
                    char lastChar;
                    if (this.EOF) continue block15;
                    this.elseFlag = this.lookup("else");
                    if (this.elseFlag) {
                        this.gotElse();
                    }
                    if (this.lookup_com("//") && (lastChar = this.buf.charAt(this.buf.length() - 1)) == '\n') {
                        this.buf.setLength(this.buf.length() - 1);
                    }
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.s_flag = true;
                    if (this.elseFlag) {
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] + 1;
                        ++this.tabs;
                        break;
                    }
                    if (this.getLastNonWhitespace() != this.l_char) continue block15;
                    this.a_flg = true;
                    break;
                }
                case '{': {
                    this.elseFlag = this.lookup("else");
                    if (this.elseFlag) {
                        this.gotElse();
                    }
                    if (s_if_lev.length == this.c_level) {
                        s_if_lev = PApplet.expand((int[])s_if_lev);
                        s_if_flg = PApplet.expand((boolean[])s_if_flg);
                    }
                    s_if_lev[this.c_level] = this.if_lev;
                    s_if_flg[this.c_level] = this.if_flg;
                    this.if_lev = 0;
                    this.if_flg = false;
                    ++this.c_level;
                    if (this.s_flag && this.p_flg[this.level] != 0) {
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] - 1;
                        --this.tabs;
                    }
                    this.trimRight(this.buf);
                    if (this.buf.length() > 0 || this.result.length() > 0 && !Character.isWhitespace(this.result.charAt(this.result.length() - 1))) {
                        this.buf.append(" ");
                    }
                    this.buf.append(this.c);
                    this.writeIndentedLine();
                    this.readUntilNewLine();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    ++this.tabs;
                    this.s_flag = true;
                    if (this.p_flg[this.level] <= 0) continue block15;
                    this.ind[this.level] = 1;
                    ++this.level;
                    s_level[this.level] = this.c_level;
                    break;
                }
                case '}': {
                    --this.c_level;
                    if (this.c_level < 0) {
                        this.c_level = 0;
                        this.buf.append(this.c);
                        this.writeIndentedLine();
                        break;
                    }
                    this.if_lev = s_if_lev[this.c_level] - 1;
                    if (this.if_lev < 0) {
                        this.if_lev = 0;
                    }
                    this.if_flg = s_if_flg[this.c_level];
                    this.trimRight(this.buf);
                    this.writeIndentedLine();
                    --this.tabs;
                    this.trimRight(this.result);
                    this.result.append("\n");
                    this.printIndentation();
                    this.result.append(this.c);
                    if (this.peek() == ';') {
                        this.result.append(this.nextChar());
                    }
                    this.readUntilNewLine();
                    this.writeIndentedLine();
                    this.result.append('\n');
                    this.s_flag = true;
                    if (this.c_level < s_level[this.level] && this.level > 0) {
                        --this.level;
                    }
                    if (this.ind[this.level] == 0) continue block15;
                    this.tabs -= this.p_flg[this.level];
                    this.p_flg[this.level] = 0;
                    this.ind[this.level] = 0;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.buf.append(this.c);
                    this.cc = this.nextChar();
                    while (!this.EOF && this.cc != this.c) {
                        this.buf.append(this.cc);
                        if (this.cc == '\\') {
                            this.cc = this.nextChar();
                            this.buf.append(this.cc);
                        }
                        if (this.cc == '\n') {
                            this.writeIndentedLine();
                            this.s_flag = true;
                        }
                        this.cc = this.nextChar();
                    }
                    this.buf.append(this.cc);
                    if (!this.readUntilNewLine()) continue block15;
                    this.l_char = this.cc;
                    this.chars[this.pos--] = 10;
                    break;
                }
                case ';': {
                    if (forFlag) {
                        this.trimRight(this.buf);
                        this.buf.append("; ");
                        this.advanceToNonSpace();
                        break;
                    }
                    this.buf.append(this.c);
                    this.writeIndentedLine();
                    if (this.p_flg[this.level] > 0 && this.ind[this.level] == 0) {
                        this.tabs -= this.p_flg[this.level];
                        this.p_flg[this.level] = 0;
                    }
                    this.readUntilNewLine();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.s_flag = true;
                    if (this.if_lev <= 0) continue block15;
                    if (this.if_flg) {
                        --this.if_lev;
                        this.if_flg = false;
                        break;
                    }
                    this.if_lev = 0;
                    break;
                }
                case '\\': {
                    this.buf.append(this.c);
                    this.buf.append(this.nextChar());
                    break;
                }
                case '?': {
                    ++this.conditionalLevel;
                    this.buf.append(this.c);
                    break;
                }
                case ':': {
                    if (this.peek() == ':') {
                        this.writeIndentedLine();
                        this.result.append(this.c).append(this.nextChar());
                        break;
                    }
                    if (this.conditionalLevel > 0) {
                        --this.conditionalLevel;
                        this.buf.append(this.c);
                        break;
                    }
                    if (forFlag) {
                        this.trimRight(this.buf);
                        this.buf.append(" : ");
                        this.advanceToNonSpace();
                        break;
                    }
                    this.buf.append(this.c);
                    if (!this.lookup("default") && !this.lookup("case")) {
                        this.s_flag = false;
                        this.writeIndentedLine();
                    } else {
                        --this.tabs;
                        this.writeIndentedLine();
                        ++this.tabs;
                    }
                    if (this.peek() == ';') {
                        this.result.append(this.nextChar());
                    }
                    this.readUntilNewLine();
                    this.writeIndentedLine();
                    this.result.append('\n');
                    this.s_flag = true;
                    break;
                }
                case '/': {
                    char next = this.peek();
                    if (next == '/') {
                        this.buf.append(this.c).append(this.nextChar());
                        this.handleSingleLineComment();
                        this.result.append("\n");
                        break;
                    }
                    if (next == '*') {
                        if (this.buf.length() > 0) {
                            this.writeIndentedLine();
                        }
                        this.buf.append(this.c).append(this.nextChar());
                        this.handleMultiLineComment();
                        break;
                    }
                    this.buf.append(this.c);
                    break;
                }
                case ')': {
                    boolean isCast = this.castFlags.isEmpty() ? false : this.castFlags.pop();
                    --this.parenLevel;
                    if (forFlag && forParenthLevel > this.parenLevel) {
                        forFlag = false;
                    }
                    if (this.parenLevel < 0) {
                        this.parenLevel = 0;
                    }
                    this.buf.append(this.c);
                    this.writeIndentedLine();
                    if (!this.readUntilNewLine()) continue block15;
                    this.chars[this.pos--] = 10;
                    if (this.parenLevel != 0) {
                        this.a_flg = true;
                        break;
                    }
                    if (this.tabs <= 0 || isCast) continue block15;
                    int n = this.level;
                    this.p_flg[n] = this.p_flg[n] + 1;
                    ++this.tabs;
                    this.ind[this.level] = 0;
                    break;
                }
                case '(': {
                    this.castFlags.push(Pattern.matches("^.*?(?:int|color|float)\\s*$", this.buf));
                    boolean isFor = this.lookup("for");
                    boolean isIf = this.lookup("if");
                    if ((isFor || isIf || this.lookup("while")) && !Character.isWhitespace(this.buf.charAt(this.buf.length() - 1))) {
                        this.buf.append(' ');
                    }
                    this.buf.append(this.c);
                    ++this.parenLevel;
                    if (isFor) {
                        if (forFlag) continue block15;
                        forParenthLevel = this.parenLevel;
                        forFlag = true;
                        break;
                    }
                    if (!isIf) continue block15;
                    this.writeIndentedLine();
                    this.s_tabs[this.c_level][this.if_lev] = this.tabs;
                    this.sp_flg[this.c_level][this.if_lev] = this.p_flg[this.level];
                    this.s_ind[this.c_level][this.if_lev] = this.ind[this.level];
                    ++this.if_lev;
                    this.if_flg = true;
                }
            }
        }
        String formatted = this.result.toString();
        return formatted.equals(cleanText) ? source : formatted;
    }
}

