/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.exec.ProcessHelper;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.data.XML;
import processing.mode.java.Compiler;
import processing.mode.java.preproc.PdePreprocessor;

public class JavaBuild {
    public static final String PACKAGE_REGEX = "(?:^|\\s|;)package\\s+(\\S+)\\;";
    protected Sketch sketch;
    protected Mode mode;
    protected File srcFolder;
    protected File binFolder;
    private boolean foundMain = false;
    private String classPath;
    protected String sketchClassName;
    private String javaLibraryPath;
    private ArrayList<Library> importedLibraries;

    public JavaBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public String build(boolean sizeWarning) throws SketchException {
        return this.build(this.sketch.makeTempFolder(), this.sketch.makeTempFolder(), sizeWarning);
    }

    public String build(File srcFolder, File binFolder, boolean sizeWarning) throws SketchException {
        this.srcFolder = srcFolder;
        this.binFolder = binFolder;
        String classNameFound = this.preprocess(srcFolder, sizeWarning);
        if (Compiler.compile(this)) {
            this.sketchClassName = classNameFound;
            return classNameFound;
        }
        return null;
    }

    public String getSketchClassName() {
        return this.sketchClassName;
    }

    public String preprocess(File srcFolder, boolean sizeWarning) throws SketchException {
        return this.preprocess(srcFolder, null, new PdePreprocessor(this.sketch.getName()), sizeWarning);
    }

    /*
     * Unable to fully structure code
     */
    public String preprocess(File srcFolder, String packageName, PdePreprocessor preprocessor, boolean sizeWarning) throws SketchException {
        block39: {
            block40: {
                this.sketch.ensureExistence();
                this.classPath = this.binFolder.getAbsolutePath();
                codeFolderPackages = null;
                if (this.sketch.hasCodeFolder()) {
                    codeFolder = this.sketch.getCodeFolder();
                    this.javaLibraryPath = codeFolder.getAbsolutePath();
                    codeFolderClassPath = Base.contentsToClassPath(codeFolder);
                    this.classPath = String.valueOf(this.classPath) + File.pathSeparator + codeFolderClassPath;
                    codeFolderPackages = Base.packageListFromClassPath(codeFolderClassPath);
                } else {
                    this.javaLibraryPath = "";
                }
                bigCode = new StringBuffer();
                bigCount = 0;
                var11_9 = this.sketch.getCode();
                var10_11 = var11_9.length;
                var9_15 = 0;
                while (var9_15 < var10_11) {
                    sc = var11_9[var9_15];
                    if (sc.isExtension("pde")) {
                        sc.setPreprocOffset(bigCount);
                        bigCode.append(sc.getProgram());
                        bigCode.append('\n');
                        bigCount += sc.getLineCount();
                    }
                    ++var9_15;
                }
                try {
                    outputFolder = packageName == null ? srcFolder : new File(srcFolder, packageName.replace('.', '/'));
                    outputFolder.mkdirs();
                    java = new File(outputFolder, String.valueOf(this.sketch.getName()) + ".java");
                    stream = new PrintWriter(new FileWriter(java));
                    try {
                        result = preprocessor.write(stream, bigCode.toString(), codeFolderPackages);
                        break block39;
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                    msg = "Build folder disappeared or could not be written";
                    throw new SketchException(msg);
                }
                catch (RecognitionException re) {
                    errorLine = re.getLine() - 1;
                    errorFile = this.findErrorFile(errorLine);
                    errorLine -= this.sketch.getCode(errorFile).getPreprocOffset();
                    msg = re.getMessage();
                    if (msg.contains("expecting RCURLY")) {
                        throw new SketchException("Found one too many { characters without a } to match it.", errorFile, errorLine, re.getColumn(), false);
                    }
                    if (msg.contains("expecting LCURLY")) {
                        System.err.println(msg);
                        suffix = ".";
                        m = PApplet.match((String)msg, (String)"found ('.*')");
                        if (m != null) {
                            suffix = ", not " + m[1] + ".";
                        }
                        throw new SketchException("Was expecting a { character" + suffix, errorFile, errorLine, re.getColumn(), false);
                    }
                    if (msg.indexOf("expecting RBRACK") != -1) {
                        System.err.println(msg);
                        throw new SketchException("Syntax error, maybe a missing ] character?", errorFile, errorLine, re.getColumn(), false);
                    }
                    if (msg.indexOf("expecting SEMI") != -1) {
                        System.err.println(msg);
                        throw new SketchException("Syntax error, maybe a missing semicolon?", errorFile, errorLine, re.getColumn(), false);
                    }
                    if (msg.indexOf("expecting RPAREN") != -1) {
                        System.err.println(msg);
                        throw new SketchException("Syntax error, maybe a missing right parenthesis?", errorFile, errorLine, re.getColumn(), false);
                    }
                    if (msg.indexOf("preproc.web_colors") != -1) {
                        throw new SketchException("A web color (such as #ffcc00) must be six digits.", errorFile, errorLine, re.getColumn(), false);
                    }
                    throw new SketchException(msg, errorFile, errorLine, re.getColumn(), false);
                }
                catch (TokenStreamRecognitionException tsre) {
                    mess = "^line (\\d+):(\\d+):\\s";
                    matches = PApplet.match((String)tsre.toString(), (String)mess);
                    if (matches == null) break block40;
                    errorLine = Integer.parseInt(matches[1]) - 1;
                    errorColumn = Integer.parseInt(matches[2]);
                    errorFile = 0;
                    i = 1;
                    ** while (i < this.sketch.getCodeCount())
                }
lbl-1000:
                // 1 sources

                {
                    sc = this.sketch.getCode(i);
                    if (sc.isExtension("pde") && sc.getPreprocOffset() < errorLine) {
                        errorFile = i;
                    }
                    ++i;
                    continue;
                }
lbl84:
                // 1 sources

                throw new SketchException(tsre.getMessage(), errorFile, errorLine -= this.sketch.getCode(errorFile).getPreprocOffset(), errorColumn);
            }
            msg = tsre.toString();
            throw new SketchException(msg, 0, -1, -1);
            catch (SketchException pe) {
                throw pe;
            }
            catch (Exception ex) {
                System.err.println("Uncaught exception type:" + ex.getClass());
                ex.printStackTrace();
                throw new SketchException(ex.toString());
            }
        }
        this.importedLibraries = new ArrayList<E>();
        core = this.mode.getCoreLibrary();
        if (core != null) {
            this.importedLibraries.add(core);
            this.classPath = String.valueOf(this.classPath) + core.getClassPath();
        }
        for (String item : result.extraImports) {
            dot = item.lastIndexOf(46);
            v0 = entry = dot == -1 ? item : item.substring(0, dot);
            if (item.startsWith("static ")) {
                dot2 = item.lastIndexOf(46);
                entry = entry.substring(7, dot2 == -1 ? entry.length() : dot2);
            }
            if ((library = this.mode.getLibrary(entry)) != null) {
                if (this.importedLibraries.contains(library)) continue;
                this.importedLibraries.add(library);
                this.classPath = String.valueOf(this.classPath) + library.getClassPath();
                this.javaLibraryPath = String.valueOf(this.javaLibraryPath) + File.pathSeparator + library.getNativePath();
                continue;
            }
            found = false;
            if (codeFolderPackages != null) {
                itemPkg = entry;
                var20_47 = codeFolderPackages;
                var19_46 = codeFolderPackages.length;
                var18_43 = 0;
                while (var18_43 < var19_46) {
                    pkg = var20_47[var18_43];
                    if (pkg.equals(itemPkg)) {
                        found = true;
                        break;
                    }
                    ++var18_43;
                }
            }
            if (this.ignorableImport(String.valueOf(entry) + '.')) {
                found = true;
            }
            if (found) continue;
            System.err.println("No library found for " + entry);
        }
        javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath.startsWith("\"") && javaClassPath.endsWith("\"")) {
            javaClassPath = javaClassPath.substring(1, javaClassPath.length() - 1);
        }
        this.classPath = String.valueOf(this.classPath) + File.pathSeparator + javaClassPath;
        var14_34 = this.sketch.getCode();
        var13_31 = var14_34.length;
        var12_27 = 0;
        while (var12_27 < var13_31) {
            sc = var14_34[var12_27];
            if (sc.isExtension("java")) {
                filename = sc.getFileName();
                try {
                    javaCode = sc.getProgram();
                    packageMatch = PApplet.match((String)javaCode, (String)"(?:^|\\s|;)package\\s+(\\S+)\\;");
                    if (packageMatch == null && packageName == null) {
                        sc.copyTo(new File(srcFolder, filename));
                    }
                    if (packageMatch == null) {
                        packageMatch = new String[]{packageName};
                        javaCode = "package " + packageName + ";" + javaCode;
                    }
                    packageFolder = new File(srcFolder, packageMatch[0].replace('.', '/'));
                    packageFolder.mkdirs();
                    Base.saveFile(javaCode, new File(packageFolder, filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    msg = "Problem moving " + filename + " to the build folder";
                    throw new SketchException(msg);
                }
            } else if (sc.isExtension("pde")) {
                sc.addPreprocOffset(result.headerOffset);
            }
            ++var12_27;
        }
        this.foundMain = preprocessor.hasMethod("main");
        return result.className;
    }

    protected boolean ignorableImport(String pkg) {
        if (pkg.startsWith("java.")) {
            return true;
        }
        if (pkg.startsWith("javax.")) {
            return true;
        }
        if (pkg.startsWith("processing.core.")) {
            return true;
        }
        if (pkg.startsWith("processing.data.")) {
            return true;
        }
        if (pkg.startsWith("processing.event.")) {
            return true;
        }
        return pkg.startsWith("processing.opengl.");
    }

    protected int findErrorFile(int errorLine) {
        int i = this.sketch.getCodeCount() - 1;
        while (i > 0) {
            SketchCode sc = this.sketch.getCode(i);
            if (sc.isExtension("pde") && sc.getPreprocOffset() <= errorLine) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public String getSketchPath() {
        return this.sketch.getFolder().getAbsolutePath();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getJavaLibraryPath() {
        return this.javaLibraryPath;
    }

    public boolean getFoundMain() {
        return this.foundMain;
    }

    public ArrayList<Library> getImportedLibraries() {
        return this.importedLibraries;
    }

    public SketchException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        SketchCode code;
        int codeIndex = 0;
        int codeLine = -1;
        int i = 0;
        while (i < this.sketch.getCodeCount()) {
            code = this.sketch.getCode(i);
            if (code.isExtension("java") && dotJavaFilename.equals(code.getFileName())) {
                codeIndex = i;
                codeLine = dotJavaLine;
                return new SketchException(message, codeIndex, codeLine);
            }
            ++i;
        }
        if (!dotJavaFilename.equals(String.valueOf(this.sketch.getName()) + ".java")) {
            return null;
        }
        codeIndex = 0;
        i = 0;
        while (i < this.sketch.getCodeCount()) {
            code = this.sketch.getCode(i);
            if (code.isExtension("pde") && code.getPreprocOffset() <= dotJavaLine) {
                codeIndex = i;
                codeLine = dotJavaLine - code.getPreprocOffset();
            }
            ++i;
        }
        return new SketchException(message, codeIndex, codeLine, -1, false);
    }

    protected boolean exportApplication() throws IOException, SketchException {
        String foundName = this.build(true);
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getName().equals(foundName)) {
            Base.showWarning("Error during export", "Sketch name is " + this.sketch.getName() + " but the sketch\n" + "name in the code was " + foundName, null);
            return false;
        }
        File folder = null;
        String[] stringArray = PConstants.platformNames;
        int n = PConstants.platformNames.length;
        int n2 = 0;
        while (n2 < n) {
            boolean embedJava;
            String platformName = stringArray[n2];
            int platform = Base.getPlatformIndex(platformName);
            boolean bl = embedJava = platform == PApplet.platform && Preferences.getBoolean("export.application.embed_java");
            if (Preferences.getBoolean("export.application.platform." + platformName)) {
                if (Library.hasMultipleArch(platform, this.importedLibraries)) {
                    folder = new File(this.sketch.getFolder(), "application." + platformName + "32");
                    if (!this.exportApplication(folder, platform, 32, embedJava && Base.getNativeBits() == 32)) {
                        return false;
                    }
                    folder = new File(this.sketch.getFolder(), "application." + platformName + "64");
                    if (!this.exportApplication(folder, platform, 64, embedJava && Base.getNativeBits() == 64)) {
                        return false;
                    }
                } else {
                    folder = new File(this.sketch.getFolder(), "application." + platformName);
                    if (!this.exportApplication(folder, platform, 0, embedJava)) {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    protected boolean exportApplication(File destFolder, int exportPlatform, int exportBits, boolean embedJava) throws IOException, SketchException {
        int i;
        for (Library library : this.importedLibraries) {
            if (library.supportsArch(exportPlatform, exportBits)) continue;
            String pn = PConstants.platformNames[exportPlatform];
            Base.showWarning("Quibbles 'n Bits", "The application." + pn + exportBits + " folder will not be created\n" + "because no " + exportBits + "-bit version of " + library.getName() + " is available for " + pn, null);
            return true;
        }
        this.mode.prepareExportFolder(destFolder);
        File jarFolder = new File(destFolder, "lib");
        File dotAppFolder = null;
        String jvmRuntime = "";
        String jdkPath = null;
        if (exportPlatform == 2) {
            dotAppFolder = new File(destFolder, String.valueOf(this.sketch.getName()) + ".app");
            File contentsOrig = new File(Base.getJavaHome(), "../../../../..");
            if (embedJava) {
                File jdkFolder = new File(Base.getJavaHome(), "../../..");
                String jdkFolderName = jdkFolder.getCanonicalFile().getName();
                jvmRuntime = "<key>JVMRuntime</key>\n    <string>" + jdkFolderName + "</string>";
                jdkPath = new File(dotAppFolder, "Contents/PlugIns/" + jdkFolderName + ".jdk").getAbsolutePath();
            }
            File contentsFolder = new File(dotAppFolder, "Contents");
            contentsFolder.mkdirs();
            jarFolder = new File(contentsFolder, "Java");
            File macosFolder = new File(contentsFolder, "MacOS");
            macosFolder.mkdirs();
            Base.copyFile(new File(contentsOrig, "MacOS/Processing"), new File(contentsFolder, "MacOS/" + this.sketch.getName()));
            File pkgInfo = new File(contentsFolder, "PkgInfo");
            PrintWriter writer = PApplet.createWriter((File)pkgInfo);
            writer.println("APPL????");
            writer.flush();
            writer.close();
            if (embedJava) {
                Base.copyDirNative(new File(contentsOrig, "PlugIns"), new File(contentsFolder, "PlugIns"));
            }
            File resourcesFolder = new File(contentsFolder, "Resources");
            Base.copyDir(new File(contentsOrig, "Resources/en.lproj"), new File(resourcesFolder, "en.lproj"));
            Base.copyFile(this.mode.getContentFile("application/sketch.icns"), new File(resourcesFolder, "sketch.icns"));
        } else if (exportPlatform == 3) {
            if (embedJava) {
                Base.copyDirNative(Base.getJavaHome(), new File(destFolder, "java"));
            }
        } else if (exportPlatform == 1 && embedJava) {
            Base.copyDir(Base.getJavaHome(), new File(destFolder, "java"));
        }
        if (!jarFolder.exists()) {
            jarFolder.mkdirs();
        }
        Vector<String> jarListVector = new Vector<String>();
        FileOutputStream zipOutputFile = new FileOutputStream(new File(jarFolder, String.valueOf(this.sketch.getName()) + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        this.addManifest(zos);
        this.addClasses(zos, this.binFolder);
        if (this.sketch.hasDataFolder()) {
            if (exportPlatform == 2) {
                Base.copyDir(this.sketch.getDataFolder(), new File(jarFolder, "data"));
            } else {
                Base.copyDir(this.sketch.getDataFolder(), new File(destFolder, "data"));
            }
        }
        if (this.sketch.hasCodeFolder()) {
            String includes = Base.contentsToClassPath(this.sketch.getCodeFolder());
            String[] codeList = PApplet.splitTokens((String)includes, (String)File.pathSeparator);
            int i2 = 0;
            while (i2 < codeList.length) {
                if (codeList[i2].toLowerCase().endsWith(".jar") || ((String)codeList[i2]).toLowerCase().endsWith(".zip")) {
                    File exportFile = new File((String)codeList[i2]);
                    String exportFilename = exportFile.getName();
                    Base.copyFile(exportFile, new File(jarFolder, exportFilename));
                    jarListVector.add(exportFilename);
                }
                ++i2;
            }
        }
        zos.flush();
        zos.close();
        jarListVector.add(String.valueOf(this.sketch.getName()) + ".jar");
        for (Library library : this.importedLibraries) {
            File[] fileArray = library.getApplicationExports(exportPlatform, exportBits);
            int exportFilename = fileArray.length;
            int exportFile = 0;
            while (exportFile < exportFilename) {
                File exportFile2 = fileArray[exportFile];
                String exportName = exportFile2.getName();
                if (!exportFile2.exists()) {
                    System.err.println(String.valueOf(exportFile2.getName()) + " is mentioned in export.txt, but it's " + "a big fat lie and does not exist.");
                } else if (exportFile2.isDirectory()) {
                    Base.copyDir(exportFile2, new File(jarFolder, exportName));
                } else if (exportName.toLowerCase().endsWith(".zip") || exportName.toLowerCase().endsWith(".jar")) {
                    Base.copyFile(exportFile2, new File(jarFolder, exportName));
                    jarListVector.add(exportName);
                } else {
                    Base.copyFile(exportFile2, new File(jarFolder, exportName));
                }
                ++exportFile;
            }
        }
        Object[] jarList = new String[jarListVector.size()];
        jarListVector.copyInto(jarList);
        StringBuffer exportClassPath = new StringBuffer();
        if (exportPlatform == 2) {
            i = 0;
            while (i < jarList.length) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$JAVAROOT/" + (String)jarList[i]);
                ++i;
            }
        } else if (exportPlatform == 1) {
            i = 0;
            while (i < jarList.length) {
                if (i != 0) {
                    exportClassPath.append(",");
                }
                exportClassPath.append((String)jarList[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < jarList.length) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$APPDIR/lib/" + (String)jarList[i]);
                ++i;
            }
        }
        ArrayList<String> runOptions = new ArrayList<String>();
        if (Preferences.getBoolean("run.options.memory")) {
            runOptions.add("-Xms" + Preferences.get("run.options.memory.initial") + "m");
            runOptions.add("-Xmx" + Preferences.get("run.options.memory.maximum") + "m");
        }
        runOptions.add("-Djna.nosys=true");
        if (exportPlatform == 2) {
            StringBuilder runOptionsXML = new StringBuilder();
            for (String opt : runOptions) {
                runOptionsXML.append("      <string>");
                runOptionsXML.append(opt);
                runOptionsXML.append("</string>");
                runOptionsXML.append('\n');
            }
            String PLIST_TEMPLATE = "Info.plist.tmpl";
            File plistTemplate = new File(this.sketch.getFolder(), PLIST_TEMPLATE);
            if (!plistTemplate.exists()) {
                plistTemplate = this.mode.getContentFile("application/" + PLIST_TEMPLATE);
            }
            File plistFile = new File(dotAppFolder, "Contents/Info.plist");
            PrintWriter pw = PApplet.createWriter((File)plistFile);
            String[] lines = PApplet.loadStrings((File)plistTemplate);
            int i3 = 0;
            while (i3 < lines.length) {
                if (lines[i3].indexOf("@@") != -1) {
                    StringBuffer sb = new StringBuffer(lines[i3]);
                    int index = 0;
                    while ((index = sb.indexOf("@@jvm_runtime@@")) != -1) {
                        sb.replace(index, index + "@@jvm_runtime@@".length(), jvmRuntime);
                    }
                    while ((index = sb.indexOf("@@jvm_options_list@@")) != -1) {
                        sb.replace(index, index + "@@jvm_options_list@@".length(), runOptionsXML.toString());
                    }
                    while ((index = sb.indexOf("@@sketch@@")) != -1) {
                        sb.replace(index, index + "@@sketch@@".length(), this.sketch.getName());
                    }
                    while ((index = sb.indexOf("@@lsuipresentationmode@@")) != -1) {
                        sb.replace(index, index + "@@lsuipresentationmode@@".length(), Preferences.getBoolean("export.application.fullscreen") ? "4" : "0");
                    }
                    lines[i3] = sb.toString();
                }
                pw.print(String.valueOf(lines[i3]) + "\n");
                ++i3;
            }
            pw.flush();
            pw.close();
            if (Base.isMacOS() && new File("/usr/bin/codesign_allocate").exists()) {
                if (embedJava) {
                    ProcessHelper.ffs("codesign", "--force", "--sign", "-", jdkPath);
                }
                String appPath = dotAppFolder.getAbsolutePath();
                ProcessHelper.ffs("codesign", "--force", "--sign", "-", appPath);
            }
        } else if (exportPlatform == 1) {
            File buildFile = new File(destFolder, "launch4j-build.xml");
            File configFile = new File(destFolder, "launch4j-config.xml");
            XML project = new XML("project");
            XML target = project.addChild("target");
            target.setString("name", "windows");
            XML taskdef = target.addChild("taskdef");
            taskdef.setString("name", "launch4j");
            taskdef.setString("classname", "net.sf.launch4j.ant.Launch4jTask");
            String launchPath = this.mode.getContentFile("application/launch4j").getAbsolutePath();
            taskdef.setString("classpath", String.valueOf(launchPath) + "/launch4j.jar:" + launchPath + "/lib/xstream.jar");
            XML launch4j = target.addChild("launch4j");
            launch4j.setString("configFile", configFile.getAbsolutePath());
            XML config = new XML("launch4jConfig");
            config.addChild("headerType").setContent("gui");
            config.addChild("dontWrapJar").setContent("true");
            config.addChild("downloadUrl").setContent("http://java.com/download");
            File exeFile = new File(destFolder, String.valueOf(this.sketch.getName()) + ".exe");
            config.addChild("outfile").setContent(exeFile.getAbsolutePath());
            File iconFile = this.mode.getContentFile("application/sketch.ico");
            config.addChild("icon").setContent(iconFile.getAbsolutePath());
            XML clazzPath = config.addChild("classPath");
            clazzPath.addChild("mainClass").setContent(this.sketch.getName());
            Object[] objectArray = jarList;
            int n = jarList.length;
            int n2 = 0;
            while (n2 < n) {
                Object jarName = objectArray[n2];
                clazzPath.addChild("cp").setContent("lib/" + (String)jarName);
                ++n2;
            }
            XML jre = config.addChild("jre");
            if (embedJava) {
                jre.addChild("path").setContent("java");
            }
            jre.addChild("minVersion").setContent("1.7.0_40");
            for (String opt : runOptions) {
                jre.addChild("opt").setContent(opt);
            }
            config.save(configFile);
            project.save(buildFile);
            if (!this.buildWindowsLauncher(buildFile, "windows")) {
                return false;
            }
            configFile.delete();
            buildFile.delete();
        } else {
            File shellScript = new File(destFolder, this.sketch.getName());
            PrintWriter pw = PApplet.createWriter((File)shellScript);
            pw.print("#!/bin/sh\n\n");
            pw.print("APPDIR=$(dirname \"$0\")\n");
            if (embedJava) {
                pw.print("$APPDIR/java/bin/");
            }
            String runOptionsStr = PApplet.join((String[])runOptions.toArray(new String[0]), (String)" ");
            pw.print("java " + runOptionsStr + " -Djava.library.path=\"$APPDIR:$APPDIR/lib\"" + " -cp \"" + exportClassPath + "\"" + " " + this.sketch.getName() + " \"$@\"\n");
            pw.flush();
            pw.close();
            String shellPath = shellScript.getAbsolutePath();
            if (!Base.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", shellPath});
            }
        }
        File sourceFolder = new File(destFolder, "source");
        sourceFolder.mkdirs();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int runOptionsStr = 0;
        while (runOptionsStr < n) {
            SketchCode code = sketchCodeArray[runOptionsStr];
            try {
                code.copyTo(new File(sourceFolder, code.getFileName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++runOptionsStr;
        }
        String preprocFilename = String.valueOf(this.sketch.getName()) + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            Base.copyFile(preprocFile, new File(sourceFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        return true;
    }

    protected boolean buildWindowsLauncher(File buildFile, String target) {
        Project p = new Project();
        String path = buildFile.getAbsolutePath().replace('\\', '/');
        p.setUserProperty("ant.file", path);
        p.setUserProperty("build.compiler", "extJavac");
        DefaultLogger errorLogger = new DefaultLogger();
        ByteArrayOutputStream errb = new ByteArrayOutputStream();
        PrintStream errp = new PrintStream(errb);
        errorLogger.setErrorPrintStream(errp);
        ByteArrayOutputStream outb = new ByteArrayOutputStream();
        PrintStream outp = new PrintStream(outb);
        errorLogger.setOutputPrintStream(outp);
        errorLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)errorLogger);
        try {
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(target);
            return true;
        }
        catch (BuildException e) {
            p.fireBuildFinished((Throwable)e);
            String out = new String(outb.toByteArray());
            String err = new String(errb.toByteArray());
            System.out.println(out);
            System.err.println(err);
            return false;
        }
    }

    protected void addManifest(ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zos.putNextEntry(entry);
        String contents = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.getVersionName() + "\n" + "Main-Class: " + this.sketch.getName() + "\n";
        zos.write(contents.getBytes());
        zos.closeEntry();
    }

    protected void addClasses(ZipOutputStream zos, File dir) throws IOException {
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = String.valueOf(path) + '/';
        }
        this.addClasses(zos, dir, path);
    }

    protected void addClasses(ZipOutputStream zos, File dir, String rootPath) throws IOException {
        File[] files;
        File[] fileArray = files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.charAt(0) != '.';
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File sub = fileArray[n2];
            String relativePath = sub.getAbsolutePath().substring(rootPath.length());
            if (sub.isDirectory()) {
                this.addClasses(zos, sub, rootPath);
            } else if (sub.getName().endsWith(".class")) {
                ZipEntry entry = new ZipEntry(relativePath);
                zos.putNextEntry(entry);
                PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(sub));
                zos.closeEntry();
            }
            ++n2;
        }
    }

    protected void addDataFolder(ZipOutputStream zos) throws IOException {
        if (this.sketch.hasDataFolder()) {
            String[] dataFiles = Base.listFiles(this.sketch.getDataFolder(), false);
            int offset = this.sketch.getFolder().getAbsolutePath().length() + 1;
            String[] stringArray = dataFiles;
            int n = dataFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dataFile;
                String path = stringArray[n2];
                if (Base.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if (!(dataFile = new File(path)).isDirectory() && dataFile.getName().charAt(0) != '.') {
                    ZipEntry entry = new ZipEntry(path.substring(offset));
                    zos.putNextEntry(entry);
                    PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(dataFile));
                    zos.closeEntry();
                }
                ++n2;
            }
        }
    }

    protected void packClassPathIntoZipFile(String path, ZipOutputStream zos, HashMap<String, Object> zipFileContents) throws IOException {
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        int i = 0;
        while (i < pieces.length) {
            if (pieces[i].length() != 0) {
                if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                    try {
                        ZipFile file = new ZipFile(pieces[i]);
                        Enumeration<? extends ZipEntry> entries = file.entries();
                        while (entries.hasMoreElements()) {
                            String entryName;
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory() || (entryName = entry.getName()).indexOf("META-INF") == 0 || zipFileContents.get(entryName) != null) continue;
                            zipFileContents.put(entryName, new Object());
                            ZipEntry entree = new ZipEntry(entryName);
                            zos.putNextEntry(entree);
                            byte[] buffer = new byte[(int)entry.getSize()];
                            InputStream is = file.getInputStream(entry);
                            int offset = 0;
                            int remaining = buffer.length;
                            while (remaining > 0) {
                                int count = is.read(buffer, offset, remaining);
                                offset += count;
                                remaining -= count;
                            }
                            zos.write(buffer);
                            zos.flush();
                            zos.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Error in file " + pieces[i]);
                        e.printStackTrace();
                    }
                } else {
                    File dir = new File(pieces[i]);
                    if (dir.exists()) {
                        JavaBuild.packClassPathIntoZipFileRecursive(dir, null, zos);
                    }
                }
            }
            ++i;
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].charAt(0) != '.') {
                String nowfar;
                File sub = new File(dir, files[i]);
                String string = nowfar = sofar == null ? files[i] : String.valueOf(sofar) + "/" + files[i];
                if (sub.isDirectory()) {
                    JavaBuild.packClassPathIntoZipFileRecursive(sub, nowfar, zos);
                } else if (!files[i].toLowerCase().endsWith(".jar") && !files[i].toLowerCase().endsWith(".zip") && files[i].charAt(0) != '.') {
                    ZipEntry entry = new ZipEntry(nowfar);
                    zos.putNextEntry(entry);
                    PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(sub));
                    zos.closeEntry();
                }
            }
            ++i;
        }
    }
}

