/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.NamedAndTyped;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.Objects;
import java.io.Serializable;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable,
Serializable {
    private final int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;

    public LocalVariableGen(int n, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Invalid index index: " + n);
        }
        this.name = string;
        this.type = type;
        this.index = n;
        this.setStart(instructionHandle);
        this.setEnd(instructionHandle2);
    }

    public LocalVariable getLocalVariable(ConstantPoolGen constantPoolGen) {
        int n = this.start.getPosition();
        int n2 = this.end.getPosition() - n;
        if (n2 > 0) {
            n2 += this.end.getInstruction().getLength();
        }
        int n3 = constantPoolGen.addUtf8(this.name);
        int n4 = constantPoolGen.addUtf8(this.type.getSignature());
        return new LocalVariable(n, n2, n3, n4, this.index, constantPoolGen.getConstantPool());
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    void notifyTargetChanging() {
        BranchInstruction.notifyTargetChanging(this.start, this);
        if (this.end != this.start) {
            BranchInstruction.notifyTargetChanging(this.end, this);
        }
    }

    void notifyTargetChanged() {
        BranchInstruction.notifyTargetChanged(this.start, this);
        if (this.end != this.start) {
            BranchInstruction.notifyTargetChanged(this.end, this);
        }
    }

    public final void setStart(InstructionHandle instructionHandle) {
        this.notifyTargetChanging();
        this.start = instructionHandle;
        this.notifyTargetChanged();
    }

    public final void setEnd(InstructionHandle instructionHandle) {
        this.notifyTargetChanging();
        this.end = instructionHandle;
        this.notifyTargetChanged();
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.start == instructionHandle) {
            bl = true;
            this.setStart(instructionHandle2);
        }
        if (this.end == instructionHandle) {
            bl = true;
            this.setEnd(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start == instructionHandle || this.end == instructionHandle;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen localVariableGen = (LocalVariableGen)object;
        return localVariableGen.index == this.index && localVariableGen.start == this.start && localVariableGen.end == this.end;
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + this.index;
        n = 59 * n + Objects.hashCode(this.start);
        n = 59 * n + Objects.hashCode(this.end);
        return n;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }
}

