#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER
#extension GL_EXT_gpu_shader4 : enable

uniform float iGlobalTime;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main()
{
	vec4 coord = vertTexCoord;
	float minV = 99999999.0;
	float maxV = 0.0;
	vec4 ave = vec4(0);
	vec2 basePos = vec2(coord.x - mod(coord.x, 0.01), coord.y - mod(coord.y, 0.01));
	float t = 0.0;
	float lim = 0.02 * abs(sin(iGlobalTime / 1000));
	if (mod(basePos.x, 0.02) < lim && coord.y < 0.83)
	{
		for (float x = -0.005; x < 0.005; x += 0.001)
		{
			for (float y = -0.005; y < 0.005; y += 0.001)
			{
				vec4 c = texture2D(texture, vec2(max(0.0, basePos.x - x), max(0.0, basePos.y - y)));
				float v = (c.x + c.y + c.z) / 3.0;
				maxV = max(v, maxV);
				minV = min(v, minV);
				ave += c;
				t += 1.0;
			}
		}
		ave /= t;
		if (maxV - minV > 0.3)
		{
			gl_FragColor = ave;
		}
		else
		{
			gl_FragColor = texture2D(texture, vertTexCoord.xy); // * vertColor); // + (ave * 0.1);
		}
	}
	else
	{
		gl_FragColor = texture2D(texture, vertTexCoord.xy); // * vertColor;
	}
}