#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float iGlobalTime;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main()
{
	vec4 coord = vertTexCoord;
	vec3 v1 = vec3(coord.x + (sin(iGlobalTime / 400) * 0.01), coord.y + (sin(coord.x) / (abs((iGlobalTime - 80000) / 1000) * 16.0)), coord.z * 1.01);
	vec3 v2 = normalize(refract(coord.xyz, v1, 0.85));
	float colorR = (texture2D(texture, (v2 * v2) + coord) * vertColor).x;
	float colorG = (texture2D(texture, v2 * v1) * vertColor).y;
	float colorB = (texture2D(texture, (1.0 - dot(v2, v1)) * v1) * vertColor).z;
	vec3 c2 = texture2D(texture, coord * dot(coord, normalize(coord)));
	gl_FragColor = vec4(colorR * c2.x, colorG * c2.y, colorB * c2.z, 1.0) * 1.2;
}