#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float iAmount;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

float magnitude(vec3 pixel)
{
	return (pixel.x + pixel.y + pixel.z) / 3.0;
}

void main()
{
	vec4 coord = vertTexCoord;
	vec4 right = texture2D(texture, vec2(coord.x + 0.001));
	vec4 left = texture2D(texture, vec2(coord.x + 0.001));
	float intensity = abs(sin(magnitude(right.xyz) * 0.2) + sin(magnitude(left.xyz) * 0.1));
	vec4 effect = texture2D(texture, coord.xy) * intensity;
	gl_FragColor = mix(effect, texture2D(texture, coord.xy), iAmount);
}