#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float offsetRX;
uniform float offsetRY;
uniform float offsetGX;
uniform float offsetGY;
uniform float offsetBX;
uniform float offsetBY;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main()
{
	vec4 coord = vertTexCoord;
	float colorR = (texture2D(texture, vec2(coord.x + offsetRX, coord.y + offsetRY)) * vertColor).x;
	float colorG = (texture2D(texture, vec2(coord.x + offsetGX, coord.y + offsetGY)) * vertColor).y;
	float colorB = (texture2D(texture, vec2(coord.x + offsetBX, coord.y + offsetBY)) * vertColor).z;
	gl_FragColor = vec4(colorR, colorG, colorB, 1.0);
}