#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float iGlobalTime;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main()
{
	vec4 coord = vertTexCoord;
	float scalar = 0.90 + (abs(sin(coord.y * 500.0)) * 0.10);
	scalar = max(scalar, abs(sin(iGlobalTime / 500.0)));
	gl_FragColor = texture2D(texture, coord.xy) * vertColor * scalar;
}