#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float iGlobalTime;
uniform float iAmount;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

float rand(vec2 co)
{
    return fract(sin(dot(co.xy, vec2(12.9898,78.233)) + iGlobalTime) * 43758.5453);
}

void main()
{
	vec4 coord = vertTexCoord;
	vec3 realColor = texture2D(texture, coord.xy) * vertColor;
	vec3 noiseColor = vec3(rand(vec2(coord.x - mod(coord.x, 0.02 * (iAmount + 0.00001)), coord.y - mod(coord.y, 0.02 * (iAmount + 0.00001)))));
	/*
	if ((noiseColor.x + noiseColor.y + noiseColor.z) / 3.0 > 0.9)
	{
		float r = rand(vec2(0.31, 0.41));
		if (r < 0.333)
			noiseColor = vec3(0.5, 0.0, 0.0);
		else
		{
			if (r < 0.666)
				noiseColor = vec3(0.0, 0.5, 0.0);
			else
				noiseColor = vec3(0.0, 0.0, 0.5);
		}
	}
	*/
	gl_FragColor = vec4((realColor * (1.0 - iAmount)) + (noiseColor * iAmount), 1.0);
}